/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onradar.sdk.Radar;
import com.onradar.sdk.RadarCallback;
import com.onradar.sdk._RadarCallback;
import com.onradar.sdk._RadarClient;
import com.onradar.sdk._RadarJobService;
import com.onradar.sdk._RadarLocationRequest;
import com.onradar.sdk._RadarLogger;
import com.onradar.sdk._RadarSettings;
import com.onradar.sdk._RadarUtils;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

class _Radar
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static _Radar sInstance;
    private Context mContext;
    private GoogleApiClient mGoogleApiClient;
    private List<_RadarLocationRequest> mLocationRequests;
    private boolean mStopTrackingPending;
    private boolean mRequestLocationOncePending;
    private boolean mUpdateGeofencesPending;
    private LocationListener mRequestLocationOnceListener;

    _Radar() {
    }

    static synchronized _Radar getSharedInstance() {
        if (sInstance == null) {
            sInstance = new _Radar();
        }
        return sInstance;
    }

    void initialize(Context context, String publishableKey) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        if (publishableKey == null) {
            _RadarSettings.readPublishableKey(context);
        } else {
            _RadarSettings.setPublishableKey(context, publishableKey);
        }
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mUpdateGeofencesPending = true;
            this.mGoogleApiClient.connect();
        }
        if (this.mLocationRequests == null) {
            this.mLocationRequests = new ArrayList<_RadarLocationRequest>();
        }
        _RadarSettings.setAdId(this.mContext);
    }

    void setUserId(String userId) {
        _RadarSettings.setUserId(this.mContext, userId);
    }

    void setDescription(String description) {
        _RadarSettings.setDescription(this.mContext, description);
    }

    void setPlacesProvider(Radar.RadarPlacesProvider provider) {
        _RadarSettings.setPlacesProvider(this.mContext, provider);
    }

    boolean checkSelfPermissions() {
        return Build.VERSION.SDK_INT < 23 || this.mContext != null && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    void requestPermissions(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            int requestCode = 0;
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
        }
    }

    void trackOnce(RadarCallback callback) {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = _RadarSettings.getUserId(this.mContext);
        if (userId == null || userId.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_USER_ID, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (!this.checkSelfPermissions()) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PERMISSIONS, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        _RadarLocationRequest locationRequest = new _RadarLocationRequest(10000L, callback);
        this.mLocationRequests.add(locationRequest);
        this.mUpdateGeofencesPending = true;
        this.requestLocationOnce();
    }

    void startTracking() {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = _RadarSettings.getUserId(this.mContext);
        if (userId == null || userId.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (!this.checkSelfPermissions()) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        _RadarSettings.setTracking(this.mContext, true);
        this.mUpdateGeofencesPending = true;
        this.requestLocationOnce();
        this.scheduleAlarm();
    }

    void stopTracking() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mStopTrackingPending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        _RadarSettings.setTracking(this.mContext, false);
        this.removeGeofences(false);
        this.cancelAlarm();
    }

    boolean isTracking() {
        return _RadarSettings.getTracking(this.mContext);
    }

    void updateLocation(Location location, RadarCallback callback) {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = _RadarSettings.getUserId(this.mContext);
        if (userId == null || userId.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        this.sendLocation(location, true, false, callback);
    }

    private void sendLocation(final Location location, boolean foreground, final boolean stopped, final RadarCallback callback) {
        _RadarLogger.log(this.mContext, "sending location");
        _RadarLogger.notify(this.mContext, "sending location");
        for (_RadarLocationRequest locationRequest : this.mLocationRequests) {
            locationRequest.stopTimer();
        }
        _RadarSettings.updateSentAt(this.mContext);
        _RadarClient.getSharedInstance().updateLocation(this.mContext, location, foreground, stopped, new _RadarCallback(){

            @Override
            public void onCallback(Radar.RadarStatus status, JSONObject response, RadarEvent[] events, RadarUser user) {
                if (status == Radar.RadarStatus.SUCCESS) {
                    _RadarLogger.log(_Radar.this.mContext, "sent location");
                    _RadarLogger.notify(_Radar.this.mContext, "sent location");
                    if (callback != null) {
                        callback.onCallback(status, location, events, user);
                    } else {
                        for (_RadarLocationRequest locationRequest : _Radar.this.mLocationRequests) {
                            RadarCallback callback2 = locationRequest.getCallback();
                            if (callback2 != null) {
                                callback2.onCallback(status, location, events, user);
                            }
                            _Radar.this.mLocationRequests.remove(locationRequest);
                        }
                    }
                    _Radar.getSharedInstance().sendSuccessIntent(response);
                    if (stopped) {
                        _Radar.getSharedInstance().removeGeofences(true);
                    }
                } else {
                    _RadarLogger.log(_Radar.this.mContext, "error sending location");
                    _RadarLogger.notify(_Radar.this.mContext, "error sending location");
                    if (callback != null) {
                        callback.onCallback(status, location, null, null);
                    } else {
                        for (_RadarLocationRequest locationRequest : _Radar.this.mLocationRequests) {
                            RadarCallback callback3 = locationRequest.getCallback();
                            if (callback3 != null) {
                                callback3.onCallback(status, null, null, null);
                            }
                            _Radar.this.mLocationRequests.remove(locationRequest);
                        }
                        _Radar.this.mLocationRequests.clear();
                    }
                    _Radar.getSharedInstance().sendErrorIntent(status);
                }
            }
        });
    }

    void verifyEvent(String eventId, RadarEvent.RadarEventVerification verification) {
        _RadarClient.getSharedInstance().verifyEvent(this.mContext, eventId, verification);
    }

    boolean isWifiEnabled() {
        return _RadarUtils.isWifiEnabled(this.mContext);
    }

    private void cancelAlarm() {
        if (Build.VERSION.SDK_INT >= 21) {
            JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
            jobScheduler.cancel(1337);
        } else {
            Intent intent = new Intent("com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
        }
    }

    private void scheduleAlarm() {
        this.cancelAlarm();
        _RadarLogger.log(this.mContext, "scheduling alarm");
        _RadarLogger.notify(this.mContext, "scheduling alarm");
        if (Build.VERSION.SDK_INT >= 21) {
            ComponentName component = new ComponentName(this.mContext, _RadarJobService.class);
            JobInfo.Builder builder = new JobInfo.Builder(1337, component).setPeriodic(900000L).setPersisted(true);
            JobInfo jobInfo = builder.build();
            JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
            jobScheduler.schedule(jobInfo);
        } else {
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            Intent intent = new Intent("com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            alarmManager.setInexactRepeating(2, 900000L, 900000L, pendingIntent);
        }
    }

    void didTimeout(_RadarLocationRequest locationRequest) {
        locationRequest.stopTimer();
        RadarCallback callback = locationRequest.getCallback();
        if (callback != null) {
            callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
        }
        this.mLocationRequests.remove(locationRequest);
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
        if (this.mRequestLocationOnceListener != null) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.mRequestLocationOnceListener);
            _RadarLogger.log(this.mContext, "stopped single location update");
        }
    }

    public void onConnected(Bundle connectionHint) {
        _RadarLogger.log(this.mContext, "Play Services connected");
        if (this.mRequestLocationOncePending) {
            this.mRequestLocationOncePending = false;
            this.requestLocationOnce();
        }
        if (this.mStopTrackingPending) {
            this.mStopTrackingPending = false;
            this.stopTracking();
        }
        if (this.mUpdateGeofencesPending) {
            this.mUpdateGeofencesPending = false;
            this.updateGeofences(null, false);
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult result) {
        _RadarLogger.log(this.mContext, "Play Services connection failed");
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onConnectionSuspended(int cause) {
        _RadarLogger.log(this.mContext, "Play Services connection suspended");
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    void onHandleIntent(Intent intent) {
        if (intent == null || !_RadarSettings.getTracking(this.mContext)) {
            return;
        }
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            _RadarLogger.log(this.mContext, "boot completed");
            _RadarLogger.notify(this.mContext, "boot completed");
            this.updateGeofences(null, false);
        } else if (intent.getAction().equals("com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED")) {
            _RadarLogger.log(this.mContext, "alarm triggered");
            _RadarLogger.notify(this.mContext, "alarm triggered");
            this.updateGeofences(null, false);
        } else if (intent.getAction().equals("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED")) {
            GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
            Geofence geofence = (Geofence)event.getTriggeringGeofences().get(0);
            Location location = event.getTriggeringLocation();
            if (event.getGeofenceTransition() == 2) {
                this.sendLocation(location, false, false, null);
                this.updateGeofences(location, true);
            } else {
                this.sendLocation(location, false, true, null);
            }
            _RadarLogger.log(this.mContext, "geofence triggered: " + geofence.getRequestId());
            _RadarLogger.notify(this.mContext, "geofence triggered: " + geofence.getRequestId());
        }
    }

    private void requestLocationOnce() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationOncePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.mRequestLocationOnceListener == null) {
            this.mRequestLocationOnceListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    _RadarLogger.log(_Radar.this.mContext, "location changed");
                    if (location == null) {
                        _RadarLogger.log(_Radar.this.mContext, "location is null");
                        return;
                    }
                    if (_Radar.this.mUpdateGeofencesPending) {
                        _Radar.getSharedInstance().updateGeofences(location, false);
                        _Radar.this.mUpdateGeofencesPending = false;
                    }
                    _Radar.getSharedInstance().sendLocation(location, true, false, null);
                    LocationServices.FusedLocationApi.removeLocationUpdates(_Radar.this.mGoogleApiClient, _Radar.this.mRequestLocationOnceListener);
                    _RadarLogger.log(_Radar.this.mContext, "stopped single location update");
                }
            };
        }
        _RadarLogger.log(this.mContext, "starting single location update");
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(5000L);
        locationRequest.setFastestInterval(1000L);
        locationRequest.setPriority(100);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, this.mRequestLocationOnceListener, Looper.getMainLooper());
        }
        catch (SecurityException e) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
        }
    }

    private void sendSuccessIntent(JSONObject response) {
        if (this.mContext == null || response == null) {
            return;
        }
        _RadarLogger.log(this.mContext, "sending success broadcast");
        String json = response.toString();
        Intent intent = new Intent("com.onradar.sdk.RECEIVED");
        intent.putExtra("response", json);
        this.mContext.sendBroadcast(intent);
    }

    private void sendErrorIntent(Radar.RadarStatus status) {
        if (this.mContext == null) {
            return;
        }
        _RadarLogger.log(this.mContext, "sending error broadcast");
        Intent intent = new Intent("com.onradar.sdk.RECEIVED");
        intent.putExtra("status", status.ordinal());
        this.mContext.sendBroadcast(intent);
    }

    void updateGeofences(Location location, boolean dwellPending) {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        if (location == null) {
            try {
                location = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
                if (location == null) {
                    _RadarLogger.log(this.mContext, "error updating geofences: location is null");
                    _RadarLogger.notify(this.mContext, "error updating geofences: location is null");
                    this.mUpdateGeofencesPending = true;
                    this.requestLocationOnce();
                    return;
                }
            }
            catch (SecurityException e) {
                return;
            }
        }
        _RadarLogger.log(this.mContext, "updating geofences");
        _RadarLogger.notify(this.mContext, "updating geofences");
        for (int i = 0; i < _RadarUtils.GEOFENCE_CONFIGS.length; ++i) {
            int[] config = _RadarUtils.GEOFENCE_CONFIGS[i];
            int radius = config[0];
            int dwell = config[1];
            String requestId = _RadarUtils.GEOFENCE_REQUEST_IDS[i];
            double longitude = location.getLongitude();
            double latitude = location.getLatitude();
            Geofence newGeofence = null;
            GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
            GeofencingRequest request = null;
            if (dwell == 0) {
                newGeofence = new Geofence.Builder().setRequestId(requestId).setTransitionTypes(2).setCircularRegion(latitude, longitude, (float)radius).setExpirationDuration(-1L).build();
                request = builder.addGeofence(newGeofence).setInitialTrigger(2).build();
            } else if (dwellPending) {
                newGeofence = new Geofence.Builder().setRequestId(requestId).setTransitionTypes(4).setLoiteringDelay(dwell).setCircularRegion(latitude, longitude, (float)radius).setExpirationDuration(-1L).build();
                request = builder.addGeofence(newGeofence).setInitialTrigger(4).build();
            }
            if (newGeofence == null) continue;
            Intent intent = new Intent("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
            try {
                PendingResult result = LocationServices.GeofencingApi.addGeofences(this.mGoogleApiClient, request, pendingIntent);
                result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                    public void onResult(@NonNull Status status) {
                        if (!status.isSuccess()) {
                            _RadarLogger.log(_Radar.this.mContext, "error adding geofence: " + status);
                            _RadarLogger.notify(_Radar.this.mContext, "error adding geofence");
                        }
                    }
                });
                continue;
            }
            catch (SecurityException e) {
                _RadarLogger.log(this.mContext, "exception adding geofences: " + e.getMessage());
                _RadarLogger.notify(this.mContext, "exception adding geofences");
            }
        }
    }

    private void removeGeofences(boolean dwellOnly) {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        try {
            final ArrayList<String> requestIds = new ArrayList<String>();
            for (int i = 0; i < _RadarUtils.GEOFENCE_CONFIGS.length; ++i) {
                int[] config = _RadarUtils.GEOFENCE_CONFIGS[i];
                int dwell = config[1];
                String requestId = _RadarUtils.GEOFENCE_REQUEST_IDS[i];
                if (dwellOnly && dwell <= 0) continue;
                requestIds.add(requestId);
            }
            PendingResult result = LocationServices.GeofencingApi.removeGeofences(this.mGoogleApiClient, requestIds);
            result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(@NonNull Status status) {
                    if (!status.isSuccess()) {
                        _RadarLogger.log(_Radar.this.mContext, "error removing geofences: " + status);
                        _RadarLogger.notify(_Radar.this.mContext, "error removing geofences: " + status);
                    } else {
                        _RadarLogger.log(_Radar.this.mContext, "removed geofences: " + requestIds);
                        _RadarLogger.notify(_Radar.this.mContext, "removed geofences: " + requestIds);
                    }
                }
            });
        }
        catch (SecurityException e) {
            _RadarLogger.log(this.mContext, "exception removing geofences: " + e.getMessage());
            _RadarLogger.notify(this.mContext, "exception removing geofences");
        }
    }
}

