package com.onradar.sdk.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

public class RadarUserInsights {

    private RadarUserInsightsLocation mHomeLocation;
    private RadarUserInsightsLocation mOfficeLocation;
    private RadarUserInsightsState mState;

    public RadarUserInsights(RadarUserInsightsLocation homeLocation, RadarUserInsightsLocation officeLocation, RadarUserInsightsState state) {
        mHomeLocation = homeLocation;
        mOfficeLocation = officeLocation;
        mState = state;
    }

    public RadarUserInsights(JSONObject obj) throws JSONException, ParseException {
        if (obj == null)
            return;

        if (obj.has("locations") && !obj.isNull("locations")) {
            JSONArray locationsArray = obj.getJSONArray("locations");
            int numLocations = locationsArray.length();

            for (int i = 0; i < numLocations; i++) {
                JSONObject locationObj = locationsArray.getJSONObject(i);
                RadarUserInsightsLocation location = new RadarUserInsightsLocation(locationObj);

                if (location.getType() == RadarUserInsightsLocation.RadarUserInsightsLocationType.HOME)
                    mHomeLocation = location;
                else if (location.getType() == RadarUserInsightsLocation.RadarUserInsightsLocationType.OFFICE)
                    mOfficeLocation = location;
            }
        }

        if (obj.has("state") && !obj.isNull("state")) {
            mState = new RadarUserInsightsState(obj.getJSONObject("state"));
        }
    }

    /**
     * @return The learned home location for the user. May be null.
     */
    public RadarUserInsightsLocation getHomeLocation() {
        return mHomeLocation;
    }

    /**
     * @return The learned office location for the user. May be null.
     */
    public RadarUserInsightsLocation getOfficeLocation() {
        return mOfficeLocation;
    }

    /**
     * @return The state of the user, based on learned home and office locations.
     */
    public RadarUserInsightsState getState() {
        return mState;
    }

}
