/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.location.Location;
import java.util.Date;

class _RadarSettings {
    _RadarSettings() {
    }

    static void setPublishableKey(Context context, String publishableKey) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-publishableKey", publishableKey);
        editor.commit();
    }

    static String readPublishableKey(Context context) {
        if (context == null) {
            return null;
        }
        try {
            String publishableKey = context.getResources().getString(context.getResources().getIdentifier("radar_pk", "string", context.getPackageName()));
            _RadarSettings.setPublishableKey(context, publishableKey);
            return publishableKey;
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    static String getPublishableKey(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-publishableKey", null);
    }

    static void setUserId(Context context, String userId) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-userId", userId);
        editor.commit();
    }

    static String getUserId(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-userId", null);
    }

    static void setDescription(Context context, String description) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-description", description);
        editor.commit();
    }

    static String getDescription(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-description", null);
    }

    static void setTracking(Context context, boolean tracking) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("radar-tracking", tracking);
        editor.commit();
    }

    static boolean getTracking(Context context) {
        if (context == null) {
            return false;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-tracking", false);
    }

    static void updateSentAt(Context context) {
        if (context == null) {
            return;
        }
        Date now = new Date();
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("radar-sentAt", now.getTime());
        editor.commit();
    }

    static Date getSentAt(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        long milliseconds = preferences.getLong("radar-sentAt", 0L);
        return new Date(milliseconds);
    }

    static void setLastLocation(Context context, Location location) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putFloat("radar-lastLocationLongitude", (float)location.getLongitude());
        editor.putFloat("radar-lastLocationLatitude", (float)location.getLatitude());
        editor.putFloat("radar-lastLocationAccuracy", location.getAccuracy());
        editor.putString("radar-lastLocationProvider", location.getProvider());
        editor.commit();
    }

    static Location getLastLocation(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        double longitude = preferences.getFloat("radar-lastLocationLongitude", 0.0f);
        double latitude = preferences.getFloat("radar-lastLocationLatitude", 0.0f);
        float accuracy = preferences.getFloat("radar-lastLocationAccuracy", 0.0f);
        String provider = preferences.getString("radar-lastLocationProvider", null);
        if (longitude == 0.0 || latitude == 0.0 || accuracy == 0.0f || provider == null) {
            return null;
        }
        Location location = new Location(provider);
        location.setLongitude(longitude);
        location.setLatitude(latitude);
        location.setAccuracy(accuracy);
        return location;
    }

    static String getHost(Context context) {
        String host = "https://www.onradar.com";
        if (context == null) {
            return host;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        host = preferences.getString("radar-host", host);
        return host;
    }

    static boolean isDebug(Context context) {
        if (context == null) {
            return false;
        }
        SharedPreferences preferences = context.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-debug", false);
    }
}

