package com.onradar.sdk.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUser {

    private String mId;
    private String mUserId;
    private String mDescription;
    private RadarGeofence[] mGeofences;

    public RadarUser(String _id, String userId, String description, RadarGeofence[] geofences) {
        mId = _id;
        mUserId = userId;
        mDescription = description;
        mGeofences = geofences;
    }

    public RadarUser(JSONObject obj) throws JSONException {
        if (obj.has("_id"))
            mId = obj.getString("_id");

        if (obj.has("userId"))
            mUserId = obj.getString("userId");

        if (obj.has("description"))
            mDescription = obj.getString("description");

        if (obj.has("geofences")) {
            JSONArray geofencesArray = obj.getJSONArray("geofences");
            int numGeofences = geofencesArray.length();

            mGeofences = new RadarGeofence[numGeofences];

            for (int i = 0; i < numGeofences; i++) {
                JSONObject geofenceObj = geofencesArray.getJSONObject(i);
                RadarGeofence geofence = new RadarGeofence(geofenceObj);
                mGeofences[i] = geofence;
            }
        }
    }

    /**
     * @return The unique ID for the user, provided by Radar.
     */
    public String getId() {
        return mId;
    }

    /**
     * @return The unique ID for the user, provided when you identified the user.
     */
    public String getUserId() {
        return mUserId;
    }

    /**
     * @return An optional description for the user, provided when you started tracking the user.
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return An array of the user's last known geofences.
     */
    public RadarGeofence[] getGeofences() {
        return mGeofences;
    }

}
