package com.onradar.sdk.model;

import org.json.JSONException;
import org.json.JSONObject;

public class RadarGeofence {

    private String mId;
    private String mDescription;
    private String mTag;
    private String mExternalId;

    public RadarGeofence(String _id, String description, String tag, String externalId) {
        mId = _id;
        mDescription = description;
        mTag = tag;
        mExternalId = externalId;
    }

    public RadarGeofence(JSONObject obj) throws JSONException {
        if (obj.has("_id"))
            mId = obj.getString("_id");

        if (obj.has("description"))
            mDescription = obj.getString("description");

        if (obj.has("tag"))
            mTag = obj.getString("tag");

        if (obj.has("externalId"))
            mExternalId = obj.getString("externalId");
    }

    /**
     * @return The unique ID for the geofence, provided by Radar.
     */
    public String getId() {
        return mId;
    }

    /**
     * @return A description for the geofence.
     */
    public String getDescription() {
        return mDescription;
    }

    /**
     * @return An optional group for the geofence.
     */
    public String getTag() {
        return mTag;
    }

    /**
     * @return An optional external ID for the geofence.
     */
    public String getExternalId() {
        return mExternalId;
    }

}
