/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.onradar.sdk._RadarLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class _RadarUtils {
    _RadarUtils() {
    }

    static boolean isWifiEnabled(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        return wifiManager != null && wifiManager.isWifiEnabled();
    }

    static String getAdId(Context context) {
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            if (info.isLimitAdTrackingEnabled()) {
                return "OptedOut";
            }
            return info.getId();
        }
        catch (Throwable t) {
            _RadarLogger.log(context, "error getting advertising ID: " + t.getMessage());
            return null;
        }
    }

    static String getDeviceMake() {
        return Build.MANUFACTURER;
    }

    static String getDeviceModel() {
        return Build.MODEL;
    }

    static String getDeviceOS() {
        return Build.VERSION.RELEASE;
    }

    static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    static String getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return String.valueOf(offset / 1000);
    }

    static String getSDKVersion() {
        return "1.1.9";
    }
}

