/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onradar.sdk.Radar;
import com.onradar.sdk.RadarCallback;
import com.onradar.sdk._RadarCallback;
import com.onradar.sdk._RadarClient;
import com.onradar.sdk._RadarLocationRequest;
import com.onradar.sdk._RadarLogger;
import com.onradar.sdk._RadarSettings;
import com.onradar.sdk._RadarUtils;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

class _Radar
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static _Radar sInstance;
    private Context mContext;
    private GoogleApiClient mGoogleApiClient;
    private List<_RadarLocationRequest> mLocationRequests;
    private Date mRequestingLocationEndsAt;
    private Handler mHandler;
    private boolean mStopTrackingPending;
    private boolean mRequestLocationOncePending;
    private boolean mRequestLocationMultiplePending;
    private boolean mUpdateGeofencesPending;
    private LocationListener mRequestLocationOnceListener;
    private LocationListener mRequestLocationMultipleListener;

    _Radar() {
    }

    static synchronized _Radar getSharedInstance() {
        if (sInstance == null) {
            sInstance = new _Radar();
        }
        return sInstance;
    }

    void initialize(Context context, String publishableKey) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        if (publishableKey == null) {
            _RadarSettings.readPublishableKey(context);
        } else {
            _RadarSettings.setPublishableKey(context, publishableKey);
        }
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
        }
        if (this.mLocationRequests == null) {
            this.mLocationRequests = new ArrayList<_RadarLocationRequest>();
        }
    }

    void setUserId(String userId) {
        _RadarSettings.setUserId(this.mContext, userId);
    }

    void setDescription(String description) {
        _RadarSettings.setDescription(this.mContext, description);
    }

    boolean checkSelfPermissions() {
        return Build.VERSION.SDK_INT < 23 || this.mContext != null && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    void requestPermissions(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            int requestCode = 0;
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
        }
    }

    void trackOnce(RadarCallback callback) {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = _RadarSettings.getUserId(this.mContext);
        if (userId == null || userId.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_USER_ID, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (!this.checkSelfPermissions()) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PERMISSIONS, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        _RadarLocationRequest locationRequest = new _RadarLocationRequest(10000L, callback);
        this.mLocationRequests.add(locationRequest);
        this.mUpdateGeofencesPending = true;
        this.requestLocationOnce();
    }

    void startTracking() {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = _RadarSettings.getUserId(this.mContext);
        if (userId == null || userId.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (!this.checkSelfPermissions()) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        _RadarSettings.setTracking(this.mContext, true);
        this.mUpdateGeofencesPending = true;
        this.requestLocationOnce();
    }

    void stopTracking() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mStopTrackingPending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        _RadarSettings.setTracking(this.mContext, false);
        this.removeGeofences();
    }

    boolean isTracking() {
        return _RadarSettings.getTracking(this.mContext);
    }

    void updateLocation(Location location, RadarCallback callback) {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = _RadarSettings.getUserId(this.mContext);
        if (userId == null || userId.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        this.sendLocation(location, true, callback);
    }

    private void sendLocation(final Location location, boolean foreground, final RadarCallback callback) {
        _RadarLogger.log(this.mContext, "sending location");
        _RadarLogger.notify(this.mContext, "sending location");
        for (_RadarLocationRequest locationRequest : this.mLocationRequests) {
            locationRequest.stopTimer();
        }
        _RadarClient.getSharedInstance().updateLocation(this.mContext, location, foreground, new _RadarCallback(){

            @Override
            public void onCallback(Radar.RadarStatus status, JSONObject response, RadarEvent[] events, RadarUser user) {
                if (status == Radar.RadarStatus.SUCCESS) {
                    _RadarLogger.log(_Radar.this.mContext, "sent location");
                    _RadarLogger.notify(_Radar.this.mContext, "sent location");
                    if (callback != null) {
                        callback.onCallback(status, location, events, user);
                    } else {
                        for (_RadarLocationRequest locationRequest : _Radar.this.mLocationRequests) {
                            RadarCallback callback2 = locationRequest.getCallback();
                            if (callback2 != null) {
                                callback2.onCallback(status, location, events, user);
                            }
                            _Radar.this.mLocationRequests.remove(locationRequest);
                        }
                    }
                    _Radar.getSharedInstance().sendSuccessIntent(response);
                } else {
                    _RadarLogger.log(_Radar.this.mContext, "error sending location");
                    _RadarLogger.notify(_Radar.this.mContext, "error sending location");
                    if (callback != null) {
                        callback.onCallback(status, location, null, null);
                    } else {
                        for (_RadarLocationRequest locationRequest : _Radar.this.mLocationRequests) {
                            RadarCallback callback3 = locationRequest.getCallback();
                            if (callback3 != null) {
                                callback3.onCallback(status, null, null, null);
                            }
                            _Radar.this.mLocationRequests.remove(locationRequest);
                        }
                        _Radar.this.mLocationRequests.clear();
                    }
                    _Radar.getSharedInstance().sendErrorIntent(status);
                }
            }
        });
    }

    boolean isWifiEnabled() {
        return _RadarUtils.isWifiEnabled(this.mContext);
    }

    void didTimeout(_RadarLocationRequest locationRequest) {
        locationRequest.stopTimer();
        RadarCallback callback = locationRequest.getCallback();
        if (callback != null) {
            callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
        }
        this.mLocationRequests.remove(locationRequest);
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
        if (this.mRequestLocationOnceListener != null) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.mRequestLocationOnceListener);
            _RadarLogger.log(this.mContext, "stopped single location update");
        }
    }

    public void onConnected(Bundle connectionHint) {
        _RadarLogger.log(this.mContext, "Play Services connected");
        if (this.mRequestLocationOncePending) {
            this.mRequestLocationOncePending = false;
            this.requestLocationOnce();
        }
        if (this.mRequestLocationMultiplePending) {
            this.mRequestLocationMultiplePending = false;
            this.requestLocationMultiple();
        }
        if (this.mStopTrackingPending) {
            this.mStopTrackingPending = false;
            this.stopTracking();
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult result) {
        _RadarLogger.log(this.mContext, "Play Services connection failed");
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onConnectionSuspended(int cause) {
        _RadarLogger.log(this.mContext, "Play Services connection suspended");
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    void onHandleIntent(Intent intent) {
        if (intent == null || !_RadarSettings.getTracking(this.mContext)) {
            return;
        }
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            _RadarLogger.log(this.mContext, "boot completed");
            _RadarLogger.notify(this.mContext, "boot completed");
            this.mUpdateGeofencesPending = true;
            this.requestLocationMultiple();
        } else if (intent.getAction().equals("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED")) {
            _RadarLogger.log(this.mContext, "geofence triggered");
            _RadarLogger.notify(this.mContext, "geofence triggered");
            this.mUpdateGeofencesPending = true;
            GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
            this.updateGeofences(event.getTriggeringLocation());
            this.requestLocationMultiple();
        }
    }

    private void requestLocationOnce() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationOncePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.mRequestLocationOnceListener == null) {
            this.mRequestLocationOnceListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    _RadarLogger.log(_Radar.this.mContext, "location changed");
                    if (location == null) {
                        _RadarLogger.log(_Radar.this.mContext, "location is null");
                        return;
                    }
                    if (_Radar.this.mUpdateGeofencesPending) {
                        _Radar.getSharedInstance().updateGeofences(location);
                        _Radar.this.mUpdateGeofencesPending = false;
                    }
                    _RadarSettings.updateSentAt(_Radar.this.mContext);
                    _Radar.getSharedInstance().sendLocation(location, true, null);
                    LocationServices.FusedLocationApi.removeLocationUpdates(_Radar.this.mGoogleApiClient, _Radar.this.mRequestLocationOnceListener);
                    _RadarLogger.log(_Radar.this.mContext, "stopped single location update");
                }
            };
        }
        _RadarLogger.log(this.mContext, "starting single location update");
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(5000L);
        locationRequest.setFastestInterval(1000L);
        locationRequest.setPriority(100);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, this.mRequestLocationOnceListener, Looper.getMainLooper());
        }
        catch (SecurityException e) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
        }
    }

    private void requestLocationMultiple() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationMultiplePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.mRequestLocationMultipleListener == null) {
            this.mRequestLocationMultipleListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    _RadarLogger.log(_Radar.this.mContext, "location changed");
                    if (location == null) {
                        _RadarLogger.log(_Radar.this.mContext, "location is null");
                        _Radar.getSharedInstance().stopRequestingLocationIfNecessary();
                        return;
                    }
                    if (location.getAccuracy() > 50.0f) {
                        _RadarLogger.log(_Radar.this.mContext, "inaccurate location");
                        _RadarLogger.notify(_Radar.this.mContext, "inaccurate location");
                        _Radar.getSharedInstance().stopRequestingLocationIfNecessary();
                        return;
                    }
                    if (_Radar.this.mUpdateGeofencesPending) {
                        _Radar.getSharedInstance().updateGeofences(location);
                        _Radar.this.mUpdateGeofencesPending = false;
                    }
                    Date now = new Date();
                    Date sentAt = _RadarSettings.getSentAt(_Radar.this.mContext);
                    if (sentAt != null && now.getTime() - sentAt.getTime() < 45000L) {
                        _RadarLogger.log(_Radar.this.mContext, "background rate limit");
                        _Radar.getSharedInstance().stopRequestingLocationIfNecessary();
                        return;
                    }
                    _RadarSettings.updateSentAt(_Radar.this.mContext);
                    for (_RadarLocationRequest locationRequest : _Radar.this.mLocationRequests) {
                        locationRequest.stopTimer();
                    }
                    _Radar.getSharedInstance().sendLocation(location, false, null);
                    _Radar.getSharedInstance().stopRequestingLocationIfNecessary();
                }
            };
        }
        if (this.mRequestingLocationEndsAt == null) {
            _RadarLogger.log(this.mContext, "starting multiple location updates");
            _RadarLogger.notify(this.mContext, "starting multiple location updates");
            LocationRequest locationRequest = new LocationRequest();
            locationRequest.setInterval(20000L);
            locationRequest.setFastestInterval(20000L);
            locationRequest.setPriority(102);
            try {
                LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, this.mRequestLocationMultipleListener, Looper.getMainLooper());
            }
            catch (SecurityException e) {
                this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
                return;
            }
        } else {
            _RadarLogger.log(this.mContext, "extending multiple location updates");
            _RadarLogger.notify(this.mContext, "extending multiple location updates");
        }
        Date requestingLocationEndsAt = new Date();
        requestingLocationEndsAt.setTime(requestingLocationEndsAt.getTime() + 300000L);
        this.mRequestingLocationEndsAt = requestingLocationEndsAt;
        this.mHandler = new Handler();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                _Radar.getSharedInstance().stopRequestingLocationIfNecessary();
            }
        }, 315000L);
    }

    private void stopRequestingLocationIfNecessary() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        Date now = new Date();
        if ((this.mRequestingLocationEndsAt == null || now.getTime() - this.mRequestingLocationEndsAt.getTime() > 0L) && this.mRequestLocationMultipleListener != null) {
            this.mRequestingLocationEndsAt = null;
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.mRequestLocationMultipleListener);
            _RadarLogger.log(this.mContext, "stopped multiple location updates");
            _RadarLogger.notify(this.mContext, "stopped multiple location updates");
        }
    }

    private void sendSuccessIntent(JSONObject response) {
        if (this.mContext == null || response == null) {
            return;
        }
        _RadarLogger.log(this.mContext, "sending success broadcast");
        String json = response.toString();
        Intent intent = new Intent("com.onradar.sdk.RECEIVED");
        intent.putExtra("response", json);
        this.mContext.sendBroadcast(intent);
    }

    private void sendErrorIntent(Radar.RadarStatus status) {
        if (this.mContext == null) {
            return;
        }
        _RadarLogger.log(this.mContext, "sending error broadcast");
        Intent intent = new Intent("com.onradar.sdk.RECEIVED");
        intent.putExtra("status", status.ordinal());
        this.mContext.sendBroadcast(intent);
    }

    private void updateGeofences(Location location) {
        String[] radii;
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        if (location == null) {
            return;
        }
        _RadarLogger.log(this.mContext, "updating geofences");
        _RadarLogger.notify(this.mContext, "updating geofences");
        for (String radius : radii = new String[]{"100", "200", "400", "800", "1600"}) {
            double longitude = location.getLongitude();
            double latitude = location.getLatitude();
            float radiusFloat = Float.valueOf(radius).floatValue();
            Geofence newGeofence = new Geofence.Builder().setRequestId("radar_" + radius).setTransitionTypes(2).setCircularRegion(latitude, longitude, radiusFloat).setExpirationDuration(-1L).build();
            GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
            GeofencingRequest request = builder.addGeofence(newGeofence).setInitialTrigger(2).build();
            Intent intent = new Intent("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
            try {
                PendingResult result = LocationServices.GeofencingApi.addGeofences(this.mGoogleApiClient, request, pendingIntent);
                result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                    public void onResult(@NonNull Status status) {
                        if (!status.isSuccess()) {
                            _RadarLogger.log(_Radar.this.mContext, "error adding geofence: " + status.getStatusMessage());
                            _RadarLogger.notify(_Radar.this.mContext, "error adding geofence");
                        }
                    }
                });
            }
            catch (SecurityException e) {
                _RadarLogger.log(this.mContext, "error adding geofences: " + e.getMessage());
                _RadarLogger.notify(this.mContext, "error adding geofences");
            }
        }
    }

    private void removeGeofences() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        try {
            List<String> ids = Arrays.asList("radar_100", "radar_200", "radar_400", "radar_800", "radar_1600");
            PendingResult result = LocationServices.GeofencingApi.removeGeofences(this.mGoogleApiClient, ids);
            result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(@NonNull Status status) {
                    if (!status.isSuccess()) {
                        _RadarLogger.log(_Radar.this.mContext, "error removing geofences: " + status.getStatusMessage());
                        _RadarLogger.notify(_Radar.this.mContext, "error removing geofences");
                    }
                }
            });
        }
        catch (SecurityException e) {
            _RadarLogger.log(this.mContext, "error removing geofences: " + e.getMessage());
            _RadarLogger.notify(this.mContext, "error removing geofences");
        }
    }
}

