/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.url;

import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.RequestedService;
import com.onlyoffice.model.properties.docsintegrationsdk.DocumentServerProperties;
import com.onlyoffice.utils.ConfigurationUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;

public class DefaultUrlManager
implements UrlManager {
    private SettingsManager settingsManager;

    @Override
    public String getDocumentServerUrl() {
        if (this.settingsManager.isDemoActive().booleanValue()) {
            return this.sanitizeUrl(ConfigurationUtils.getDemoDocumentServerProperties().getUrl());
        }
        return this.sanitizeUrl(this.settingsManager.getSetting("url"));
    }

    @Override
    public String getInnerDocumentServerUrl() {
        if (this.settingsManager.isDemoActive().booleanValue()) {
            return this.sanitizeUrl(ConfigurationUtils.getDemoDocumentServerProperties().getUrl());
        }
        String documentServerInnerUrl = this.settingsManager.getSetting("innerUrl");
        if (documentServerInnerUrl != null && !documentServerInnerUrl.isEmpty()) {
            return this.sanitizeUrl(documentServerInnerUrl);
        }
        return this.getDocumentServerUrl();
    }

    @Override
    public String getDocumentServerApiUrl() {
        return this.getDocumentServerApiUrl(null);
    }

    @Override
    public String getDocumentServerApiUrl(String shardKey) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getDocumentServerUrl() + this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getApiUrl());
            if (shardKey != null && !shardKey.isEmpty()) {
                uriBuilder.addParameter("shardkey", shardKey);
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            return this.getDocumentServerUrl() + this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getApiUrl();
        }
    }

    @Override
    public String getDocumentServerPreloaderApiUrl() {
        return this.getDocumentServerUrl() + this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getApiPreloaderUrl();
    }

    @Override
    public String getServiceUrl(RequestedService requestedService) {
        String serviceUrl = null;
        if (requestedService == null) {
            return null;
        }
        String serviceName = requestedService.getClass().getInterfaces()[0].getSimpleName().toLowerCase();
        DocumentServerProperties documentServerProperties = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer();
        try {
            Object serviceProperties = null;
            BeanInfo beanInfo = Introspector.getBeanInfo(documentServerProperties.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().toLowerCase().equals(serviceName)) continue;
                serviceProperties = propertyDescriptor.getReadMethod().invoke((Object)documentServerProperties, new Object[0]);
            }
            if (serviceProperties == null) {
                return null;
            }
            beanInfo = Introspector.getBeanInfo(serviceProperties.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals("url")) continue;
                serviceUrl = propertyDescriptor.getReadMethod().invoke(serviceProperties, new Object[0]).toString();
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (serviceUrl == null) {
            return null;
        }
        return this.getInnerDocumentServerUrl() + serviceUrl;
    }

    @Override
    public String sanitizeUrl(String url) {
        if (url != null) {
            return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        }
        return null;
    }

    @Override
    public String replaceToDocumentServerUrl(String url) {
        String innerDocumentServerUrl;
        String documentServerUrl = this.getDocumentServerUrl();
        if (!documentServerUrl.equals(innerDocumentServerUrl = this.getInnerDocumentServerUrl())) {
            return url.replace(innerDocumentServerUrl, documentServerUrl);
        }
        return url;
    }

    @Override
    public String replaceToInnerDocumentServerUrl(String url) {
        String innerDocumentServerUrl;
        String documentServerUrl = this.getDocumentServerUrl();
        if (!documentServerUrl.equals(innerDocumentServerUrl = this.getInnerDocumentServerUrl())) {
            return url.replace(documentServerUrl, innerDocumentServerUrl);
        }
        return url;
    }

    @Override
    public String getFileUrl(String fileId) {
        return null;
    }

    @Override
    public String getCallbackUrl(String fileId) {
        return null;
    }

    @Override
    public String getGobackUrl(String fileId) {
        return null;
    }

    @Override
    public String getCreateUrl(String fileId) {
        return null;
    }

    @Override
    public String getTestConvertUrl(String url) {
        return null;
    }

    @Generated
    public DefaultUrlManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Generated
    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Generated
    protected void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

