/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.request.RequestManager;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.RequestEntity;
import com.onlyoffice.model.common.RequestedService;
import com.onlyoffice.model.settings.HttpClientSettings;
import com.onlyoffice.model.settings.security.Security;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class DefaultRequestManager
implements RequestManager {
    private UrlManager urlManager;
    private JwtManager jwtManager;
    private SettingsManager settingsManager;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <R> R executeGetRequest(String url, RequestManager.Callback<R> callback) throws Exception {
        HttpClientSettings httpClientSettings = HttpClientSettings.builder().ignoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate()).build();
        return this.executeGetRequest(url, httpClientSettings, callback);
    }

    @Override
    public <R> R executeGetRequest(String url, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return this.executeRequest((HttpUriRequest)httpGet, httpClientSettings, callback);
    }

    @Override
    public <R> R executePostRequest(RequestedService requestedService, RequestEntity requestEntity, RequestManager.Callback<R> callback) throws Exception {
        Security security = Security.builder().key(this.settingsManager.getSecurityKey()).header(this.settingsManager.getSecurityHeader()).prefix(this.settingsManager.getSecurityPrefix()).build();
        String url = this.urlManager.getServiceUrl(requestedService);
        return this.executePostRequest(url, requestEntity, security, null, callback);
    }

    @Override
    public <R> R executePostRequest(RequestedService requestedService, RequestEntity requestEntity, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        Security security = Security.builder().key(this.settingsManager.getSecurityKey()).header(this.settingsManager.getSecurityHeader()).prefix(this.settingsManager.getSecurityPrefix()).build();
        String url = this.urlManager.getServiceUrl(requestedService);
        return this.executePostRequest(url, requestEntity, security, httpClientSettings, callback);
    }

    @Override
    public <R> R executePostRequest(String url, RequestEntity requestEntity, Security security, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        HttpPost request = this.createPostRequest(url, requestEntity, security);
        return this.executeRequest((HttpUriRequest)request, httpClientSettings, callback);
    }

    private <R> R executeRequest(HttpUriRequest request, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        try (CloseableHttpClient httpClient = this.getHttpClient(httpClientSettings);){
            R r;
            block15: {
                CloseableHttpResponse response = httpClient.execute(request);
                try {
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine == null) {
                        throw new ClientProtocolException(this.settingsManager.getDocsIntegrationSdkProperties().getProduct().getName() + " URL: " + request.getURI() + " did not return a response.\nRequest: " + request.toString() + "\nResponse: " + response);
                    }
                    HttpEntity resEntity = response.getEntity();
                    if (resEntity == null) {
                        throw new ClientProtocolException(this.settingsManager.getDocsIntegrationSdkProperties().getProduct().getName() + " URL: " + request.getURI() + " did not return content.\nRequest: " + request.toString() + "\nResponse: " + response);
                    }
                    int statusCode = statusLine.getStatusCode();
                    if (statusCode != 200) {
                        throw new ClientProtocolException(this.settingsManager.getDocsIntegrationSdkProperties().getProduct().getName() + " URL: " + request.getURI() + " return unexpected response.\nRequest: " + request.toString() + "\nResponse: " + response.toString());
                    }
                    R result = callback.doWork(resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    r = result;
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return r;
        }
    }

    private HttpPost createPostRequest(String url, RequestEntity requestEntity, Security security) throws JsonProcessingException {
        HttpPost request = new HttpPost(url);
        if (security.getKey() != null && !security.getKey().isEmpty()) {
            HashMap<String, RequestEntity> payloadMap = new HashMap<String, RequestEntity>();
            payloadMap.put("payload", requestEntity);
            String headerToken = this.jwtManager.createToken((Map)this.objectMapper.convertValue(payloadMap, Map.class), security.getKey());
            request.setHeader(security.getHeader(), security.getPrefix() + headerToken);
            String bodyToken = this.jwtManager.createToken(requestEntity, security.getKey());
            requestEntity.setToken(bodyToken);
        }
        StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString((Object)requestEntity), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        request.setHeader("Accept", "application/json");
        return request;
    }

    private CloseableHttpClient getHttpClient(HttpClientSettings httpClientSettings) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient httpClient;
        Boolean ignoreSSLCertificate = this.settingsManager.isIgnoreSSLCertificate();
        Integer connectionTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getHttpClient().getConnectionTimeout());
        Integer connectionRequestTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getHttpClient().getConnectionRequestTimeout());
        Integer socketTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getHttpClient().getSocketTimeout());
        if (httpClientSettings != null) {
            if (httpClientSettings.getConnectionTimeout() != null) {
                connectionTimeout = httpClientSettings.getConnectionTimeout();
            }
            if (httpClientSettings.getConnectionRequestTimeout() != null) {
                connectionRequestTimeout = httpClientSettings.getConnectionRequestTimeout();
            }
            if (httpClientSettings.getSocketTimeout() != null) {
                socketTimeout = httpClientSettings.getSocketTimeout();
            }
            if (httpClientSettings.getIgnoreSSLCertificate() != null) {
                ignoreSSLCertificate = httpClientSettings.getIgnoreSSLCertificate();
            }
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setConnectionRequestTimeout(connectionRequestTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).build();
        if (ignoreSSLCertificate.booleanValue()) {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultRequestConfig(config).build();
        } else {
            httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        }
        return httpClient;
    }

    public DefaultRequestManager(UrlManager urlManager, JwtManager jwtManager, SettingsManager settingsManager) {
        this.urlManager = urlManager;
        this.jwtManager = jwtManager;
        this.settingsManager = settingsManager;
    }

    protected UrlManager getUrlManager() {
        return this.urlManager;
    }

    protected void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    protected JwtManager getJwtManager() {
        return this.jwtManager;
    }

    protected void setJwtManager(JwtManager jwtManager) {
        this.jwtManager = jwtManager;
    }

    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    protected void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

