/**
 *
 * (c) Copyright Ascensio System SIA 2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.onlyoffice.service.command;

import com.onlyoffice.model.commandservice.CommandRequest;
import com.onlyoffice.model.commandservice.CommandResponse;

public interface CommandService {

    /**
     * Process command request.
     *
     * @param commandRequest The {@link CommandRequest} object.
     * @param fileId The ID of the file.
     * @see CommandRequest
     * @return The {@link CommandResponse} object.
     * @throws Exception If the processing fails unexpectedly.
     */
    CommandResponse processCommand(CommandRequest commandRequest, String fileId) throws Exception;
}
