/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.receivereceipt.impl;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.CoroutineWorker;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkerParameters;
import com.onesignal.OneSignal;
import com.onesignal.common.AndroidUtils;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.internal.common.OSWorkManagerHelper;
import com.onesignal.notifications.internal.receivereceipt.IReceiveReceiptProcessor;
import com.onesignal.notifications.internal.receivereceipt.IReceiveReceiptWorkManager;
import com.onesignal.notifications.internal.receivereceipt.impl.ReceiveReceiptWorkManager;
import com.onesignal.user.internal.subscriptions.ISubscriptionManager;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/onesignal/notifications/internal/receivereceipt/impl/ReceiveReceiptWorkManager;", "Lcom/onesignal/notifications/internal/receivereceipt/IReceiveReceiptWorkManager;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_subscriptionManager", "Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;)V", "maxDelay", "", "minDelay", "buildConstraints", "Landroidx/work/Constraints;", "enqueueReceiveReceipt", "", "notificationId", "", "Companion", "ReceiveReceiptWorker", "com.onesignal.notifications"})
public final class ReceiveReceiptWorkManager
implements IReceiveReceiptWorkManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final ISubscriptionManager _subscriptionManager;
    private final int minDelay;
    private final int maxDelay;
    @NotNull
    private static final String OS_NOTIFICATION_ID = "os_notification_id";
    @NotNull
    private static final String OS_APP_ID = "os_app_id";
    @NotNull
    private static final String OS_SUBSCRIPTION_ID = "os_subscription_id";

    public ReceiveReceiptWorkManager(@NotNull IApplicationService _applicationService, @NotNull ConfigModelStore _configModelStore, @NotNull ISubscriptionManager _subscriptionManager) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_subscriptionManager, (String)"_subscriptionManager");
        this._applicationService = _applicationService;
        this._configModelStore = _configModelStore;
        this._subscriptionManager = _subscriptionManager;
        this.maxDelay = 25;
    }

    @Override
    public void enqueueReceiveReceipt(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        if (!((ConfigModel)this._configModelStore.getModel()).getReceiveReceiptEnabled()) {
            Logging.debug$default((String)"sendReceiveReceipt disabled", null, (int)2, null);
            return;
        }
        String appId = ((ConfigModel)this._configModelStore.getModel()).getAppId();
        String subscriptionId = this._subscriptionManager.getSubscriptions().getPush().getId();
        if (((CharSequence)subscriptionId).length() == 0 || ((CharSequence)appId).length() == 0) {
            Logging.debug$default((String)"ReceiveReceiptWorkManager: No push subscription or appId!", null, (int)2, null);
        }
        int delay = AndroidUtils.INSTANCE.getRandomDelay(this.minDelay, this.maxDelay);
        Data data = new Data.Builder().putString(OS_NOTIFICATION_ID, notificationId).putString(OS_APP_ID, appId).putString(OS_SUBSCRIPTION_ID, subscriptionId).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"build(...)");
        Data inputData = data;
        Constraints constraints = this.buildConstraints();
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ReceiveReceiptWorker.class).setConstraints(constraints)).setInitialDelay((long)delay, TimeUnit.SECONDS)).setInputData(inputData)).build();
        Logging.debug$default((String)("OSReceiveReceiptController enqueueing send receive receipt work with notificationId: " + notificationId + " and delay: " + delay + " seconds"), null, (int)2, null);
        OSWorkManagerHelper.INSTANCE.getInstance(this._applicationService.getAppContext()).enqueueUniqueWork(notificationId + "_receive_receipt", ExistingWorkPolicy.KEEP, workRequest);
    }

    private final Constraints buildConstraints() {
        return new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/onesignal/notifications/internal/receivereceipt/impl/ReceiveReceiptWorkManager$Companion;", "", "()V", "OS_APP_ID", "", "OS_NOTIFICATION_ID", "OS_SUBSCRIPTION_ID", "com.onesignal.notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/onesignal/notifications/internal/receivereceipt/impl/ReceiveReceiptWorkManager$ReceiveReceiptWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "com.onesignal.notifications"})
    @SourceDebugExtension(value={"SMAP\nReceiveReceiptWorkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReceiveReceiptWorkManager.kt\ncom/onesignal/notifications/internal/receivereceipt/impl/ReceiveReceiptWorkManager$ReceiveReceiptWorker\n+ 2 OneSignal.kt\ncom/onesignal/OneSignal\n*L\n1#1,97:1\n264#2:98\n*S KotlinDebug\n*F\n+ 1 ReceiveReceiptWorkManager.kt\ncom/onesignal/notifications/internal/receivereceipt/impl/ReceiveReceiptWorkManager$ReceiveReceiptWorker\n*L\n85#1:98\n*E\n"})
    public static final class ReceiveReceiptWorker
    extends CoroutineWorker {
        public ReceiveReceiptWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
            super(context, workerParams);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> var1_1) {
            if (!(var1_1 instanceof doWork.1)) ** GOTO lbl-1000
            var9_2 = var1_1;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ReceiveReceiptWorker this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.doWork((Continuation<? super ListenableWorker.Result>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplicationContext(...)");
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v1 = OneSignal.initWithContext((Context)v0, (Continuation)$continuation);
                    if (v1 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    this = (ReceiveReceiptWorker)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl24:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) {
                        Logging.warn$default((String)"ReceiveReceiptWorker skipped due to failed OneSignal initialization", null, (int)2, null);
                        v2 = ListenableWorker.Result.success();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"success(...)");
                        return v2;
                    }
                    v3 = this.getInputData().getString("os_notification_id");
                    if (v3 == null) {
                        v4 = ListenableWorker.Result.failure();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"failure(...)");
                        return v4;
                    }
                    notificationId = v3;
                    v5 = this.getInputData().getString("os_app_id");
                    if (v5 == null) {
                        v6 = ListenableWorker.Result.failure();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"failure(...)");
                        return v6;
                    }
                    appId = v5;
                    v7 = this.getInputData().getString("os_subscription_id");
                    if (v7 == null) {
                        v8 = ListenableWorker.Result.failure();
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"failure(...)");
                        return v8;
                    }
                    subscriptionId = v7;
                    this_$iv = OneSignal.INSTANCE;
                    $i$f$getService = false;
                    receiveReceiptProcessor = (IReceiveReceiptProcessor)this_$iv.getServices().getService(IReceiveReceiptProcessor.class);
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v9 = receiveReceiptProcessor.sendReceiveReceipt(appId, subscriptionId, notificationId, (Continuation<? super Unit>)$continuation);
                    if (v9 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl59
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl59:
                    // 2 sources

                    v10 = ListenableWorker.Result.success();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"success(...)");
                    return v10;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

