/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.registration.impl;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.onesignal.common.AndroidUtils;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.device.IDeviceService;
import com.onesignal.notifications.internal.registration.impl.GooglePlayServicesUpgradePrompt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0011\u0010\u0010\u001a\u00020\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcom/onesignal/notifications/internal/registration/impl/GooglePlayServicesUpgradePrompt;", "", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_deviceService", "Lcom/onesignal/core/internal/device/IDeviceService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/device/IDeviceService;Lcom/onesignal/core/internal/config/ConfigModelStore;)V", "isGooglePlayStoreInstalled", "", "()Z", "openPlayStoreToApp", "", "activity", "Landroid/app/Activity;", "showUpdateGPSDialog", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "notifications_release"})
public final class GooglePlayServicesUpgradePrompt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final IDeviceService _deviceService;
    @NotNull
    private final ConfigModelStore _configModelStore;
    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 9000;

    public GooglePlayServicesUpgradePrompt(@NotNull IApplicationService _applicationService, @NotNull IDeviceService _deviceService, @NotNull ConfigModelStore _configModelStore) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_deviceService, (String)"_deviceService");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        this._applicationService = _applicationService;
        this._deviceService = _deviceService;
        this._configModelStore = _configModelStore;
    }

    private final boolean isGooglePlayStoreInstalled() {
        try {
            PackageManager pm = this._applicationService.getAppContext().getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.google.android.gms", 128);
            CharSequence charSequence = info.applicationInfo.loadLabel(pm);
            Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type kotlin.String");
            String label = (String)charSequence;
            return !Intrinsics.areEqual((Object)label, (Object)"Market");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @Nullable
    public final Object showUpdateGPSDialog(@NotNull Continuation<? super Unit> $completion) {
        if (!this._deviceService.isAndroidDeviceType()) {
            return Unit.INSTANCE;
        }
        if (!this.isGooglePlayStoreInstalled() || ((ConfigModel)this._configModelStore.getModel()).getDisableGMSMissingPrompt() || ((ConfigModel)this._configModelStore.getModel()).getUserRejectedGMSUpdate()) {
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GooglePlayServicesUpgradePrompt this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Activity activity = GooglePlayServicesUpgradePrompt.access$get_applicationService$p(this.this$0).getCurrent();
                        if (activity == null) {
                            return Unit.INSTANCE;
                        }
                        Activity activity2 = activity;
                        String alertBodyText = AndroidUtils.INSTANCE.getResourceString((Context)activity2, "onesignal_gms_missing_alert_text", "To receive push notifications please press 'Update' to enable 'Google Play services'.");
                        String alertButtonUpdate = AndroidUtils.INSTANCE.getResourceString((Context)activity2, "onesignal_gms_missing_alert_button_update", "Update");
                        String alertButtonSkip = AndroidUtils.INSTANCE.getResourceString((Context)activity2, "onesignal_gms_missing_alert_button_skip", "Skip");
                        String alertButtonClose = AndroidUtils.INSTANCE.getResourceString((Context)activity2, "onesignal_gms_missing_alert_button_close", "Close");
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity2);
                        builder.setMessage((CharSequence)alertBodyText).setPositiveButton((CharSequence)alertButtonUpdate, (arg_0, arg_1) -> showUpdateGPSDialog.2.invokeSuspend$lambda-0(this.this$0, activity2, arg_0, arg_1)).setNegativeButton((CharSequence)alertButtonSkip, (arg_0, arg_1) -> showUpdateGPSDialog.2.invokeSuspend$lambda-1(this.this$0, arg_0, arg_1)).setNeutralButton((CharSequence)alertButtonClose, null).create().show();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-0(GooglePlayServicesUpgradePrompt this$0, Activity $activity, DialogInterface dialog, int which) {
                GooglePlayServicesUpgradePrompt.access$openPlayStoreToApp(this$0, $activity);
            }

            private static final void invokeSuspend$lambda-1(GooglePlayServicesUpgradePrompt this$0, DialogInterface dialog, int which) {
                ((ConfigModel)GooglePlayServicesUpgradePrompt.access$get_configModelStore$p(this$0).getModel()).setUserRejectedGMSUpdate(true);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void openPlayStoreToApp(Activity activity) {
        try {
            PendingIntent pendingIntent;
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)googleApiAvailability, (String)"getInstance()");
            GoogleApiAvailability apiAvailability = googleApiAvailability;
            int resultCode = apiAvailability.isGooglePlayServicesAvailable(this._applicationService.getAppContext());
            PendingIntent pendingIntent2 = pendingIntent = apiAvailability.getErrorResolutionPendingIntent((Context)activity, resultCode, 9000);
            if (pendingIntent2 != null) {
                pendingIntent2.send();
            }
        }
        catch (PendingIntent.CanceledException e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ IApplicationService access$get_applicationService$p(GooglePlayServicesUpgradePrompt $this) {
        return $this._applicationService;
    }

    public static final /* synthetic */ void access$openPlayStoreToApp(GooglePlayServicesUpgradePrompt $this, Activity activity) {
        $this.openPlayStoreToApp(activity);
    }

    public static final /* synthetic */ ConfigModelStore access$get_configModelStore$p(GooglePlayServicesUpgradePrompt $this) {
        return $this._configModelStore;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/onesignal/notifications/internal/registration/impl/GooglePlayServicesUpgradePrompt$Companion;", "", "()V", "PLAY_SERVICES_RESOLUTION_REQUEST", "", "notifications_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

