/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.common;

import android.content.Intent;
import android.os.Bundle;
import com.onesignal.debug.internal.logging.Logging;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/onesignal/notifications/internal/common/NotificationFormatHelper;", "", "()V", "PAYLOAD_OS_NOTIFICATION_ID", "", "PAYLOAD_OS_ROOT_CUSTOM", "getOSNotificationIdFromBundle", "bundle", "Landroid/os/Bundle;", "getOSNotificationIdFromJson", "jsonObject", "Lorg/json/JSONObject;", "getOSNotificationIdFromJsonString", "jsonStr", "isOneSignalBundle", "", "isOneSignalIntent", "intent", "Landroid/content/Intent;", "notifications_release"})
public final class NotificationFormatHelper {
    @NotNull
    public static final NotificationFormatHelper INSTANCE = new NotificationFormatHelper();
    @NotNull
    public static final String PAYLOAD_OS_ROOT_CUSTOM = "custom";
    @NotNull
    public static final String PAYLOAD_OS_NOTIFICATION_ID = "i";

    private NotificationFormatHelper() {
    }

    public final boolean isOneSignalIntent(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        Bundle bundle = intent.getExtras();
        return this.isOneSignalBundle(bundle);
    }

    public final boolean isOneSignalBundle(@Nullable Bundle bundle) {
        return this.getOSNotificationIdFromBundle(bundle) != null;
    }

    private final String getOSNotificationIdFromBundle(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        String custom = bundle.getString(PAYLOAD_OS_ROOT_CUSTOM, null);
        if (custom != null) {
            return this.getOSNotificationIdFromJsonString(custom);
        }
        Logging.debug$default((String)"Not a OneSignal formatted Bundle. No 'custom' field in the bundle.", null, (int)2, null);
        return null;
    }

    @Nullable
    public final String getOSNotificationIdFromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String custom = jsonObject.optString(PAYLOAD_OS_ROOT_CUSTOM, null);
        return this.getOSNotificationIdFromJsonString(custom);
    }

    private final String getOSNotificationIdFromJsonString(String jsonStr) {
        try {
            JSONObject customJSON = new JSONObject(jsonStr);
            if (customJSON.has(PAYLOAD_OS_NOTIFICATION_ID)) {
                return customJSON.optString(PAYLOAD_OS_NOTIFICATION_ID, null);
            }
            Logging.debug$default((String)"Not a OneSignal formatted JSON string. No 'i' field in custom.", null, (int)2, null);
        }
        catch (JSONException e) {
            Logging.debug$default((String)"Not a OneSignal formatted JSON String, error parsing string as JSON.", null, (int)2, null);
        }
        return null;
    }
}

