/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal;

import androidx.core.app.NotificationCompat;
import com.onesignal.common.JSONObjectExtensionsKt;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.BackgroundImageLayout;
import com.onesignal.notifications.IActionButton;
import com.onesignal.notifications.IMutableNotification;
import com.onesignal.notifications.INotification;
import com.onesignal.notifications.internal.MutableNotification;
import com.onesignal.notifications.internal.common.NotificationHelper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0002~\u007fB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B/\b\u0016\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010r\u001a\u00020\u0000J\u0006\u0010s\u001a\u00020tJ\u0018\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010x\u001a\u00020yH\u0016J\b\u0010z\u001a\u00020vH\u0002J\u0010\u0010{\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004H\u0002J\u0006\u0010|\u001a\u00020\u0004J\b\u0010}\u001a\u00020&H\u0016R\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001c\u0010.\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010(\"\u0004\b0\u0010*R\u001c\u00101\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010(\"\u0004\b3\u0010*R\u001c\u00104\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010(\"\u0004\b6\u0010*R\u001c\u00107\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010(\"\u0004\b9\u0010*R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0013\"\u0004\b;\u0010\u0015R\u001c\u0010<\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010(\"\u0004\b>\u0010*R\u001c\u0010?\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010(\"\u0004\bA\u0010*R\u001c\u0010B\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010(\"\u0004\bD\u0010*R\u001a\u0010E\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u001c\"\u0004\bG\u0010\u001eR\u001c\u0010H\u001a\u0004\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001c\u0010N\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010(\"\u0004\bP\u0010*R\u001a\u0010Q\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u001c\"\u0004\bS\u0010\u001eR\u001c\u0010T\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010(\"\u0004\bV\u0010*R\u001a\u0010W\u001a\u00020XX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u001c\u0010]\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010(\"\u0004\b_\u0010*R\u001c\u0010`\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010(\"\u0004\bb\u0010*R\u001c\u0010c\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010(\"\u0004\be\u0010*R\u001c\u0010f\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010(\"\u0004\bh\u0010*R\u001c\u0010i\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010(\"\u0004\bk\u0010*R\u001c\u0010l\u001a\u0004\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010(\"\u0004\bn\u0010*R\u001a\u0010o\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010\u001c\"\u0004\bq\u0010\u001e\u00a8\u0006\u0080\u0001"}, d2={"Lcom/onesignal/notifications/internal/Notification;", "Lcom/onesignal/notifications/INotification;", "()V", "payload", "Lorg/json/JSONObject;", "time", "Lcom/onesignal/core/internal/time/ITime;", "(Lorg/json/JSONObject;Lcom/onesignal/core/internal/time/ITime;)V", "groupedNotifications", "", "jsonPayload", "androidNotificationId", "", "(Ljava/util/List;Lorg/json/JSONObject;ILcom/onesignal/core/internal/time/ITime;)V", "notification", "(Lcom/onesignal/notifications/internal/Notification;)V", "actionButtons", "Lcom/onesignal/notifications/IActionButton;", "getActionButtons", "()Ljava/util/List;", "setActionButtons", "(Ljava/util/List;)V", "additionalData", "getAdditionalData", "()Lorg/json/JSONObject;", "setAdditionalData", "(Lorg/json/JSONObject;)V", "getAndroidNotificationId", "()I", "setAndroidNotificationId", "(I)V", "backgroundImageLayout", "Lcom/onesignal/notifications/BackgroundImageLayout;", "getBackgroundImageLayout", "()Lcom/onesignal/notifications/BackgroundImageLayout;", "setBackgroundImageLayout", "(Lcom/onesignal/notifications/BackgroundImageLayout;)V", "bigPicture", "", "getBigPicture", "()Ljava/lang/String;", "setBigPicture", "(Ljava/lang/String;)V", "body", "getBody", "setBody", "collapseId", "getCollapseId", "setCollapseId", "fromProjectNumber", "getFromProjectNumber", "setFromProjectNumber", "groupKey", "getGroupKey", "setGroupKey", "groupMessage", "getGroupMessage", "setGroupMessage", "getGroupedNotifications", "setGroupedNotifications", "largeIcon", "getLargeIcon", "setLargeIcon", "launchURL", "getLaunchURL", "setLaunchURL", "ledColor", "getLedColor", "setLedColor", "lockScreenVisibility", "getLockScreenVisibility", "setLockScreenVisibility", "notificationExtender", "Landroidx/core/app/NotificationCompat$Extender;", "getNotificationExtender", "()Landroidx/core/app/NotificationCompat$Extender;", "setNotificationExtender", "(Landroidx/core/app/NotificationCompat$Extender;)V", "notificationId", "getNotificationId", "setNotificationId", "priority", "getPriority", "setPriority", "rawPayload", "getRawPayload", "setRawPayload", "sentTime", "", "getSentTime", "()J", "setSentTime", "(J)V", "smallIcon", "getSmallIcon", "setSmallIcon", "smallIconAccentColor", "getSmallIconAccentColor", "setSmallIconAccentColor", "sound", "getSound", "setSound", "templateId", "getTemplateId", "setTemplateId", "templateName", "getTemplateName", "setTemplateName", "title", "getTitle", "setTitle", "ttl", "getTtl", "setTtl", "copy", "hasNotificationId", "", "initPayloadData", "", "currentJsonPayload", "mutableCopy", "Lcom/onesignal/notifications/IMutableNotification;", "setActionButtonsFromData", "setBackgroundImageLayoutFromData", "toJSONObject", "toString", "ActionButton", "OSNotificationBuilder", "notifications_release"})
public class Notification
implements INotification {
    @Nullable
    private NotificationCompat.Extender notificationExtender;
    @Nullable
    private List<? extends Notification> groupedNotifications;
    private int androidNotificationId;
    @Nullable
    private String notificationId;
    @Nullable
    private String templateName;
    @Nullable
    private String templateId;
    @Nullable
    private String title;
    @Nullable
    private String body;
    @Nullable
    private JSONObject additionalData;
    @Nullable
    private String smallIcon;
    @Nullable
    private String largeIcon;
    @Nullable
    private String bigPicture;
    @Nullable
    private String smallIconAccentColor;
    @Nullable
    private String launchURL;
    @Nullable
    private String sound;
    @Nullable
    private String ledColor;
    private int lockScreenVisibility;
    @Nullable
    private String groupKey;
    @Nullable
    private String groupMessage;
    @Nullable
    private List<? extends IActionButton> actionButtons;
    @Nullable
    private String fromProjectNumber;
    @Nullable
    private BackgroundImageLayout backgroundImageLayout;
    @Nullable
    private String collapseId;
    private int priority;
    private long sentTime;
    private int ttl;
    @Nullable
    private String rawPayload;

    @Nullable
    public final NotificationCompat.Extender getNotificationExtender() {
        return this.notificationExtender;
    }

    public final void setNotificationExtender(@Nullable NotificationCompat.Extender extender) {
        this.notificationExtender = extender;
    }

    @Nullable
    public List<Notification> getGroupedNotifications() {
        return this.groupedNotifications;
    }

    public void setGroupedNotifications(@Nullable List<? extends Notification> list) {
        this.groupedNotifications = list;
    }

    public int getAndroidNotificationId() {
        return this.androidNotificationId;
    }

    public void setAndroidNotificationId(int n) {
        this.androidNotificationId = n;
    }

    @Nullable
    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(@Nullable String string) {
        this.notificationId = string;
    }

    @Nullable
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(@Nullable String string) {
        this.templateName = string;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(@Nullable String string) {
        this.templateId = string;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String string) {
        this.title = string;
    }

    @Nullable
    public String getBody() {
        return this.body;
    }

    public void setBody(@Nullable String string) {
        this.body = string;
    }

    @Nullable
    public JSONObject getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(@Nullable JSONObject jSONObject) {
        this.additionalData = jSONObject;
    }

    @Nullable
    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(@Nullable String string) {
        this.smallIcon = string;
    }

    @Nullable
    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(@Nullable String string) {
        this.largeIcon = string;
    }

    @Nullable
    public String getBigPicture() {
        return this.bigPicture;
    }

    public void setBigPicture(@Nullable String string) {
        this.bigPicture = string;
    }

    @Nullable
    public String getSmallIconAccentColor() {
        return this.smallIconAccentColor;
    }

    public void setSmallIconAccentColor(@Nullable String string) {
        this.smallIconAccentColor = string;
    }

    @Nullable
    public String getLaunchURL() {
        return this.launchURL;
    }

    public void setLaunchURL(@Nullable String string) {
        this.launchURL = string;
    }

    @Nullable
    public String getSound() {
        return this.sound;
    }

    public void setSound(@Nullable String string) {
        this.sound = string;
    }

    @Nullable
    public String getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(@Nullable String string) {
        this.ledColor = string;
    }

    public int getLockScreenVisibility() {
        return this.lockScreenVisibility;
    }

    public void setLockScreenVisibility(int n) {
        this.lockScreenVisibility = n;
    }

    @Nullable
    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(@Nullable String string) {
        this.groupKey = string;
    }

    @Nullable
    public String getGroupMessage() {
        return this.groupMessage;
    }

    public void setGroupMessage(@Nullable String string) {
        this.groupMessage = string;
    }

    @Nullable
    public List<IActionButton> getActionButtons() {
        return this.actionButtons;
    }

    public void setActionButtons(@Nullable List<? extends IActionButton> list) {
        this.actionButtons = list;
    }

    @Nullable
    public String getFromProjectNumber() {
        return this.fromProjectNumber;
    }

    public void setFromProjectNumber(@Nullable String string) {
        this.fromProjectNumber = string;
    }

    @Nullable
    public BackgroundImageLayout getBackgroundImageLayout() {
        return this.backgroundImageLayout;
    }

    public void setBackgroundImageLayout(@Nullable BackgroundImageLayout backgroundImageLayout) {
        this.backgroundImageLayout = backgroundImageLayout;
    }

    @Nullable
    public String getCollapseId() {
        return this.collapseId;
    }

    public void setCollapseId(@Nullable String string) {
        this.collapseId = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public long getSentTime() {
        return this.sentTime;
    }

    public void setSentTime(long l) {
        this.sentTime = l;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Nullable
    public String getRawPayload() {
        return this.rawPayload;
    }

    public void setRawPayload(@Nullable String string) {
        this.rawPayload = string;
    }

    public Notification() {
        this.lockScreenVisibility = 1;
    }

    public Notification(@NotNull JSONObject payload, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(null, payload, 0, time);
    }

    public Notification(@Nullable List<? extends Notification> groupedNotifications, @NotNull JSONObject jsonPayload, int androidNotificationId, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)jsonPayload, (String)"jsonPayload");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.lockScreenVisibility = 1;
        this.initPayloadData(jsonPayload, time);
        this.setGroupedNotifications(groupedNotifications);
        this.setAndroidNotificationId(androidNotificationId);
    }

    public Notification(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.lockScreenVisibility = 1;
        this.notificationExtender = notification.notificationExtender;
        this.setGroupedNotifications(notification.getGroupedNotifications());
        this.setAndroidNotificationId(notification.getAndroidNotificationId());
        this.setNotificationId(notification.getNotificationId());
        this.setTemplateName(notification.getTemplateName());
        this.setTemplateId(notification.getTemplateId());
        this.setTitle(notification.getTitle());
        this.setBody(notification.getBody());
        this.setAdditionalData(notification.getAdditionalData());
        this.setSmallIcon(notification.getSmallIcon());
        this.setLargeIcon(notification.getLargeIcon());
        this.setBigPicture(notification.getBigPicture());
        this.setSmallIconAccentColor(notification.getSmallIconAccentColor());
        this.setLaunchURL(notification.getLaunchURL());
        this.setSound(notification.getSound());
        this.setLedColor(notification.getLedColor());
        this.setLockScreenVisibility(notification.getLockScreenVisibility());
        this.setGroupKey(notification.getGroupKey());
        this.setGroupMessage(notification.getGroupMessage());
        this.setActionButtons(notification.getActionButtons());
        this.setFromProjectNumber(notification.getFromProjectNumber());
        this.setBackgroundImageLayout(notification.getBackgroundImageLayout());
        this.setCollapseId(notification.getCollapseId());
        this.setPriority(notification.getPriority());
        this.setRawPayload(notification.getRawPayload());
        this.setSentTime(notification.getSentTime());
        this.setTtl(notification.getTtl());
    }

    private final void initPayloadData(JSONObject currentJsonPayload, ITime time) {
        JSONObject jSONObject;
        try {
            jSONObject = NotificationHelper.INSTANCE.getCustomJSONObject(currentJsonPayload);
        }
        catch (Throwable t) {
            Logging.error((String)"Error assigning OSNotificationReceivedEvent payload values!", (Throwable)t);
            return;
        }
        JSONObject customJson = jSONObject;
        long currentTime = time.getCurrentTimeMillis();
        if (currentJsonPayload.has("google.ttl")) {
            this.setSentTime(currentJsonPayload.optLong("google.sent_time", currentTime) / (long)1000);
            this.setTtl(currentJsonPayload.optInt("google.ttl", 259200));
        } else if (currentJsonPayload.has("hms.ttl")) {
            this.setSentTime(currentJsonPayload.optLong("hms.sent_time", currentTime) / (long)1000);
            this.setTtl(currentJsonPayload.optInt("hms.ttl", 259200));
        } else {
            this.setSentTime(currentTime / (long)1000);
            this.setTtl(259200);
        }
        this.setNotificationId(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"i"));
        this.setTemplateId(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"ti"));
        this.setTemplateName(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"tn"));
        this.setRawPayload(currentJsonPayload.toString());
        this.setAdditionalData(JSONObjectExtensionsKt.safeJSONObject((JSONObject)customJson, (String)"a"));
        this.setLaunchURL(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"u"));
        this.setBody(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"alert"));
        this.setTitle(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"title"));
        this.setSmallIcon(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"sicon"));
        this.setBigPicture(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"bicon"));
        this.setLargeIcon(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"licon"));
        this.setSound(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"sound"));
        this.setGroupKey(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"grp"));
        this.setGroupMessage(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"grp_msg"));
        this.setSmallIconAccentColor(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"bgac"));
        this.setLedColor(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"ledc"));
        String visibility = JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"vis");
        if (visibility != null) {
            this.setLockScreenVisibility(Integer.parseInt(visibility));
        }
        this.setFromProjectNumber(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"from"));
        this.setPriority(currentJsonPayload.optInt("pri", 0));
        String collapseKey = JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"collapse_key");
        if (!Intrinsics.areEqual((Object)"do_not_collapse", (Object)collapseKey)) {
            this.setCollapseId(collapseKey);
        }
        try {
            this.setActionButtonsFromData();
        }
        catch (Throwable t) {
            Logging.error((String)"Error assigning OSNotificationReceivedEvent.actionButtons values!", (Throwable)t);
        }
        try {
            this.setBackgroundImageLayoutFromData(currentJsonPayload);
        }
        catch (Throwable t) {
            Logging.error((String)"Error assigning OSNotificationReceivedEvent.backgroundImageLayout values!", (Throwable)t);
        }
    }

    private final void setActionButtonsFromData() throws Throwable {
        if (this.getAdditionalData() != null) {
            JSONObject jSONObject = this.getAdditionalData();
            Intrinsics.checkNotNull((Object)jSONObject);
            if (jSONObject.has("actionButtons")) {
                JSONObject jSONObject2 = this.getAdditionalData();
                Intrinsics.checkNotNull((Object)jSONObject2);
                JSONArray jsonActionButtons = jSONObject2.getJSONArray("actionButtons");
                List actionBtns = new ArrayList();
                int n = jsonActionButtons.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                    ActionButton actionButton = new ActionButton();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonActionButton, (String)"jsonActionButton");
                    actionButton.setId(JSONObjectExtensionsKt.safeString((JSONObject)jsonActionButton, (String)"id"));
                    actionButton.setText(JSONObjectExtensionsKt.safeString((JSONObject)jsonActionButton, (String)"text"));
                    actionButton.setIcon(JSONObjectExtensionsKt.safeString((JSONObject)jsonActionButton, (String)"icon"));
                    actionBtns.add(actionButton);
                }
                this.setActionButtons(actionBtns);
                JSONObject jSONObject3 = this.getAdditionalData();
                Intrinsics.checkNotNull((Object)jSONObject3);
                jSONObject3.remove("actionId");
                JSONObject jSONObject4 = this.getAdditionalData();
                Intrinsics.checkNotNull((Object)jSONObject4);
                jSONObject4.remove("actionButtons");
            }
        }
    }

    private final void setBackgroundImageLayoutFromData(JSONObject currentJsonPayload) throws Throwable {
        String jsonStrBgImage = JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"bg_img");
        if (jsonStrBgImage != null) {
            JSONObject jsonBgImage = new JSONObject(jsonStrBgImage);
            this.setBackgroundImageLayout(new BackgroundImageLayout(JSONObjectExtensionsKt.safeString((JSONObject)jsonBgImage, (String)"img"), JSONObjectExtensionsKt.safeString((JSONObject)jsonBgImage, (String)"tc"), JSONObjectExtensionsKt.safeString((JSONObject)jsonBgImage, (String)"bc")));
        }
    }

    @NotNull
    public IMutableNotification mutableCopy() {
        return new MutableNotification(this);
    }

    @NotNull
    public final Notification copy() {
        return new OSNotificationBuilder().setNotificationExtender(this.notificationExtender).setGroupedNotifications(this.getGroupedNotifications()).setAndroidNotificationId(this.getAndroidNotificationId()).setNotificationId(this.getNotificationId()).setTemplateName(this.getTemplateName()).setTemplateId(this.getTemplateId()).setTitle(this.getTitle()).setBody(this.getBody()).setAdditionalData(this.getAdditionalData()).setSmallIcon(this.getSmallIcon()).setLargeIcon(this.getLargeIcon()).setBigPicture(this.getBigPicture()).setSmallIconAccentColor(this.getSmallIconAccentColor()).setLaunchURL(this.getLaunchURL()).setSound(this.getSound()).setLedColor(this.getLedColor()).setLockScreenVisibility(this.getLockScreenVisibility()).setGroupKey(this.getGroupKey()).setGroupMessage(this.getGroupMessage()).setActionButtons(this.getActionButtons()).setFromProjectNumber(this.getFromProjectNumber()).setBackgroundImageLayout(this.getBackgroundImageLayout()).setCollapseId(this.getCollapseId()).setPriority(this.getPriority()).setRawPayload(this.getRawPayload()).setSenttime(this.getSentTime()).setTTL(this.getTtl()).build();
    }

    public final boolean hasNotificationId() {
        return this.getAndroidNotificationId() != 0;
    }

    @NotNull
    public final JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("androidNotificationId", this.getAndroidNotificationId());
            JSONArray payloadJsonArray = new JSONArray();
            if (this.getGroupedNotifications() != null) {
                List<Notification> list = this.getGroupedNotifications();
                Intrinsics.checkNotNull(list);
                for (Notification notification : list) {
                    payloadJsonArray.put((Object)notification.toJSONObject());
                }
            }
            mainObj.put("groupedNotifications", (Object)payloadJsonArray);
            mainObj.put("notificationId", (Object)this.getNotificationId());
            mainObj.put("templateName", (Object)this.getTemplateName());
            mainObj.put("templateId", (Object)this.getTemplateId());
            mainObj.put("title", (Object)this.getTitle());
            mainObj.put("body", (Object)this.getBody());
            mainObj.put("smallIcon", (Object)this.getSmallIcon());
            mainObj.put("largeIcon", (Object)this.getLargeIcon());
            mainObj.put("bigPicture", (Object)this.getBigPicture());
            mainObj.put("smallIconAccentColor", (Object)this.getSmallIconAccentColor());
            mainObj.put("launchURL", (Object)this.getLaunchURL());
            mainObj.put("sound", (Object)this.getSound());
            mainObj.put("ledColor", (Object)this.getLedColor());
            mainObj.put("lockScreenVisibility", this.getLockScreenVisibility());
            mainObj.put("groupKey", (Object)this.getGroupKey());
            mainObj.put("groupMessage", (Object)this.getGroupMessage());
            mainObj.put("fromProjectNumber", (Object)this.getFromProjectNumber());
            mainObj.put("collapseId", (Object)this.getCollapseId());
            mainObj.put("priority", this.getPriority());
            if (this.getAdditionalData() != null) {
                mainObj.put("additionalData", (Object)this.getAdditionalData());
            }
            if (this.getActionButtons() != null) {
                JSONArray actionButtonJsonArray = new JSONArray();
                List<IActionButton> list = this.getActionButtons();
                Intrinsics.checkNotNull(list);
                for (IActionButton actionButton : list) {
                    Intrinsics.checkNotNull((Object)actionButton, (String)"null cannot be cast to non-null type com.onesignal.notifications.internal.Notification.ActionButton");
                    actionButtonJsonArray.put((Object)((ActionButton)actionButton).toJSONObject());
                }
                mainObj.put("actionButtons", (Object)actionButtonJsonArray);
            }
            mainObj.put("rawPayload", (Object)this.getRawPayload());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OSNotification{notificationExtender=").append(this.notificationExtender).append(", groupedNotifications=").append(this.getGroupedNotifications()).append(", androidNotificationId=").append(this.getAndroidNotificationId()).append(", notificationId='").append(this.getNotificationId()).append("', templateName='").append(this.getTemplateName()).append("', templateId='").append(this.getTemplateId()).append("', title='").append(this.getTitle()).append("', body='").append(this.getBody()).append("', additionalData=").append(this.getAdditionalData()).append(", smallIcon='").append(this.getSmallIcon()).append("', largeIcon='").append(this.getLargeIcon()).append("', bigPicture='");
        stringBuilder.append(this.getBigPicture()).append("', smallIconAccentColor='").append(this.getSmallIconAccentColor()).append("', launchURL='").append(this.getLaunchURL()).append("', sound='").append(this.getSound()).append("', ledColor='").append(this.getLedColor()).append("', lockScreenVisibility=").append(this.getLockScreenVisibility()).append(", groupKey='").append(this.getGroupKey()).append("', groupMessage='").append(this.getGroupMessage()).append("', actionButtons=").append(this.getActionButtons()).append(", fromProjectNumber='").append(this.getFromProjectNumber()).append("', backgroundImageLayout=").append(this.getBackgroundImageLayout()).append(", collapseId='").append(this.getCollapseId());
        stringBuilder.append("', priority=").append(this.getPriority()).append(", rawPayload='").append(this.getRawPayload()).append("'}");
        return stringBuilder.toString();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B%\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0004R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001c\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/onesignal/notifications/internal/Notification$ActionButton;", "Lcom/onesignal/notifications/IActionButton;", "()V", "jsonObject", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "id", "", "text", "icon", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIcon", "()Ljava/lang/String;", "setIcon", "(Ljava/lang/String;)V", "getId", "setId", "getText", "setText", "toJSONObject", "notifications_release"})
    public static final class ActionButton
    implements IActionButton {
        @Nullable
        private String id;
        @Nullable
        private String text;
        @Nullable
        private String icon;

        @Nullable
        public String getId() {
            return this.id;
        }

        public void setId(@Nullable String string) {
            this.id = string;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        public void setText(@Nullable String string) {
            this.text = string;
        }

        @Nullable
        public String getIcon() {
            return this.icon;
        }

        public void setIcon(@Nullable String string) {
            this.icon = string;
        }

        public ActionButton() {
        }

        public ActionButton(@NotNull JSONObject jsonObject) {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            this.setId(JSONObjectExtensionsKt.safeString((JSONObject)jsonObject, (String)"id"));
            this.setText(JSONObjectExtensionsKt.safeString((JSONObject)jsonObject, (String)"text"));
            this.setIcon(JSONObjectExtensionsKt.safeString((JSONObject)jsonObject, (String)"icon"));
        }

        public ActionButton(@Nullable String id, @Nullable String text, @Nullable String icon) {
            this.setId(id);
            this.setText(text);
            this.setIcon(icon);
        }

        @NotNull
        public final JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                json.put("id", (Object)this.getId());
                json.put("text", (Object)this.getText());
                json.put("icon", (Object)this.getIcon());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return json;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b$\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010'\u001a\u00020\u0014J\u0016\u0010(\u001a\u00020\u00002\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004J\u0010\u0010)\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010+\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010,\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010-\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u0010\u0010.\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\rJ\u0010\u0010/\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\rJ\u0010\u00100\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\rJ\u0010\u00101\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0016\u00102\u001a\u00020\u00002\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0004J\u0010\u00103\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\rJ\u0010\u00104\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\rJ\u0010\u00105\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\rJ\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\tJ\u0010\u00107\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u00108\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\rJ\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\tJ\u0010\u0010:\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\rJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010<\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\rJ\u0010\u0010=\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\rJ\u0010\u0010>\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\rJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\tJ\u0010\u0010@\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010\rJ\u0010\u0010A\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\rJ\u0010\u0010B\u001a\u00020\u00002\b\u0010%\u001a\u0004\u0018\u00010\rR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/onesignal/notifications/internal/Notification$OSNotificationBuilder;", "", "()V", "actionButtons", "", "Lcom/onesignal/notifications/IActionButton;", "additionalData", "Lorg/json/JSONObject;", "androidNotificationId", "", "backgroundImageLayout", "Lcom/onesignal/notifications/BackgroundImageLayout;", "bigPicture", "", "body", "collapseId", "fromProjectNumber", "groupKey", "groupMessage", "groupedNotifications", "Lcom/onesignal/notifications/internal/Notification;", "largeIcon", "launchURL", "ledColor", "lockScreenVisibility", "notificationExtender", "Landroidx/core/app/NotificationCompat$Extender;", "notificationId", "priority", "rawPayload", "sentTime", "", "smallIcon", "smallIconAccentColor", "sound", "templateId", "templateName", "title", "ttl", "build", "setActionButtons", "setAdditionalData", "setAndroidNotificationId", "setBackgroundImageLayout", "setBigPicture", "setBody", "setCollapseId", "setFromProjectNumber", "setGroupKey", "setGroupMessage", "setGroupedNotifications", "setLargeIcon", "setLaunchURL", "setLedColor", "setLockScreenVisibility", "setNotificationExtender", "setNotificationId", "setPriority", "setRawPayload", "setSenttime", "setSmallIcon", "setSmallIconAccentColor", "setSound", "setTTL", "setTemplateId", "setTemplateName", "setTitle", "notifications_release"})
    public static final class OSNotificationBuilder {
        @Nullable
        private NotificationCompat.Extender notificationExtender;
        @Nullable
        private List<? extends Notification> groupedNotifications;
        private int androidNotificationId;
        @Nullable
        private String notificationId;
        @Nullable
        private String templateName;
        @Nullable
        private String templateId;
        @Nullable
        private String title;
        @Nullable
        private String body;
        @Nullable
        private JSONObject additionalData;
        @Nullable
        private String smallIcon;
        @Nullable
        private String largeIcon;
        @Nullable
        private String bigPicture;
        @Nullable
        private String smallIconAccentColor;
        @Nullable
        private String launchURL;
        @Nullable
        private String sound;
        @Nullable
        private String ledColor;
        private int lockScreenVisibility = 1;
        @Nullable
        private String groupKey;
        @Nullable
        private String groupMessage;
        @Nullable
        private List<? extends IActionButton> actionButtons;
        @Nullable
        private String fromProjectNumber;
        @Nullable
        private BackgroundImageLayout backgroundImageLayout;
        @Nullable
        private String collapseId;
        private int priority;
        @Nullable
        private String rawPayload;
        private long sentTime;
        private int ttl;

        @NotNull
        public final OSNotificationBuilder setNotificationExtender(@Nullable NotificationCompat.Extender notificationExtender) {
            this.notificationExtender = notificationExtender;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setGroupedNotifications(@Nullable List<? extends Notification> groupedNotifications) {
            this.groupedNotifications = groupedNotifications;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setAndroidNotificationId(int androidNotificationId) {
            this.androidNotificationId = androidNotificationId;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setNotificationId(@Nullable String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setBody(@Nullable String body) {
            this.body = body;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setAdditionalData(@Nullable JSONObject additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setSmallIcon(@Nullable String smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setLargeIcon(@Nullable String largeIcon) {
            this.largeIcon = largeIcon;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setBigPicture(@Nullable String bigPicture) {
            this.bigPicture = bigPicture;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setSmallIconAccentColor(@Nullable String smallIconAccentColor) {
            this.smallIconAccentColor = smallIconAccentColor;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setLaunchURL(@Nullable String launchURL) {
            this.launchURL = launchURL;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setSound(@Nullable String sound) {
            this.sound = sound;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setLedColor(@Nullable String ledColor) {
            this.ledColor = ledColor;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setLockScreenVisibility(int lockScreenVisibility) {
            this.lockScreenVisibility = lockScreenVisibility;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setGroupKey(@Nullable String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setGroupMessage(@Nullable String groupMessage) {
            this.groupMessage = groupMessage;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setActionButtons(@Nullable List<? extends IActionButton> actionButtons) {
            this.actionButtons = actionButtons;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setFromProjectNumber(@Nullable String fromProjectNumber) {
            this.fromProjectNumber = fromProjectNumber;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setBackgroundImageLayout(@Nullable BackgroundImageLayout backgroundImageLayout) {
            this.backgroundImageLayout = backgroundImageLayout;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setCollapseId(@Nullable String collapseId) {
            this.collapseId = collapseId;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setRawPayload(@Nullable String rawPayload) {
            this.rawPayload = rawPayload;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setSenttime(long sentTime) {
            this.sentTime = sentTime;
            return this;
        }

        @NotNull
        public final OSNotificationBuilder setTTL(int ttl) {
            this.ttl = ttl;
            return this;
        }

        @NotNull
        public final Notification build() {
            Notification payload = new Notification();
            payload.setNotificationExtender(this.notificationExtender);
            payload.setGroupedNotifications(this.groupedNotifications);
            payload.setAndroidNotificationId(this.androidNotificationId);
            payload.setNotificationId(this.notificationId);
            payload.setTemplateName(this.templateName);
            payload.setTemplateId(this.templateId);
            payload.setTitle(this.title);
            payload.setBody(this.body);
            payload.setAdditionalData(this.additionalData);
            payload.setSmallIcon(this.smallIcon);
            payload.setLargeIcon(this.largeIcon);
            payload.setBigPicture(this.bigPicture);
            payload.setSmallIconAccentColor(this.smallIconAccentColor);
            payload.setLaunchURL(this.launchURL);
            payload.setSound(this.sound);
            payload.setLedColor(this.ledColor);
            payload.setLockScreenVisibility(this.lockScreenVisibility);
            payload.setGroupKey(this.groupKey);
            payload.setGroupMessage(this.groupMessage);
            payload.setActionButtons(this.actionButtons);
            payload.setFromProjectNumber(this.fromProjectNumber);
            payload.setBackgroundImageLayout(this.backgroundImageLayout);
            payload.setCollapseId(this.collapseId);
            payload.setPriority(this.priority);
            payload.setRawPayload(this.rawPayload);
            payload.setSentTime(this.sentTime);
            payload.setTtl(this.ttl);
            return payload;
        }
    }
}

