/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.common;

import android.net.Uri;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.notifications.internal.Notification;
import com.onesignal.notifications.internal.common.NotificationHelper;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\u0006\u0010L\u001a\u00020\u001cJ\b\u0010M\u001a\u00020\u0014H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010$R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010*\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010/\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001a\"\u0004\b8\u00109R\u001e\u0010:\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010/\u001a\u0004\b;\u0010,\"\u0004\b<\u0010.R\u001c\u0010=\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00103\"\u0004\b?\u00105R\u001c\u0010@\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001a\"\u0004\bB\u00109R\u001e\u0010C\u001a\u0004\u0018\u00010DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010I\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0013\u0010J\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u001a\u00a8\u0006N"}, d2={"Lcom/onesignal/notifications/internal/common/NotificationGenerationJob;", "", "()V", "jsonPayload", "Lorg/json/JSONObject;", "time", "Lcom/onesignal/core/internal/time/ITime;", "(Lorg/json/JSONObject;Lcom/onesignal/core/internal/time/ITime;)V", "notification", "Lcom/onesignal/notifications/internal/Notification;", "(Lcom/onesignal/notifications/internal/Notification;Lorg/json/JSONObject;)V", "_notification", "additionalData", "getAdditionalData", "()Lorg/json/JSONObject;", "androidId", "", "getAndroidId", "()I", "apiNotificationId", "", "getApiNotificationId", "()Ljava/lang/String;", "body", "", "getBody", "()Ljava/lang/CharSequence;", "isNotificationToDisplay", "", "()Z", "setNotificationToDisplay", "(Z)V", "isRestoring", "setRestoring", "getJsonPayload", "setJsonPayload", "(Lorg/json/JSONObject;)V", "value", "getNotification", "()Lcom/onesignal/notifications/internal/Notification;", "setNotification", "(Lcom/onesignal/notifications/internal/Notification;)V", "orgFlags", "getOrgFlags", "()Ljava/lang/Integer;", "setOrgFlags", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "orgSound", "Landroid/net/Uri;", "getOrgSound", "()Landroid/net/Uri;", "setOrgSound", "(Landroid/net/Uri;)V", "overriddenBodyFromExtender", "getOverriddenBodyFromExtender", "setOverriddenBodyFromExtender", "(Ljava/lang/CharSequence;)V", "overriddenFlags", "getOverriddenFlags", "setOverriddenFlags", "overriddenSound", "getOverriddenSound", "setOverriddenSound", "overriddenTitleFromExtender", "getOverriddenTitleFromExtender", "setOverriddenTitleFromExtender", "shownTimeStamp", "", "getShownTimeStamp", "()Ljava/lang/Long;", "setShownTimeStamp", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "title", "getTitle", "hasExtender", "toString", "notifications_release"})
public final class NotificationGenerationJob {
    @Nullable
    private Notification _notification;
    @Nullable
    private JSONObject jsonPayload;
    private boolean isRestoring;
    private boolean isNotificationToDisplay;
    @Nullable
    private Long shownTimeStamp;
    @Nullable
    private CharSequence overriddenBodyFromExtender;
    @Nullable
    private CharSequence overriddenTitleFromExtender;
    @Nullable
    private Uri overriddenSound;
    @Nullable
    private Integer overriddenFlags;
    @Nullable
    private Integer orgFlags;
    @Nullable
    private Uri orgSound;

    @Nullable
    public final Notification getNotification() {
        return this._notification;
    }

    public final void setNotification(@Nullable Notification value) {
        if (value != null && !value.hasNotificationId()) {
            Notification curNotification = this._notification;
            if (curNotification != null && curNotification.hasNotificationId()) {
                value.setAndroidNotificationId(curNotification.getAndroidNotificationId());
            } else {
                value.setAndroidNotificationId(new SecureRandom().nextInt());
            }
        }
        this._notification = value;
    }

    @Nullable
    public final JSONObject getJsonPayload() {
        return this.jsonPayload;
    }

    public final void setJsonPayload(@Nullable JSONObject jSONObject) {
        this.jsonPayload = jSONObject;
    }

    public final boolean isRestoring() {
        return this.isRestoring;
    }

    public final void setRestoring(boolean bl) {
        this.isRestoring = bl;
    }

    public final boolean isNotificationToDisplay() {
        return this.isNotificationToDisplay;
    }

    public final void setNotificationToDisplay(boolean bl) {
        this.isNotificationToDisplay = bl;
    }

    @Nullable
    public final Long getShownTimeStamp() {
        return this.shownTimeStamp;
    }

    public final void setShownTimeStamp(@Nullable Long l) {
        this.shownTimeStamp = l;
    }

    @Nullable
    public final CharSequence getOverriddenBodyFromExtender() {
        return this.overriddenBodyFromExtender;
    }

    public final void setOverriddenBodyFromExtender(@Nullable CharSequence charSequence) {
        this.overriddenBodyFromExtender = charSequence;
    }

    @Nullable
    public final CharSequence getOverriddenTitleFromExtender() {
        return this.overriddenTitleFromExtender;
    }

    public final void setOverriddenTitleFromExtender(@Nullable CharSequence charSequence) {
        this.overriddenTitleFromExtender = charSequence;
    }

    @Nullable
    public final Uri getOverriddenSound() {
        return this.overriddenSound;
    }

    public final void setOverriddenSound(@Nullable Uri uri) {
        this.overriddenSound = uri;
    }

    @Nullable
    public final Integer getOverriddenFlags() {
        return this.overriddenFlags;
    }

    public final void setOverriddenFlags(@Nullable Integer n) {
        this.overriddenFlags = n;
    }

    @Nullable
    public final Integer getOrgFlags() {
        return this.orgFlags;
    }

    public final void setOrgFlags(@Nullable Integer n) {
        this.orgFlags = n;
    }

    @Nullable
    public final Uri getOrgSound() {
        return this.orgSound;
    }

    public final void setOrgSound(@Nullable Uri uri) {
        this.orgSound = uri;
    }

    public NotificationGenerationJob() {
    }

    public NotificationGenerationJob(@Nullable JSONObject jsonPayload, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        JSONObject jSONObject = jsonPayload;
        Intrinsics.checkNotNull((Object)jSONObject);
        this(new Notification(jSONObject, time), jsonPayload);
    }

    public NotificationGenerationJob(@NotNull Notification notification, @Nullable JSONObject jsonPayload) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.jsonPayload = jsonPayload;
        this.setNotification(notification);
    }

    @Nullable
    public final CharSequence getTitle() {
        CharSequence charSequence = this.overriddenTitleFromExtender;
        if (charSequence == null) {
            Notification notification = this.getNotification();
            Intrinsics.checkNotNull((Object)notification);
            charSequence = notification.getTitle();
        }
        return charSequence;
    }

    @Nullable
    public final CharSequence getBody() {
        CharSequence charSequence = this.overriddenBodyFromExtender;
        if (charSequence == null) {
            Notification notification = this.getNotification();
            Intrinsics.checkNotNull((Object)notification);
            charSequence = notification.getBody();
        }
        return charSequence;
    }

    @NotNull
    public final JSONObject getAdditionalData() {
        Notification notification = this.getNotification();
        Intrinsics.checkNotNull((Object)notification);
        JSONObject jSONObject = notification.getAdditionalData();
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    public final boolean hasExtender() {
        Notification notification = this.getNotification();
        Intrinsics.checkNotNull((Object)notification);
        return notification.getNotificationExtender() != null;
    }

    @NotNull
    public final String getApiNotificationId() {
        String string = NotificationHelper.INSTANCE.getNotificationIdFromFCMJson(this.jsonPayload);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final int getAndroidId() {
        Notification notification = this.getNotification();
        Intrinsics.checkNotNull((Object)notification);
        return notification.getAndroidNotificationId();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NotificationGenerationJob{jsonPayload=").append(this.jsonPayload).append(", isRestoring=").append(this.isRestoring).append(", isNotificationToDisplay=").append(this.isNotificationToDisplay).append(", shownTimeStamp=").append(this.shownTimeStamp).append(", overriddenBodyFromExtender=").append((Object)this.overriddenBodyFromExtender).append(", overriddenTitleFromExtender=").append((Object)this.overriddenTitleFromExtender).append(", overriddenSound=").append(this.overriddenSound).append(", overriddenFlags=").append(this.overriddenFlags).append(", orgFlags=").append(this.orgFlags).append(", orgSound=").append(this.orgSound).append(", notification=").append(this.getNotification()).append('}');
        return stringBuilder.toString();
    }
}

