/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.location.internal.capture.impl;

import android.location.Location;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.location.internal.capture.ILocationCapturer;
import com.onesignal.location.internal.common.LocationPoint;
import com.onesignal.location.internal.controller.ILocationController;
import com.onesignal.location.internal.controller.ILocationUpdatedHandler;
import com.onesignal.location.internal.preferences.ILocationPreferencesService;
import com.onesignal.user.internal.properties.PropertiesModel;
import com.onesignal.user.internal.properties.PropertiesModelStore;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/onesignal/location/internal/capture/impl/LocationCapturer;", "Lcom/onesignal/location/internal/controller/ILocationUpdatedHandler;", "Lcom/onesignal/location/internal/capture/ILocationCapturer;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "_prefs", "Lcom/onesignal/location/internal/preferences/ILocationPreferencesService;", "_propertiesModelStore", "Lcom/onesignal/user/internal/properties/PropertiesModelStore;", "_controller", "Lcom/onesignal/location/internal/controller/ILocationController;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/time/ITime;Lcom/onesignal/location/internal/preferences/ILocationPreferencesService;Lcom/onesignal/user/internal/properties/PropertiesModelStore;Lcom/onesignal/location/internal/controller/ILocationController;)V", "locationCoarse", "", "getLocationCoarse", "()Z", "setLocationCoarse", "(Z)V", "capture", "", "location", "Landroid/location/Location;", "captureLastLocation", "onLocationChanged", "com.onesignal.location"})
public final class LocationCapturer
implements ILocationUpdatedHandler,
ILocationCapturer {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ITime _time;
    @NotNull
    private final ILocationPreferencesService _prefs;
    @NotNull
    private final PropertiesModelStore _propertiesModelStore;
    @NotNull
    private final ILocationController _controller;
    private boolean locationCoarse;

    public LocationCapturer(@NotNull IApplicationService _applicationService, @NotNull ITime _time, @NotNull ILocationPreferencesService _prefs, @NotNull PropertiesModelStore _propertiesModelStore, @NotNull ILocationController _controller) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        Intrinsics.checkNotNullParameter((Object)_prefs, (String)"_prefs");
        Intrinsics.checkNotNullParameter((Object)_propertiesModelStore, (String)"_propertiesModelStore");
        Intrinsics.checkNotNullParameter((Object)_controller, (String)"_controller");
        this._applicationService = _applicationService;
        this._time = _time;
        this._prefs = _prefs;
        this._propertiesModelStore = _propertiesModelStore;
        this._controller = _controller;
        this._controller.subscribe(this);
    }

    @Override
    public boolean getLocationCoarse() {
        return this.locationCoarse;
    }

    @Override
    public void setLocationCoarse(boolean bl) {
        this.locationCoarse = bl;
    }

    @Override
    public void captureLastLocation() {
        Location location = this._controller.getLastLocation();
        if (location != null) {
            this.capture(location);
        } else {
            this._prefs.setLastLocationTime(this._time.getCurrentTimeMillis());
        }
    }

    @Override
    public void onLocationChanged(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Logging.debug$default((String)("LocationController fireCompleteForLocation with location: " + location), null, (int)2, null);
        this.capture(location);
    }

    private final void capture(Location location) {
        LocationPoint point = new LocationPoint();
        point.setAccuracy(Float.valueOf(location.getAccuracy()));
        point.setBg(!this._applicationService.isInForeground());
        point.setType(this.getLocationCoarse() ? Integer.valueOf(0) : Integer.valueOf(1));
        point.setTimeStamp(location.getTime());
        if (this.getLocationCoarse()) {
            point.setLat(new BigDecimal(location.getLatitude()).setScale(7, RoundingMode.HALF_UP).doubleValue());
            point.setLog(new BigDecimal(location.getLongitude()).setScale(7, RoundingMode.HALF_UP).doubleValue());
        } else {
            point.setLat(location.getLatitude());
            point.setLog(location.getLongitude());
        }
        PropertiesModel userProperties = (PropertiesModel)this._propertiesModelStore.getModel();
        userProperties.setLocationLongitude(point.getLog());
        userProperties.setLocationLatitude(point.getLat());
        userProperties.setLocationAccuracy(point.getAccuracy());
        userProperties.setLocationBackground(point.getBg());
        userProperties.setLocationType(point.getType());
        userProperties.setLocationTimestamp(point.getTimeStamp());
        this._prefs.setLastLocationTime(this._time.getCurrentTimeMillis());
    }
}

