/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/onesignal/core/internal/preferences/PreferenceStoreFix;", "", "()V", "ensureNoObfuscatedPrefStore", "", "context", "Landroid/content/Context;", "com.onesignal.core"})
public final class PreferenceStoreFix {
    @NotNull
    public static final PreferenceStoreFix INSTANCE = new PreferenceStoreFix();

    private PreferenceStoreFix() {
    }

    public final void ensureNoObfuscatedPrefStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            File sharedPrefsDir = Build.VERSION.SDK_INT >= 24 ? new File(context.getDataDir(), "shared_prefs") : new File(context.getFilesDir().getParentFile(), "shared_prefs");
            File osPrefsFile = new File(sharedPrefsDir, "OneSignal.xml");
            if (!sharedPrefsDir.exists() || !sharedPrefsDir.isDirectory() || osPrefsFile.exists()) {
                return;
            }
            File[] fileArray = sharedPrefsDir.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File prefsFile : fileArray) {
                Intrinsics.checkNotNull((Object)prefsFile);
                SharedPreferences prefsStore = context.getSharedPreferences(FilesKt.getNameWithoutExtension((File)prefsFile), 0);
                if (!prefsStore.contains("GT_PLAYER_ID")) continue;
                prefsFile.renameTo(osPrefsFile);
                return;
            }
        }
        catch (Throwable e) {
            Logging.log(LogLevel.ERROR, "error attempting to fix obfuscated preference store", e);
        }
    }
}

