/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal;

import com.onesignal.common.IDManager;
import com.onesignal.common.JSONUtils;
import com.onesignal.common.OneSignalUtils;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.modeling.ISingletonModelStoreChangeHandler;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.core.internal.language.ILanguageContext;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.user.IUserManager;
import com.onesignal.user.internal.customEvents.ICustomEventController;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.properties.PropertiesModel;
import com.onesignal.user.internal.properties.PropertiesModelStore;
import com.onesignal.user.internal.subscriptions.ISubscriptionManager;
import com.onesignal.user.internal.subscriptions.SubscriptionList;
import com.onesignal.user.state.IUserStateObserver;
import com.onesignal.user.state.UserChangedState;
import com.onesignal.user.state.UserState;
import com.onesignal.user.subscriptions.IPushSubscription;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\b\u0010\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0018H\u0016J\u001c\u00101\u001a\u00020.2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u0018H\u0016J\u0010\u00104\u001a\u00020.2\u0006\u00105\u001a\u00020\u001dH\u0016J\u0010\u00106\u001a\u00020.2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0018\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u0018H\u0016J\u001c\u0010;\u001a\u00020.2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0014\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0018H\u0016J\u0018\u0010A\u001a\u00020.2\u0006\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020\u0018H\u0016J\u0010\u0010D\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0018H\u0016J\u0016\u0010E\u001a\u00020.2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00180GH\u0016J\u0010\u0010H\u001a\u00020.2\u0006\u00103\u001a\u00020\u0018H\u0016J\u0010\u0010I\u001a\u00020.2\u0006\u00105\u001a\u00020\u001dH\u0016J\u0010\u0010J\u001a\u00020.2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0010\u0010K\u001a\u00020.2\u0006\u00109\u001a\u00020\u0018H\u0016J\u0016\u0010L\u001a\u00020.2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00180GH\u0016J\u0010\u0010N\u001a\u00020.2\u0006\u0010:\u001a\u00020\u0018H\u0016J&\u0010O\u001a\u00020.2\u0006\u0010P\u001a\u00020\u00182\u0014\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020R\u0018\u00010\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006S"}, d2={"Lcom/onesignal/user/internal/UserManager;", "Lcom/onesignal/user/IUserManager;", "Lcom/onesignal/common/modeling/ISingletonModelStoreChangeHandler;", "Lcom/onesignal/user/internal/identity/IdentityModel;", "_subscriptionManager", "Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "_propertiesModelStore", "Lcom/onesignal/user/internal/properties/PropertiesModelStore;", "_customEventController", "Lcom/onesignal/user/internal/customEvents/ICustomEventController;", "_languageContext", "Lcom/onesignal/core/internal/language/ILanguageContext;", "(Lcom/onesignal/user/internal/subscriptions/ISubscriptionManager;Lcom/onesignal/user/internal/identity/IdentityModelStore;Lcom/onesignal/user/internal/properties/PropertiesModelStore;Lcom/onesignal/user/internal/customEvents/ICustomEventController;Lcom/onesignal/core/internal/language/ILanguageContext;)V", "_identityModel", "get_identityModel", "()Lcom/onesignal/user/internal/identity/IdentityModel;", "_propertiesModel", "Lcom/onesignal/user/internal/properties/PropertiesModel;", "get_propertiesModel", "()Lcom/onesignal/user/internal/properties/PropertiesModel;", "aliases", "", "", "getAliases", "()Ljava/util/Map;", "changeHandlersNotifier", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/user/state/IUserStateObserver;", "getChangeHandlersNotifier", "()Lcom/onesignal/common/events/EventProducer;", "externalId", "getExternalId", "()Ljava/lang/String;", "onesignalId", "getOnesignalId", "pushSubscription", "Lcom/onesignal/user/subscriptions/IPushSubscription;", "getPushSubscription", "()Lcom/onesignal/user/subscriptions/IPushSubscription;", "subscriptions", "Lcom/onesignal/user/internal/subscriptions/SubscriptionList;", "getSubscriptions", "()Lcom/onesignal/user/internal/subscriptions/SubscriptionList;", "addAlias", "", "label", "id", "addAliases", "addEmail", "email", "addObserver", "observer", "addSms", "sms", "addTag", "key", "value", "addTags", "tags", "getTags", "onModelReplaced", "model", "tag", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "removeAlias", "removeAliases", "labels", "", "removeEmail", "removeObserver", "removeSms", "removeTag", "removeTags", "keys", "setLanguage", "trackEvent", "name", "properties", "", "com.onesignal.core"})
public class UserManager
implements IUserManager,
ISingletonModelStoreChangeHandler<IdentityModel> {
    @NotNull
    private final ISubscriptionManager _subscriptionManager;
    @NotNull
    private final IdentityModelStore _identityModelStore;
    @NotNull
    private final PropertiesModelStore _propertiesModelStore;
    @NotNull
    private final ICustomEventController _customEventController;
    @NotNull
    private final ILanguageContext _languageContext;
    @NotNull
    private final EventProducer<IUserStateObserver> changeHandlersNotifier;

    public UserManager(@NotNull ISubscriptionManager _subscriptionManager, @NotNull IdentityModelStore _identityModelStore, @NotNull PropertiesModelStore _propertiesModelStore, @NotNull ICustomEventController _customEventController, @NotNull ILanguageContext _languageContext) {
        Intrinsics.checkNotNullParameter((Object)_subscriptionManager, (String)"_subscriptionManager");
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        Intrinsics.checkNotNullParameter((Object)_propertiesModelStore, (String)"_propertiesModelStore");
        Intrinsics.checkNotNullParameter((Object)_customEventController, (String)"_customEventController");
        Intrinsics.checkNotNullParameter((Object)_languageContext, (String)"_languageContext");
        this._subscriptionManager = _subscriptionManager;
        this._identityModelStore = _identityModelStore;
        this._propertiesModelStore = _propertiesModelStore;
        this._customEventController = _customEventController;
        this._languageContext = _languageContext;
        this.changeHandlersNotifier = new EventProducer();
        this._identityModelStore.subscribe(this);
    }

    @Override
    @NotNull
    public String getOnesignalId() {
        return IDManager.INSTANCE.isLocalId(this.get_identityModel().getOnesignalId()) ? "" : this.get_identityModel().getOnesignalId();
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string2 = this.get_identityModel().getExternalId();
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getAliases() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.get_identityModel();
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getKey(), (Object)"id"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return MapsKt.toMap((Map)destination$iv$iv);
    }

    @NotNull
    public final SubscriptionList getSubscriptions() {
        return this._subscriptionManager.getSubscriptions();
    }

    @NotNull
    public final EventProducer<IUserStateObserver> getChangeHandlersNotifier() {
        return this.changeHandlersNotifier;
    }

    @Override
    @NotNull
    public IPushSubscription getPushSubscription() {
        return this._subscriptionManager.getSubscriptions().getPush();
    }

    private final IdentityModel get_identityModel() {
        return (IdentityModel)this._identityModelStore.getModel();
    }

    private final PropertiesModel get_propertiesModel() {
        return (PropertiesModel)this._propertiesModelStore.getModel();
    }

    @Override
    public void setLanguage(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._languageContext.setLanguage(value);
    }

    @Override
    public void addAlias(@NotNull String label, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Logging.log(LogLevel.DEBUG, "setAlias(label: " + label + ", id: " + id + ')');
        if (((CharSequence)label).length() == 0) {
            Logging.log(LogLevel.ERROR, "Cannot add empty alias");
            return;
        }
        if (Intrinsics.areEqual((Object)label, (Object)"onesignal_id")) {
            Logging.log(LogLevel.ERROR, "Cannot add 'onesignal_id' alias");
            return;
        }
        ((Map)this.get_identityModel()).put(label, id);
    }

    @Override
    public void addAliases(@NotNull Map<String, String> aliases) {
        Map.Entry<String, String> it;
        Map.Entry<String, String> element$iv;
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        Logging.log(LogLevel.DEBUG, "addAliases(aliases: " + aliases);
        Map<String, String> $this$forEach$iv = aliases;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            if (((CharSequence)it.getKey()).length() == 0) {
                Logging.log(LogLevel.ERROR, "Cannot add empty alias");
                return;
            }
            if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"onesignal_id")) continue;
            Logging.log(LogLevel.ERROR, "Cannot add 'onesignal_id' alias");
            return;
        }
        $this$forEach$iv = aliases;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            ((Map)this.get_identityModel()).put(it.getKey(), it.getValue());
        }
    }

    @Override
    public void removeAlias(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Logging.log(LogLevel.DEBUG, "removeAlias(label: " + label + ')');
        if (((CharSequence)label).length() == 0) {
            Logging.log(LogLevel.ERROR, "Cannot remove empty alias");
            return;
        }
        if (Intrinsics.areEqual((Object)label, (Object)"onesignal_id")) {
            Logging.log(LogLevel.ERROR, "Cannot remove 'onesignal_id' alias");
            return;
        }
        this.get_identityModel().remove((Object)label);
    }

    @Override
    public void removeAliases(@NotNull Collection<String> labels) {
        String it;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Logging.log(LogLevel.DEBUG, "removeAliases(labels: " + labels + ')');
        Iterable $this$forEach$iv = labels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) {
                Logging.log(LogLevel.ERROR, "Cannot remove empty alias");
                return;
            }
            if (!Intrinsics.areEqual((Object)it, (Object)"onesignal_id")) continue;
            Logging.log(LogLevel.ERROR, "Cannot remove 'onesignal_id' alias");
            return;
        }
        $this$forEach$iv = labels;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.get_identityModel().remove((Object)it);
        }
    }

    @Override
    public void addEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Logging.log(LogLevel.DEBUG, "addEmail(email: " + email + ')');
        if (!OneSignalUtils.INSTANCE.isValidEmail(email)) {
            Logging.log(LogLevel.ERROR, "Cannot add invalid email address as subscription: " + email);
            return;
        }
        this._subscriptionManager.addEmailSubscription(email);
    }

    @Override
    public void removeEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Logging.log(LogLevel.DEBUG, "removeEmail(email: " + email + ')');
        if (!OneSignalUtils.INSTANCE.isValidEmail(email)) {
            Logging.log(LogLevel.ERROR, "Cannot remove invalid email address as subscription: " + email);
            return;
        }
        this._subscriptionManager.removeEmailSubscription(email);
    }

    @Override
    public void addSms(@NotNull String sms) {
        Intrinsics.checkNotNullParameter((Object)sms, (String)"sms");
        Logging.log(LogLevel.DEBUG, "addSms(sms: " + sms + ')');
        if (!OneSignalUtils.INSTANCE.isValidPhoneNumber(sms)) {
            Logging.log(LogLevel.ERROR, "Cannot add invalid sms number as subscription: " + sms);
            return;
        }
        this._subscriptionManager.addSmsSubscription(sms);
    }

    @Override
    public void removeSms(@NotNull String sms) {
        Intrinsics.checkNotNullParameter((Object)sms, (String)"sms");
        Logging.log(LogLevel.DEBUG, "removeSms(sms: " + sms + ')');
        if (!OneSignalUtils.INSTANCE.isValidPhoneNumber(sms)) {
            Logging.log(LogLevel.ERROR, "Cannot remove invalid sms number as subscription: " + sms);
            return;
        }
        this._subscriptionManager.removeSmsSubscription(sms);
    }

    @Override
    public void addTag(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Logging.log(LogLevel.DEBUG, "setTag(key: " + key + ", value: " + value + ')');
        if (((CharSequence)key).length() == 0) {
            Logging.log(LogLevel.ERROR, "Cannot add tag with empty key");
            return;
        }
        ((Map)this.get_propertiesModel().getTags()).put(key, value);
    }

    @Override
    public void addTags(@NotNull Map<String, String> tags2) {
        Map.Entry<String, String> it;
        Map.Entry<String, String> element$iv;
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        Logging.log(LogLevel.DEBUG, "setTags(tags: " + tags2 + ')');
        Map<String, String> $this$forEach$iv = tags2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            if (!(((CharSequence)it.getKey()).length() == 0)) continue;
            Logging.log(LogLevel.ERROR, "Cannot add tag with empty key");
            return;
        }
        $this$forEach$iv = tags2;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            ((Map)this.get_propertiesModel().getTags()).put(it.getKey(), it.getValue());
        }
    }

    @Override
    public void removeTag(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Logging.log(LogLevel.DEBUG, "removeTag(key: " + key + ')');
        if (((CharSequence)key).length() == 0) {
            Logging.log(LogLevel.ERROR, "Cannot remove tag with empty key");
            return;
        }
        this.get_propertiesModel().getTags().remove((Object)key);
    }

    @Override
    public void removeTags(@NotNull Collection<String> keys) {
        String it;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Logging.log(LogLevel.DEBUG, "removeTags(keys: " + keys + ')');
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() == 0)) continue;
            Logging.log(LogLevel.ERROR, "Cannot remove tag with empty key");
            return;
        }
        $this$forEach$iv = keys;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.get_propertiesModel().getTags().remove((Object)it);
        }
    }

    @Override
    @NotNull
    public Map<String, String> getTags() {
        return MapsKt.toMap((Map)this.get_propertiesModel().getTags());
    }

    @Override
    public void addObserver(@NotNull IUserStateObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.changeHandlersNotifier.subscribe(observer);
    }

    @Override
    public void removeObserver(@NotNull IUserStateObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.changeHandlersNotifier.unsubscribe(observer);
    }

    @Override
    public void trackEvent(@NotNull String name, @Nullable Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!JSONUtils.INSTANCE.isValidJsonObject(properties)) {
            Logging.log(LogLevel.ERROR, "Custom event properties are not JSON-serializable");
            return;
        }
        this._customEventController.sendCustomEvent(name, properties);
    }

    @Override
    public void onModelReplaced(@NotNull IdentityModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    @Override
    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (Intrinsics.areEqual((Object)args.getProperty(), (Object)"onesignal_id")) {
            UserState newUserState = new UserState(String.valueOf(args.getNewValue()), this.getExternalId());
            this.changeHandlersNotifier.fire((Function1<IUserStateObserver, Unit>)((Function1)new Function1<IUserStateObserver, Unit>(newUserState){
                final /* synthetic */ UserState $newUserState;
                {
                    this.$newUserState = $newUserState;
                    super(1);
                }

                public final void invoke(@NotNull IUserStateObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onUserStateChange(new UserChangedState(this.$newUserState));
                }
            }));
        }
    }
}

