/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.session.internal.influence.impl;

import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.session.internal.influence.InfluenceChannel;
import com.onesignal.session.internal.influence.InfluenceType;
import com.onesignal.session.internal.influence.impl.ChannelTracker;
import com.onesignal.session.internal.influence.impl.InfluenceDataRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/onesignal/session/internal/influence/impl/NotificationTracker;", "Lcom/onesignal/session/internal/influence/impl/ChannelTracker;", "dataRepository", "Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;", "timeProvider", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;Lcom/onesignal/core/internal/time/ITime;)V", "channelLimit", "", "getChannelLimit", "()I", "channelType", "Lcom/onesignal/session/internal/influence/InfluenceChannel;", "getChannelType", "()Lcom/onesignal/session/internal/influence/InfluenceChannel;", "idTag", "", "getIdTag", "()Ljava/lang/String;", "indirectAttributionWindow", "getIndirectAttributionWindow", "lastChannelObjects", "Lorg/json/JSONArray;", "getLastChannelObjects", "()Lorg/json/JSONArray;", "cacheState", "", "getLastChannelObjectsReceivedByNewId", "id", "initInfluencedTypeFromCache", "saveChannelObjects", "channelObjects", "com.onesignal.core"})
public final class NotificationTracker
extends ChannelTracker {
    public NotificationTracker(@NotNull InfluenceDataRepository dataRepository, @NotNull ITime timeProvider) {
        Intrinsics.checkNotNullParameter((Object)dataRepository, (String)"dataRepository");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        super(dataRepository, timeProvider);
    }

    @Override
    @NotNull
    public JSONArray getLastChannelObjectsReceivedByNewId(@Nullable String id) {
        JSONArray jSONArray;
        try {
            jSONArray = this.getLastChannelObjects();
        }
        catch (JSONException exception) {
            Logging.error("Generating Notification tracker getLastChannelObjects JSONObject ", exception);
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    @Override
    @NotNull
    public JSONArray getLastChannelObjects() throws JSONException {
        return this.getDataRepository().getLastNotificationsReceivedData();
    }

    @Override
    @NotNull
    public String getIdTag() {
        return "notification_id";
    }

    @Override
    @NotNull
    public InfluenceChannel getChannelType() {
        return InfluenceChannel.NOTIFICATION;
    }

    @Override
    public int getChannelLimit() {
        return this.getDataRepository().getNotificationLimit();
    }

    @Override
    public int getIndirectAttributionWindow() {
        return this.getDataRepository().getNotificationIndirectAttributionWindow();
    }

    @Override
    public void saveChannelObjects(@NotNull JSONArray channelObjects) {
        Intrinsics.checkNotNullParameter((Object)channelObjects, (String)"channelObjects");
        this.getDataRepository().saveNotifications(channelObjects);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initInfluencedTypeFromCache() {
        void it;
        InfluenceType influenceType;
        InfluenceType influenceType2 = influenceType = this.getDataRepository().getNotificationCachedInfluenceType();
        NotificationTracker notificationTracker = this;
        boolean bl = false;
        if (it.isIndirect()) {
            this.setIndirectIds(this.getLastReceivedIds());
        } else if (it.isDirect()) {
            this.setDirectId(this.getDataRepository().getCachedNotificationOpenId());
        }
        notificationTracker.setInfluenceType(influenceType);
        Logging.debug$default("NotificationTracker.initInfluencedTypeFromCache: " + this, null, 2, null);
    }

    @Override
    public void cacheState() {
        InfluenceDataRepository influenceDataRepository = this.getDataRepository();
        InfluenceType influenceType = this.getInfluenceType();
        if (influenceType == null) {
            influenceType = InfluenceType.UNATTRIBUTED;
        }
        influenceDataRepository.cacheNotificationInfluenceType(influenceType);
        this.getDataRepository().cacheNotificationOpenId(this.getDirectId());
    }
}

