/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.http.impl;

import android.net.TrafficStats;
import android.os.Build;
import com.onesignal.common.JSONUtils;
import com.onesignal.common.OneSignalWrapper;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.http.HttpResponse;
import com.onesignal.core.internal.http.IHttpClient;
import com.onesignal.core.internal.http.impl.HttpClient;
import com.onesignal.core.internal.http.impl.IHttpConnectionFactory;
import com.onesignal.core.internal.http.impl.TLS12SocketFactory;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.debug.internal.logging.Logging;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ#\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J?\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J?\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J!\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcom/onesignal/core/internal/http/impl/HttpClient;", "Lcom/onesignal/core/internal/http/IHttpClient;", "_connectionFactory", "Lcom/onesignal/core/internal/http/impl/IHttpConnectionFactory;", "_prefs", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "(Lcom/onesignal/core/internal/http/impl/IHttpConnectionFactory;Lcom/onesignal/core/internal/preferences/IPreferencesService;Lcom/onesignal/core/internal/config/ConfigModelStore;)V", "delete", "Lcom/onesignal/core/internal/http/HttpResponse;", "url", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "cacheKey", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getThreadTimeout", "", "timeout", "makeRequest", "method", "jsonBody", "Lorg/json/JSONObject;", "(Ljava/lang/String;Ljava/lang/String;Lorg/json/JSONObject;ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeRequestIODispatcher", "patch", "body", "(Ljava/lang/String;Lorg/json/JSONObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "post", "put", "Companion", "com.onesignal.core"})
public final class HttpClient
implements IHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IHttpConnectionFactory _connectionFactory;
    @NotNull
    private final IPreferencesService _prefs;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private static final String OS_API_VERSION = "1";
    @NotNull
    private static final String OS_ACCEPT_HEADER = "application/vnd.onesignal.v1+json";
    private static final int THREAD_ID = 10000;

    public HttpClient(@NotNull IHttpConnectionFactory _connectionFactory, @NotNull IPreferencesService _prefs, @NotNull ConfigModelStore _configModelStore) {
        Intrinsics.checkNotNullParameter((Object)_connectionFactory, (String)"_connectionFactory");
        Intrinsics.checkNotNullParameter((Object)_prefs, (String)"_prefs");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        this._connectionFactory = _connectionFactory;
        this._prefs = _prefs;
        this._configModelStore = _configModelStore;
    }

    @Override
    @Nullable
    public Object post(@NotNull String url, @NotNull JSONObject body, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "POST", body, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    @Override
    @Nullable
    public Object get(@NotNull String url, @Nullable String cacheKey, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, null, null, ((ConfigModel)this._configModelStore.getModel()).getHttpGetTimeout(), cacheKey, $completion);
    }

    @Override
    @Nullable
    public Object put(@NotNull String url, @NotNull JSONObject body, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "PUT", body, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    @Override
    @Nullable
    public Object patch(@NotNull String url, @NotNull JSONObject body, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "PATCH", body, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    @Override
    @Nullable
    public Object delete(@NotNull String url, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "DELETE", null, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object makeRequest(String var1_1, String var2_2, JSONObject var3_3, int var4_4, String var5_5, Continuation<? super HttpResponse> var6_6) {
        if (!(var6_6 instanceof makeRequest.1)) ** GOTO lbl-1000
        var9_7 = var6_6;
        if ((var9_7.label & -2147483648) != 0) {
            var9_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpClient.access$makeRequest(this.this$0, null, null, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (method != null && Intrinsics.areEqual((Object)((ConfigModel)this._configModelStore.getModel()).getConsentRequired(), (Object)Boxing.boxBoolean((boolean)true)) && !Intrinsics.areEqual((Object)((ConfigModel)this._configModelStore.getModel()).getConsentGiven(), (Object)Boxing.boxBoolean((boolean)true))) {
                    Logging.warn$default((String)method + " `" + url + "` was called before the user provided privacy consent. Your application is set to require the user's privacy consent before the OneSignal SDK can be initialized. Please ensure the user has provided consent before calling this method. You can check the latest OneSignal consent status by calling OneSignal.privacyConsent", null, 2, null);
                    return new HttpResponse(0, null, null);
                }
                $continuation.L$0 = url;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeout((long)this.getThreadTimeout((int)timeout), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, url, (String)method, (JSONObject)jsonBody, (int)timeout, (String)cacheKey, null){
                    int label;
                    final /* synthetic */ HttpClient this$0;
                    final /* synthetic */ String $url;
                    final /* synthetic */ String $method;
                    final /* synthetic */ JSONObject $jsonBody;
                    final /* synthetic */ int $timeout;
                    final /* synthetic */ String $cacheKey;
                    {
                        this.this$0 = $receiver;
                        this.$url = $url;
                        this.$method = $method;
                        this.$jsonBody = $jsonBody;
                        this.$timeout = $timeout;
                        this.$cacheKey = $cacheKey;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = HttpClient.access$makeRequestIODispatcher(this.this$0, this.$url, this.$method, this.$jsonBody, this.$timeout, this.$cacheKey, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var10_9) goto lbl22
lbl21:
                // 1 sources

                return var10_9;
lbl22:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    return v0;
                }
                catch (TimeoutCancellationException e) {
                    Logging.error("HttpClient: Request timed out: " + url, e);
                    return new HttpResponse(0, null, e);
                }
                catch (Throwable e) {
                    return new HttpResponse(0, null, e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object makeRequestIODispatcher(String var1_1, String var2_2, JSONObject var3_3, int var4_4, String var5_5, Continuation<? super HttpResponse> var6_6) {
        if (!(var6_6 instanceof makeRequestIODispatcher.1)) ** GOTO lbl-1000
        var10_7 = var6_6;
        if ((var10_7.label & -2147483648) != 0) {
            var10_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpClient.access$makeRequestIODispatcher(this.this$0, null, null, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retVal = new Ref.ObjectRef();
                job = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (String)url, (int)timeout, (JSONObject)jsonBody, (String)method, (String)cacheKey, (Ref.ObjectRef<HttpResponse>)retVal, null){
                    int label;
                    final /* synthetic */ HttpClient this$0;
                    final /* synthetic */ String $url;
                    final /* synthetic */ int $timeout;
                    final /* synthetic */ JSONObject $jsonBody;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $cacheKey;
                    final /* synthetic */ Ref.ObjectRef<HttpResponse> $retVal;
                    {
                        this.this$0 = $receiver;
                        this.$url = $url;
                        this.$timeout = $timeout;
                        this.$jsonBody = $jsonBody;
                        this.$method = $method;
                        this.$cacheKey = $cacheKey;
                        this.$retVal = $retVal;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                HttpURLConnection httpURLConnection;
                                ResultKt.throwOnFailure((Object)object);
                                int httpResponse = -1;
                                HttpURLConnection con = null;
                                if (Build.VERSION.SDK_INT >= 26) {
                                    TrafficStats.setThreadStatsTag((int)10000);
                                }
                                try {
                                    String eTag;
                                    con = HttpClient.access$get_connectionFactory$p(this.this$0).newHttpURLConnection(this.$url);
                                    if (Build.VERSION.SDK_INT < 22 && con instanceof HttpsURLConnection) {
                                        HttpURLConnection conHttps = con;
                                        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)conHttps;
                                        SSLSocketFactory sSLSocketFactory = ((HttpsURLConnection)conHttps).getSSLSocketFactory();
                                        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"conHttps.sslSocketFactory");
                                        httpsURLConnection.setSSLSocketFactory(new TLS12SocketFactory(sSLSocketFactory));
                                    }
                                    con.setUseCaches(false);
                                    con.setConnectTimeout(this.$timeout);
                                    con.setReadTimeout(this.$timeout);
                                    con.setRequestProperty("SDK-Version", "onesignal/android/050103");
                                    if (OneSignalWrapper.getSdkType() != null && OneSignalWrapper.getSdkVersion() != null) {
                                        con.setRequestProperty("SDK-Wrapper", "onesignal/" + OneSignalWrapper.getSdkType() + '/' + OneSignalWrapper.getSdkVersion());
                                    }
                                    con.setRequestProperty("Accept", "application/vnd.onesignal.v1+json");
                                    String subscriptionId = ((ConfigModel)HttpClient.access$get_configModelStore$p(this.this$0).getModel()).getPushSubscriptionId();
                                    if (subscriptionId != null && ((CharSequence)subscriptionId).length() > 0) {
                                        con.setRequestProperty("OneSignal-Subscription-Id", subscriptionId);
                                    }
                                    if (this.$jsonBody != null) {
                                        con.setDoInput(true);
                                    }
                                    if (this.$method != null) {
                                        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                        con.setRequestMethod(this.$method);
                                        con.setDoOutput(true);
                                    }
                                    if (this.$jsonBody != null) {
                                        String strJsonBody = JSONUtils.INSTANCE.toUnescapedEUIDString(this.$jsonBody);
                                        StringBuilder stringBuilder = new StringBuilder().append("HttpClient: ");
                                        String string = this.$method;
                                        if (string == null) {
                                            string = "GET";
                                        }
                                        Logging.debug$default(stringBuilder.append(string).append(' ').append(this.$url).append(" - ").append(strJsonBody).toString(), null, 2, null);
                                        Charset charset = Charset.forName("UTF-8");
                                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                                        byte[] byArray = strJsonBody.getBytes(charset);
                                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                        byte[] sendBytes = byArray;
                                        con.setFixedLengthStreamingMode(sendBytes.length);
                                        OutputStream outputStream = con.getOutputStream();
                                        outputStream.write(sendBytes);
                                    } else {
                                        StringBuilder stringBuilder = new StringBuilder().append("HttpClient: ");
                                        String string = this.$method;
                                        if (string == null) {
                                            string = "GET";
                                        }
                                        Logging.debug$default(stringBuilder.append(string).append(' ').append(this.$url).toString(), null, 2, null);
                                    }
                                    if (this.$cacheKey != null && (eTag = IPreferencesService.DefaultImpls.getString$default(HttpClient.access$get_prefs$p(this.this$0), "OneSignal", "PREFS_OS_ETAG_PREFIX_" + this.$cacheKey, null, 4, null)) != null) {
                                        con.setRequestProperty("if-none-match", eTag);
                                        Logging.debug$default("HttpClient: Adding header if-none-match: " + eTag, null, 2, null);
                                    }
                                    httpResponse = con.getResponseCode();
                                    switch (httpResponse) {
                                        case 304: {
                                            String cachedResponse = IPreferencesService.DefaultImpls.getString$default(HttpClient.access$get_prefs$p(this.this$0), "OneSignal", "PREFS_OS_HTTP_CACHE_PREFIX_" + this.$cacheKey, null, 4, null);
                                            StringBuilder stringBuilder = new StringBuilder().append("HttpClient: ");
                                            String string = this.$method;
                                            if (string == null) {
                                                string = "GET";
                                            }
                                            Logging.debug$default(stringBuilder.append(string).append(' ').append(this.$url).append(" - Using Cached response due to 304: ").append(cachedResponse).toString(), null, 2, null);
                                            this.$retVal.element = new HttpResponse(httpResponse, cachedResponse, null, 4, null);
                                            break;
                                        }
                                        case 200: 
                                        case 201: 
                                        case 202: {
                                            String eTag2;
                                            InputStream inputStream = con.getInputStream();
                                            Scanner scanner = new Scanner(inputStream, "UTF-8");
                                            String json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                                            scanner.close();
                                            StringBuilder stringBuilder = new StringBuilder().append("HttpClient: ");
                                            String string = this.$method;
                                            if (string == null) {
                                                string = "GET";
                                            }
                                            Logging.debug$default(stringBuilder.append(string).append(' ').append(this.$url).append(" - STATUS: ").append(httpResponse).append(" JSON: ").append(json).toString(), null, 2, null);
                                            if (this.$cacheKey != null && (eTag2 = con.getHeaderField("etag")) != null) {
                                                Logging.debug$default("HttpClient: Response has etag of " + eTag2 + " so caching the response.", null, 2, null);
                                                HttpClient.access$get_prefs$p(this.this$0).saveString("OneSignal", "PREFS_OS_ETAG_PREFIX_" + this.$cacheKey, eTag2);
                                                HttpClient.access$get_prefs$p(this.this$0).saveString("OneSignal", "PREFS_OS_HTTP_CACHE_PREFIX_" + this.$cacheKey, json);
                                            }
                                            this.$retVal.element = new HttpResponse(httpResponse, json, null, 4, null);
                                            break;
                                        }
                                        default: {
                                            StringBuilder stringBuilder = new StringBuilder().append("HttpClient: ");
                                            String string = this.$method;
                                            if (string == null) {
                                                string = "GET";
                                            }
                                            Logging.debug$default(stringBuilder.append(string).append(' ').append(this.$url).append(" - FAILED STATUS: ").append(httpResponse).toString(), null, 2, null);
                                            InputStream inputStream = con.getErrorStream();
                                            if (inputStream == null) {
                                                inputStream = con.getInputStream();
                                            }
                                            String jsonResponse = null;
                                            if (inputStream != null) {
                                                Scanner scanner = new Scanner(inputStream, "UTF-8");
                                                jsonResponse = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                                                scanner.close();
                                                Logging.warn$default("HttpClient: " + this.$method + " RECEIVED JSON: " + jsonResponse, null, 2, null);
                                            } else {
                                                Logging.warn$default("HttpClient: " + this.$method + " HTTP Code: " + httpResponse + " No response body!", null, 2, null);
                                            }
                                            this.$retVal.element = new HttpResponse(httpResponse, jsonResponse, null, 4, null);
                                        }
                                    }
                                    httpURLConnection = con;
                                }
                                catch (Throwable t) {
                                    HttpURLConnection httpURLConnection2;
                                    try {
                                        if (t instanceof ConnectException || t instanceof UnknownHostException) {
                                            Logging.info$default("HttpClient: Could not send last request, device is offline. Throwable: " + t.getClass().getName(), null, 2, null);
                                        } else {
                                            Logging.warn("HttpClient: " + this.$method + " Error thrown from network stack. ", t);
                                        }
                                        this.$retVal.element = new HttpResponse(httpResponse, null, t);
                                        httpURLConnection2 = con;
                                    }
                                    catch (Throwable throwable) {
                                        void var3_3;
                                        void v16 = var3_3;
                                        if (v16 == null) throw throwable;
                                        v16.disconnect();
                                        throw throwable;
                                    }
                                    if (httpURLConnection2 == null) return Unit.INSTANCE;
                                    httpURLConnection2.disconnect();
                                    return Unit.INSTANCE;
                                }
                                if (httpURLConnection == null) return Unit.INSTANCE;
                                httpURLConnection.disconnect();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                $continuation.L$0 = retVal;
                $continuation.label = 1;
                v0 = job.join((Continuation)$continuation);
                if (v0 == var11_9) {
                    return var11_9;
                }
                ** GOTO lbl24
            }
            case 1: {
                retVal = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = retVal.element;
                Intrinsics.checkNotNull((Object)v1);
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int getThreadTimeout(int timeout) {
        return timeout + 5000;
    }

    public static final /* synthetic */ Object access$makeRequest(HttpClient $this, String url, String method, JSONObject jsonBody, int timeout, String cacheKey, Continuation $completion) {
        return $this.makeRequest(url, method, jsonBody, timeout, cacheKey, (Continuation<? super HttpResponse>)$completion);
    }

    public static final /* synthetic */ Object access$makeRequestIODispatcher(HttpClient $this, String url, String method, JSONObject jsonBody, int timeout, String cacheKey, Continuation $completion) {
        return $this.makeRequestIODispatcher(url, method, jsonBody, timeout, cacheKey, (Continuation<? super HttpResponse>)$completion);
    }

    public static final /* synthetic */ IHttpConnectionFactory access$get_connectionFactory$p(HttpClient $this) {
        return $this._connectionFactory;
    }

    public static final /* synthetic */ ConfigModelStore access$get_configModelStore$p(HttpClient $this) {
        return $this._configModelStore;
    }

    public static final /* synthetic */ IPreferencesService access$get_prefs$p(HttpClient $this) {
        return $this._prefs;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/onesignal/core/internal/http/impl/HttpClient$Companion;", "", "()V", "OS_ACCEPT_HEADER", "", "OS_API_VERSION", "THREAD_ID", "", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

