/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/onesignal/common/OneSignalUtils;", "", "()V", "sdkVersion", "", "isValidEmail", "", "email", "isValidPhoneNumber", "number", "com.onesignal.core"})
public final class OneSignalUtils {
    @NotNull
    public static final OneSignalUtils INSTANCE = new OneSignalUtils();
    @NotNull
    public static final String sdkVersion = "050002";

    private OneSignalUtils() {
    }

    public final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        if (((CharSequence)email).length() == 0) {
            return false;
        }
        String emRegex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern pattern = Pattern.compile(emRegex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(emRegex)");
        Pattern pattern2 = pattern;
        return pattern2.matcher(email).matches();
    }

    public final boolean isValidPhoneNumber(@NotNull String number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        if (((CharSequence)number).length() == 0) {
            return false;
        }
        String emRegex = "^\\+?[1-9]\\d{1,14}$";
        Pattern pattern = Pattern.compile(emRegex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(emRegex)");
        Pattern pattern2 = pattern;
        return pattern2.matcher(number).matches();
    }
}

