/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.session.internal.influence.impl;

import com.onesignal.common.JSONUtils;
import com.onesignal.core.internal.application.AppEntryAction;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.session.internal.influence.IInfluenceManager;
import com.onesignal.session.internal.influence.Influence;
import com.onesignal.session.internal.influence.InfluenceType;
import com.onesignal.session.internal.influence.impl.ChannelTracker;
import com.onesignal.session.internal.influence.impl.IChannelTracker;
import com.onesignal.session.internal.influence.impl.InAppMessageTracker;
import com.onesignal.session.internal.influence.impl.InfluenceConstants;
import com.onesignal.session.internal.influence.impl.InfluenceDataRepository;
import com.onesignal.session.internal.influence.impl.NotificationTracker;
import com.onesignal.session.internal.session.ISessionLifecycleHandler;
import com.onesignal.session.internal.session.ISessionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001fH\u0016J\b\u0010,\u001a\u00020\"H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u001fH\u0016J\u0010\u0010.\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001fH\u0016J\b\u0010/\u001a\u00020\"H\u0016J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\"H\u0016J\u0010\u00104\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J,\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u001f2\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J,\u0010=\u001a\u0002062\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u001f2\b\u0010;\u001a\u0004\u0018\u00010<H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/onesignal/session/internal/influence/impl/InfluenceManager;", "Lcom/onesignal/session/internal/influence/IInfluenceManager;", "Lcom/onesignal/session/internal/session/ISessionLifecycleHandler;", "_sessionService", "Lcom/onesignal/session/internal/session/ISessionService;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "preferences", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "timeProvider", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/session/internal/session/ISessionService;Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/core/internal/preferences/IPreferencesService;Lcom/onesignal/core/internal/time/ITime;)V", "channels", "", "Lcom/onesignal/session/internal/influence/impl/IChannelTracker;", "getChannels", "()Ljava/util/List;", "dataRepository", "Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;", "iAMChannelTracker", "getIAMChannelTracker", "()Lcom/onesignal/session/internal/influence/impl/IChannelTracker;", "influences", "Lcom/onesignal/session/internal/influence/Influence;", "getInfluences", "notificationChannelTracker", "getNotificationChannelTracker", "trackers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/onesignal/session/internal/influence/impl/ChannelTracker;", "attemptSessionUpgrade", "", "entryAction", "Lcom/onesignal/core/internal/application/AppEntryAction;", "directId", "getChannelByEntryAction", "getChannelsToResetByEntryAction", "onDirectInfluenceFromIAM", "messageId", "onDirectInfluenceFromNotification", "notificationId", "onInAppMessageDismissed", "onInAppMessageDisplayed", "onNotificationReceived", "onSessionActive", "onSessionEnded", "duration", "", "onSessionStarted", "restartSessionTrackersIfNeeded", "setSessionTracker", "", "channelTracker", "influenceType", "Lcom/onesignal/session/internal/influence/InfluenceType;", "directNotificationId", "indirectNotificationIds", "Lorg/json/JSONArray;", "willChangeSessionTracker", "core_release"})
public final class InfluenceManager
implements IInfluenceManager,
ISessionLifecycleHandler {
    @NotNull
    private final ISessionService _sessionService;
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final ConcurrentHashMap<String, ChannelTracker> trackers;
    @NotNull
    private final InfluenceDataRepository dataRepository;

    public InfluenceManager(@NotNull ISessionService _sessionService, @NotNull IApplicationService _applicationService, @NotNull ConfigModelStore _configModelStore, @NotNull IPreferencesService preferences, @NotNull ITime timeProvider) {
        Intrinsics.checkNotNullParameter((Object)_sessionService, (String)"_sessionService");
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this._sessionService = _sessionService;
        this._applicationService = _applicationService;
        this._configModelStore = _configModelStore;
        this.trackers = new ConcurrentHashMap();
        this.dataRepository = new InfluenceDataRepository(preferences, this._configModelStore);
        ((Map)this.trackers).put(InfluenceConstants.INSTANCE.getIAM_TAG(), new InAppMessageTracker(this.dataRepository, timeProvider));
        ((Map)this.trackers).put(InfluenceConstants.INSTANCE.getNOTIFICATION_TAG(), new NotificationTracker(this.dataRepository, timeProvider));
        this._sessionService.subscribe(this);
        Collection<ChannelTracker> collection = this.trackers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChannelTracker it = (ChannelTracker)element$iv;
            boolean bl = false;
            it.initInfluencedTypeFromCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Influence> getInfluences() {
        void $this$mapTo$iv$iv;
        Collection<ChannelTracker> collection = this.trackers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelTracker channelTracker = (ChannelTracker)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getCurrentSessionInfluence());
        }
        return (List)destination$iv$iv;
    }

    private final IChannelTracker getIAMChannelTracker() {
        ChannelTracker channelTracker = this.trackers.get(InfluenceConstants.INSTANCE.getIAM_TAG());
        Intrinsics.checkNotNull((Object)channelTracker);
        return channelTracker;
    }

    private final IChannelTracker getNotificationChannelTracker() {
        ChannelTracker channelTracker = this.trackers.get(InfluenceConstants.INSTANCE.getNOTIFICATION_TAG());
        Intrinsics.checkNotNull((Object)channelTracker);
        return channelTracker;
    }

    private final List<IChannelTracker> getChannels() {
        List channels = new ArrayList();
        IChannelTracker it = this.getNotificationChannelTracker();
        boolean bl = false;
        channels.add(it);
        it = this.getIAMChannelTracker();
        boolean bl2 = false;
        channels.add(it);
        return channels;
    }

    @Override
    public void onSessionStarted() {
        this.restartSessionTrackersIfNeeded(this._applicationService.getEntryState());
    }

    @Override
    public void onSessionActive() {
        InfluenceManager.attemptSessionUpgrade$default(this, this._applicationService.getEntryState(), null, 2, null);
    }

    @Override
    public void onSessionEnded(long duration) {
    }

    private final IChannelTracker getChannelByEntryAction(AppEntryAction entryAction) {
        return entryAction.isNotificationClick() ? this.getNotificationChannelTracker() : null;
    }

    private final List<IChannelTracker> getChannelsToResetByEntryAction(AppEntryAction entryAction) {
        IChannelTracker it;
        IChannelTracker notificationChannel;
        List channels = new ArrayList();
        if (entryAction.isAppClose()) {
            return channels;
        }
        IChannelTracker iChannelTracker = notificationChannel = entryAction.isAppOpen() ? this.getNotificationChannelTracker() : null;
        if (iChannelTracker != null) {
            it = iChannelTracker;
            boolean bl = false;
            channels.add(it);
        }
        it = this.getIAMChannelTracker();
        boolean bl = false;
        channels.add(it);
        return channels;
    }

    @Override
    public void onNotificationReceived(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Logging.debug$default("InfluenceManager.onNotificationReceived(notificationId: " + notificationId + ')', null, 2, null);
        if (((CharSequence)notificationId).length() == 0) {
            return;
        }
        this.getNotificationChannelTracker().saveLastId(notificationId);
    }

    @Override
    public void onDirectInfluenceFromNotification(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Logging.debug$default("InfluenceManager.onDirectInfluenceFromNotification(notificationId: " + notificationId + ')', null, 2, null);
        if (((CharSequence)notificationId).length() == 0) {
            return;
        }
        this.attemptSessionUpgrade(AppEntryAction.NOTIFICATION_CLICK, notificationId);
    }

    @Override
    public void onInAppMessageDisplayed(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Logging.debug$default("InfluenceManager.onInAppMessageReceived(messageId: " + messageId + ')', null, 2, null);
        IChannelTracker inAppMessageTracker = this.getIAMChannelTracker();
        inAppMessageTracker.saveLastId(messageId);
        inAppMessageTracker.resetAndInitInfluence();
    }

    @Override
    public void onDirectInfluenceFromIAM(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Logging.debug$default("InfluenceManager.onDirectInfluenceFromIAM(messageId: " + messageId + ')', null, 2, null);
        this.setSessionTracker(this.getIAMChannelTracker(), InfluenceType.DIRECT, messageId, null);
    }

    @Override
    public void onInAppMessageDismissed() {
        Logging.debug$default("InfluenceManager.onInAppMessageDismissed()", null, 2, null);
        IChannelTracker inAppMessageTracker = this.getIAMChannelTracker();
        inAppMessageTracker.resetAndInitInfluence();
    }

    private final void restartSessionTrackersIfNeeded(AppEntryAction entryAction) {
        List<IChannelTracker> channelTrackers = this.getChannelsToResetByEntryAction(entryAction);
        List updatedInfluences = new ArrayList();
        Logging.debug$default("InfluenceManager.restartSessionIfNeeded(entryAction: " + (Object)((Object)entryAction) + "):\n channelTrackers: " + channelTrackers, null, 2, null);
        for (IChannelTracker channelTracker : channelTrackers) {
            JSONArray lastIds = channelTracker.getLastReceivedIds();
            Logging.debug$default("InfluenceManager.restartSessionIfNeeded: lastIds: " + lastIds, null, 2, null);
            Influence influence = channelTracker.getCurrentSessionInfluence();
            boolean updated = lastIds.length() > 0 ? this.setSessionTracker(channelTracker, InfluenceType.INDIRECT, null, lastIds) : this.setSessionTracker(channelTracker, InfluenceType.UNATTRIBUTED, null, null);
            if (!updated) continue;
            updatedInfluences.add(influence);
        }
    }

    private final boolean setSessionTracker(IChannelTracker channelTracker, InfluenceType influenceType, String directNotificationId, JSONArray indirectNotificationIds) {
        if (!this.willChangeSessionTracker(channelTracker, influenceType, directNotificationId, indirectNotificationIds)) {
            return false;
        }
        Logging.debug$default(StringsKt.trimIndent((String)("\n            ChannelTracker changed: " + channelTracker.getIdTag() + "\n            from:\n            influenceType: " + (Object)((Object)channelTracker.getInfluenceType()) + ", directNotificationId: " + channelTracker.getDirectId() + ", indirectNotificationIds: " + channelTracker.getIndirectIds() + "\n            to:\n            influenceType: " + (Object)((Object)influenceType) + ", directNotificationId: " + directNotificationId + ", indirectNotificationIds: " + indirectNotificationIds + "\n            ")), null, 2, null);
        channelTracker.setInfluenceType(influenceType);
        channelTracker.setDirectId(directNotificationId);
        channelTracker.setIndirectIds(indirectNotificationIds);
        channelTracker.cacheState();
        Logging.debug$default("InfluenceManager.setSessionTracker: Trackers changed to: " + this.getChannels(), null, 2, null);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean willChangeSessionTracker(IChannelTracker channelTracker, InfluenceType influenceType, String directNotificationId, JSONArray indirectNotificationIds) {
        InfluenceType channelInfluenceType;
        if (influenceType != channelTracker.getInfluenceType()) {
            return true;
        }
        InfluenceType influenceType2 = channelInfluenceType = channelTracker.getInfluenceType();
        boolean bl = influenceType2 != null ? influenceType2.isDirect() : false;
        if (bl && channelTracker.getDirectId() != null && !Intrinsics.areEqual((Object)channelTracker.getDirectId(), (Object)directNotificationId)) {
            return true;
        }
        InfluenceType influenceType3 = channelInfluenceType;
        if (influenceType3 == null) return false;
        if (!influenceType3.isIndirect()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (channelTracker.getIndirectIds() == null) return false;
        JSONArray jSONArray = channelTracker.getIndirectIds();
        Intrinsics.checkNotNull((Object)jSONArray);
        if (jSONArray.length() <= 0) return false;
        if (JSONUtils.INSTANCE.compareJSONArrays(channelTracker.getIndirectIds(), indirectNotificationIds)) return false;
        return true;
    }

    private final void attemptSessionUpgrade(AppEntryAction entryAction, String directId) {
        Logging.debug$default("InfluenceManager.attemptSessionUpgrade(entryAction: " + (Object)((Object)entryAction) + ", directId: " + directId + ')', null, 2, null);
        IChannelTracker channelTrackerByAction = this.getChannelByEntryAction(entryAction);
        List<IChannelTracker> channelTrackersToReset = this.getChannelsToResetByEntryAction(entryAction);
        List influencesToEnd = new ArrayList();
        Influence lastInfluence = null;
        boolean updated = false;
        if (channelTrackerByAction != null) {
            lastInfluence = channelTrackerByAction.getCurrentSessionInfluence();
            String string2 = directId;
            if (string2 == null) {
                string2 = channelTrackerByAction.getDirectId();
            }
            updated = this.setSessionTracker(channelTrackerByAction, InfluenceType.DIRECT, string2, null);
        }
        if (updated) {
            Logging.debug$default("InfluenceManager.attemptSessionUpgrade: channel updated, search for ending direct influences on channels: " + channelTrackersToReset, null, 2, null);
            Influence influence = lastInfluence;
            Intrinsics.checkNotNull((Object)influence);
            influencesToEnd.add(influence);
            for (IChannelTracker tracker : channelTrackersToReset) {
                InfluenceType influenceType = tracker.getInfluenceType();
                boolean bl = influenceType != null ? influenceType.isDirect() : false;
                if (!bl) continue;
                influencesToEnd.add(tracker.getCurrentSessionInfluence());
                tracker.resetAndInitInfluence();
            }
        }
        Logging.debug$default("InfluenceManager.attemptSessionUpgrade: try UNATTRIBUTED to INDIRECT upgrade", null, 2, null);
        for (IChannelTracker channelTracker : channelTrackersToReset) {
            JSONArray lastIds;
            InfluenceType influenceType = channelTracker.getInfluenceType();
            boolean bl = influenceType != null ? influenceType.isUnattributed() : false;
            if (!bl || (lastIds = channelTracker.getLastReceivedIds()).length() <= 0 || entryAction.isAppClose()) continue;
            Influence influence = channelTracker.getCurrentSessionInfluence();
            updated = this.setSessionTracker(channelTracker, InfluenceType.INDIRECT, null, lastIds);
            if (!updated) continue;
            influencesToEnd.add(influence);
        }
        Logging.debug$default("InfluenceManager.attemptSessionUpgrade: Trackers after update attempt: " + this.getChannels(), null, 2, null);
    }

    static /* synthetic */ void attemptSessionUpgrade$default(InfluenceManager influenceManager, AppEntryAction appEntryAction, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        influenceManager.attemptSessionUpgrade(appEntryAction, string2);
    }
}

