/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.database.impl;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.SystemClock;
import com.onesignal.core.internal.database.ICursor;
import com.onesignal.core.internal.database.IDatabase;
import com.onesignal.core.internal.database.impl.DatabaseCursor;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.session.internal.outcomes.impl.OutcomeTableProvider;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0010\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ/\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J$\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J \u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J \u0010 \u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J{\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00102\b\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010%\u001a\u0004\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\r2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u000b0(H\u0016\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\rH\u0002J7\u0010-\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00101\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00104\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00105\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/onesignal/core/internal/database/impl/OSDatabase;", "Landroid/database/sqlite/SQLiteOpenHelper;", "Lcom/onesignal/core/internal/database/IDatabase;", "_outcomeTableProvider", "Lcom/onesignal/session/internal/outcomes/impl/OutcomeTableProvider;", "context", "Landroid/content/Context;", "version", "", "(Lcom/onesignal/session/internal/outcomes/impl/OutcomeTableProvider;Landroid/content/Context;I)V", "delete", "", "table", "", "whereClause", "whereArgs", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getSQLiteDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "getSQLiteDatabaseWithRetries", "insert", "nullColumnHack", "values", "Landroid/content/ContentValues;", "insertOrThrow", "internalOnUpgrade", "db", "oldVersion", "newVersion", "onCreate", "onDowngrade", "onUpgrade", "query", "columns", "groupBy", "having", "orderBy", "limit", "action", "Lkotlin/Function1;", "Lcom/onesignal/core/internal/database/ICursor;", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "safeExecSQL", "sql", "update", "(Ljava/lang/String;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I", "upgradeFromV5ToV6", "upgradeToV2", "upgradeToV3", "upgradeToV4", "upgradeToV5", "upgradeToV7", "upgradeToV8", "Companion", "core_release"})
public class OSDatabase
extends SQLiteOpenHelper
implements IDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutcomeTableProvider _outcomeTableProvider;
    private static final int dbVersion = 8;
    @NotNull
    private static final Object LOCK = new Object();
    @NotNull
    private static final String DATABASE_NAME = "OneSignal.db";
    @NotNull
    private static final String INTEGER_PRIMARY_KEY_TYPE = " INTEGER PRIMARY KEY";
    @NotNull
    private static final String TEXT_TYPE = " TEXT";
    @NotNull
    private static final String INT_TYPE = " INTEGER";
    @NotNull
    private static final String FLOAT_TYPE = " FLOAT";
    @NotNull
    private static final String TIMESTAMP_TYPE = " TIMESTAMP";
    @NotNull
    private static final String COMMA_SEP = ",";
    private static final int DB_OPEN_RETRY_MAX = 5;
    private static final int DB_OPEN_RETRY_BACKOFF = 400;
    @NotNull
    private static final String SQL_CREATE_ENTRIES = "CREATE TABLE notification (_id INTEGER PRIMARY KEY,notification_id TEXT,android_notification_id INTEGER,group_id TEXT,collapse_id TEXT,is_summary INTEGER DEFAULT 0,opened INTEGER DEFAULT 0,dismissed INTEGER DEFAULT 0,title TEXT,message TEXT,full_data TEXT,created_time TIMESTAMP DEFAULT (strftime('%s', 'now')),expire_time TIMESTAMP);";
    @NotNull
    private static final String SQL_CREATE_IN_APP_MESSAGE_ENTRIES = "CREATE TABLE in_app_message (_id INTEGER PRIMARY KEY,display_quantity INTEGER,last_display INTEGER,message_id TEXT,displayed_in_session INTEGER,click_ids TEXT);";
    @NotNull
    private static final String[] SQL_INDEX_ENTRIES;
    public static final int DEFAULT_TTL_IF_NOT_IN_PAYLOAD = 259200;

    public OSDatabase(@NotNull OutcomeTableProvider _outcomeTableProvider, @Nullable Context context, int version) {
        Intrinsics.checkNotNullParameter((Object)_outcomeTableProvider, (String)"_outcomeTableProvider");
        super(context, DATABASE_NAME, null, version);
        this._outcomeTableProvider = _outcomeTableProvider;
    }

    public /* synthetic */ OSDatabase(OutcomeTableProvider outcomeTableProvider, Context context, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 8;
        }
        this(outcomeTableProvider, context, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteDatabase getSQLiteDatabase() {
        Object object = LOCK;
        synchronized (object) {
            SQLiteDatabase sQLiteDatabase;
            boolean bl = false;
            try {
                SQLiteDatabase sQLiteDatabase2 = this.getWritableDatabase();
                Intrinsics.checkNotNullExpressionValue((Object)sQLiteDatabase2, (String)"{\n                writableDatabase\n            }");
                sQLiteDatabase = sQLiteDatabase2;
            }
            catch (SQLiteCantOpenDatabaseException e) {
                throw e;
            }
            catch (SQLiteDatabaseLockedException e) {
                throw e;
            }
            SQLiteDatabase sQLiteDatabase3 = sQLiteDatabase;
            return sQLiteDatabase3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final SQLiteDatabase getSQLiteDatabaseWithRetries() {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            int count = 0;
            while (true) {
                try {
                    return this.getSQLiteDatabase();
                }
                catch (SQLiteCantOpenDatabaseException e) {
                    if (++count >= 5) {
                        throw e;
                    }
                    SystemClock.sleep((long)(count * 400));
                    continue;
                }
                catch (SQLiteDatabaseLockedException e) {
                    if (++count >= 5) {
                        throw e;
                    }
                    SystemClock.sleep((long)(count * 400));
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(@NotNull String table, @Nullable String[] columns, @Nullable String whereClause, @Nullable String[] whereArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit, @NotNull Function1<? super ICursor, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Cursor cursor = null;
        Object object = LOCK;
        synchronized (object) {
            boolean $i$a$-synchronized-OSDatabase$query$22 = false;
            if (limit == null) {
                Cursor cursor2 = this.getSQLiteDatabaseWithRetries().query(table, columns, whereClause, whereArgs, groupBy, having, orderBy);
                Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"getSQLiteDatabaseWithRet\u2026rderBy,\n                )");
                cursor = cursor2;
            } else {
                Cursor cursor3 = this.getSQLiteDatabaseWithRetries().query(table, columns, whereClause, whereArgs, groupBy, having, orderBy, limit);
                Intrinsics.checkNotNullExpressionValue((Object)cursor3, (String)"getSQLiteDatabaseWithRet\u2026 limit,\n                )");
                cursor = cursor3;
            }
            Unit $i$a$-synchronized-OSDatabase$query$22 = Unit.INSTANCE;
        }
        Closeable closeable = (Closeable)cursor;
        object = null;
        try {
            Cursor it = (Cursor)closeable;
            boolean bl = false;
            DatabaseCursor dbCursor = new DatabaseCursor(it);
            action.invoke((Object)dbCursor);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(@NotNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.insert(table, nullColumnHack, values);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                Logging.error("Error inserting on table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            catch (IllegalStateException e) {
                Logging.error("Error under inserting transaction under table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            finally {
                try {
                    writableDb.endTransaction();
                }
                catch (IllegalStateException e) {
                    Logging.error("Error closing transaction! ", e);
                }
                catch (SQLiteException e) {
                    Logging.error("Error closing transaction! ", e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertOrThrow(@NotNull String table, @Nullable String nullColumnHack, @Nullable ContentValues values) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.insertOrThrow(table, nullColumnHack, values);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                Logging.error("Error inserting or throw on table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            catch (IllegalStateException e) {
                Logging.error("Error under inserting or throw transaction under table: " + table + " with nullColumnHack: " + nullColumnHack + " and values: " + values, e);
            }
            finally {
                try {
                    writableDb.endTransaction();
                }
                catch (IllegalStateException e) {
                    Logging.error("Error closing transaction! ", e);
                }
                catch (SQLiteException e) {
                    Logging.error("Error closing transaction! ", e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(@NotNull String table, @NotNull ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int result = 0;
        String string = values.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"values.toString()");
        if (((CharSequence)string).length() == 0) {
            return result;
        }
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                result = writableDb.update(table, values, whereClause, whereArgs);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                Logging.error("Error updating on table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            catch (IllegalStateException e) {
                Logging.error("Error under update transaction under table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            finally {
                try {
                    writableDb.endTransaction();
                }
                catch (IllegalStateException e) {
                    Logging.error("Error closing transaction! ", e);
                }
                catch (SQLiteException e) {
                    Logging.error("Error closing transaction! ", e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            SQLiteDatabase writableDb = this.getSQLiteDatabaseWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.delete(table, whereClause, whereArgs);
                writableDb.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                Logging.error("Error deleting on table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            catch (IllegalStateException e) {
                Logging.error("Error under delete transaction under table: " + table + " with whereClause: " + whereClause + " and whereArgs: " + whereArgs, e);
            }
            finally {
                try {
                    writableDb.endTransaction();
                }
                catch (IllegalStateException e) {
                    Logging.error("Error closing transaction! ", e);
                }
                catch (SQLiteException e) {
                    Logging.error("Error closing transaction! ", e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        db.execSQL(SQL_CREATE_ENTRIES);
        db.execSQL("CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_influence_type TEXT,iam_influence_type TEXT,notification_ids TEXT,iam_ids TEXT,name TEXT,timestamp TIMESTAMP,weight FLOAT);");
        db.execSQL("CREATE TABLE cached_unique_outcome (_id INTEGER PRIMARY KEY,channel_influence_id TEXT,channel_type TEXT,name TEXT);");
        db.execSQL(SQL_CREATE_IN_APP_MESSAGE_ENTRIES);
        for (String ind : SQL_INDEX_ENTRIES) {
            db.execSQL(ind);
        }
    }

    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Logging.debug$default("OneSignal Database onUpgrade from: " + oldVersion + " to: " + newVersion, null, 2, null);
        try {
            this.internalOnUpgrade(db, oldVersion, newVersion);
        }
        catch (SQLiteException e) {
            Logging.error("Error in upgrade, migration may have already run! Skipping!", e);
        }
    }

    private final synchronized void internalOnUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 2 && newVersion >= 2) {
            this.upgradeToV2(db);
        }
        if (oldVersion < 3 && newVersion >= 3) {
            this.upgradeToV3(db);
        }
        if (oldVersion < 4 && newVersion >= 4) {
            this.upgradeToV4(db);
        }
        if (oldVersion < 5 && newVersion >= 5) {
            this.upgradeToV5(db);
        }
        if (oldVersion == 5 && newVersion >= 6) {
            this.upgradeFromV5ToV6(db);
        }
        if (oldVersion < 7 && newVersion >= 7) {
            this.upgradeToV7(db);
        }
        if (oldVersion < 8 && newVersion >= 8) {
            this.upgradeToV8(db);
        }
    }

    private final void upgradeToV2(SQLiteDatabase db) {
        this.safeExecSQL(db, "ALTER TABLE notification ADD COLUMN collapse_id TEXT;");
        this.safeExecSQL(db, "CREATE INDEX notification_group_id_idx ON notification(group_id); ");
    }

    private final void upgradeToV3(SQLiteDatabase db) {
        this.safeExecSQL(db, "ALTER TABLE notification ADD COLUMN expire_time TIMESTAMP;");
        this.safeExecSQL(db, "UPDATE notification SET expire_time = created_time + 259200;");
        this.safeExecSQL(db, "CREATE INDEX notification_expire_time_idx ON notification(expire_time); ");
    }

    private final void upgradeToV4(SQLiteDatabase db) {
        this.safeExecSQL(db, "CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_ids TEXT,name TEXT,session TEXT,params TEXT,timestamp TIMESTAMP);");
    }

    private final void upgradeToV5(SQLiteDatabase db) {
        this.safeExecSQL(db, "CREATE TABLE cached_unique_outcome_notification (_id INTEGER PRIMARY KEY,notification_id TEXT,name TEXT);");
        this.upgradeFromV5ToV6(db);
    }

    private final void upgradeFromV5ToV6(SQLiteDatabase db) {
        this._outcomeTableProvider.upgradeOutcomeTableRevision1To2(db);
    }

    private final void upgradeToV7(SQLiteDatabase db) {
        this.safeExecSQL(db, SQL_CREATE_IN_APP_MESSAGE_ENTRIES);
    }

    private final void safeExecSQL(SQLiteDatabase db, String sql) {
        try {
            db.execSQL(sql);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    private final synchronized void upgradeToV8(SQLiteDatabase db) {
        this._outcomeTableProvider.upgradeOutcomeTableRevision2To3(db);
        this._outcomeTableProvider.upgradeCacheOutcomeTableRevision1To2(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDowngrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Logging.warn$default("SDK version rolled back! Clearing OneSignal.db as it could be in an unexpected state.", null, 2, null);
        Closeable closeable = (Closeable)db.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", null);
        Throwable throwable = null;
        try {
            Cursor it = (Cursor)closeable;
            boolean bl = false;
            List tables = new ArrayList(it.getCount());
            while (it.moveToNext()) {
                String string = it.getString(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getString(0)");
                tables.add(string);
            }
            for (String table : tables) {
                if (StringsKt.startsWith$default((String)table, (String)"sqlite_", (boolean)false, (int)2, null)) continue;
                db.execSQL("DROP TABLE IF EXISTS " + table);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.onCreate(db);
    }

    static {
        String[] stringArray = new String[]{"CREATE INDEX notification_notification_id_idx ON notification(notification_id); ", "CREATE INDEX notification_android_notification_id_idx ON notification(android_notification_id); ", "CREATE INDEX notification_group_id_idx ON notification(group_id); ", "CREATE INDEX notification_collapse_id_idx ON notification(collapse_id); ", "CREATE INDEX notification_created_time_idx ON notification(created_time); ", "CREATE INDEX notification_expire_time_idx ON notification(expire_time); "};
        SQL_INDEX_ENTRIES = stringArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/onesignal/core/internal/database/impl/OSDatabase$Companion;", "", "()V", "COMMA_SEP", "", "DATABASE_NAME", "DB_OPEN_RETRY_BACKOFF", "", "DB_OPEN_RETRY_MAX", "DEFAULT_TTL_IF_NOT_IN_PAYLOAD", "FLOAT_TYPE", "INTEGER_PRIMARY_KEY_TYPE", "INT_TYPE", "LOCK", "SQL_CREATE_ENTRIES", "SQL_CREATE_IN_APP_MESSAGE_ENTRIES", "SQL_INDEX_ENTRIES", "", "[Ljava/lang/String;", "TEXT_TYPE", "TIMESTAMP_TYPE", "dbVersion", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

