/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal.operations.impl.executors;

import com.onesignal.common.NetworkUtils;
import com.onesignal.common.exceptions.BackendException;
import com.onesignal.common.modeling.Model;
import com.onesignal.core.internal.operations.ExecutionResponse;
import com.onesignal.core.internal.operations.ExecutionResult;
import com.onesignal.core.internal.operations.IOperationExecutor;
import com.onesignal.core.internal.operations.Operation;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.user.internal.backend.CreateUserResponse;
import com.onesignal.user.internal.backend.IUserBackendService;
import com.onesignal.user.internal.backend.SubscriptionObject;
import com.onesignal.user.internal.backend.SubscriptionObjectType;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.operations.RefreshUserOperation;
import com.onesignal.user.internal.operations.impl.executors.RefreshUserOperationExecutor;
import com.onesignal.user.internal.properties.PropertiesModel;
import com.onesignal.user.internal.properties.PropertiesModelStore;
import com.onesignal.user.internal.subscriptions.SubscriptionModel;
import com.onesignal.user.internal.subscriptions.SubscriptionModelStore;
import com.onesignal.user.internal.subscriptions.SubscriptionStatus;
import com.onesignal.user.internal.subscriptions.SubscriptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/onesignal/user/internal/operations/impl/executors/RefreshUserOperationExecutor;", "Lcom/onesignal/core/internal/operations/IOperationExecutor;", "_userBackend", "Lcom/onesignal/user/internal/backend/IUserBackendService;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "_propertiesModelStore", "Lcom/onesignal/user/internal/properties/PropertiesModelStore;", "_subscriptionsModelStore", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;", "(Lcom/onesignal/user/internal/backend/IUserBackendService;Lcom/onesignal/user/internal/identity/IdentityModelStore;Lcom/onesignal/user/internal/properties/PropertiesModelStore;Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;)V", "operations", "", "", "getOperations", "()Ljava/util/List;", "execute", "Lcom/onesignal/core/internal/operations/ExecutionResponse;", "Lcom/onesignal/core/internal/operations/Operation;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUser", "op", "Lcom/onesignal/user/internal/operations/RefreshUserOperation;", "(Lcom/onesignal/user/internal/operations/RefreshUserOperation;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "core_release"})
public final class RefreshUserOperationExecutor
implements IOperationExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IUserBackendService _userBackend;
    @NotNull
    private final IdentityModelStore _identityModelStore;
    @NotNull
    private final PropertiesModelStore _propertiesModelStore;
    @NotNull
    private final SubscriptionModelStore _subscriptionsModelStore;
    @NotNull
    public static final String REFRESH_USER = "refresh-user";

    public RefreshUserOperationExecutor(@NotNull IUserBackendService _userBackend, @NotNull IdentityModelStore _identityModelStore, @NotNull PropertiesModelStore _propertiesModelStore, @NotNull SubscriptionModelStore _subscriptionsModelStore) {
        Intrinsics.checkNotNullParameter((Object)_userBackend, (String)"_userBackend");
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        Intrinsics.checkNotNullParameter((Object)_propertiesModelStore, (String)"_propertiesModelStore");
        Intrinsics.checkNotNullParameter((Object)_subscriptionsModelStore, (String)"_subscriptionsModelStore");
        this._userBackend = _userBackend;
        this._identityModelStore = _identityModelStore;
        this._propertiesModelStore = _propertiesModelStore;
        this._subscriptionsModelStore = _subscriptionsModelStore;
    }

    @Override
    @NotNull
    public List<String> getOperations() {
        return CollectionsKt.listOf((Object)REFRESH_USER);
    }

    @Override
    @Nullable
    public Object execute(@NotNull List<? extends Operation> operations, @NotNull Continuation<? super ExecutionResponse> $completion) {
        Logging.log(LogLevel.DEBUG, "RefreshUserOperationExecutor(operation: " + operations + ')');
        Operation startingOp = (Operation)CollectionsKt.first(operations);
        if (startingOp instanceof RefreshUserOperation) {
            return this.getUser((RefreshUserOperation)startingOp, $completion);
        }
        throw new Exception("Unrecognized operation: " + startingOp);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Object getUser(RefreshUserOperation var1_1, Continuation<? super ExecutionResponse> var2_2) {
        if (!(var2_2 instanceof getUser.1)) ** GOTO lbl-1000
        var12_3 = var2_2;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RefreshUserOperationExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RefreshUserOperationExecutor.access$getUser(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = op;
                $continuation.label = 1;
                v0 = this._userBackend.getUser(op.getAppId(), "onesignal_id", op.getOnesignalId(), (Continuation<? super CreateUserResponse>)$continuation);
                ** if (v0 != var13_5) goto lbl20
lbl19:
                // 1 sources

                return var13_5;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                op = (RefreshUserOperation)$continuation.L$1;
                this = (RefreshUserOperationExecutor)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    response = (CreateUserResponse)v0;
                    if (!Intrinsics.areEqual((Object)op.getOnesignalId(), (Object)((IdentityModel)this._identityModelStore.getModel()).getOnesignalId())) {
                        return new ExecutionResponse(ExecutionResult.SUCCESS, null, 2, null);
                    }
                    identityModel = new IdentityModel();
                    for (Object aliasKVP : response.getIdentities().entrySet()) {
                        ((Map)identityModel).put(aliasKVP.getKey(), aliasKVP.getValue());
                    }
                    propertiesModel = new PropertiesModel();
                    propertiesModel.setOnesignalId(op.getOnesignalId());
                    if (response.getProperties().getCountry() != null) {
                        propertiesModel.setCountry(response.getProperties().getCountry());
                    }
                    if (response.getProperties().getLanguage() != null) {
                        propertiesModel.setLanguage(response.getProperties().getLanguage());
                    }
                    if (response.getProperties().getTags() != null) {
                        for (Map.Entry tagKVP : response.getProperties().getTags().entrySet()) {
                            if (tagKVP.getValue() == null) continue;
                            v1 = propertiesModel.getTags();
                            v2 = var7_11.getKey();
                            v3 = var7_11.getValue();
                            Intrinsics.checkNotNull(v3);
                            v1.put(v2, v3);
                        }
                    }
                    if (response.getProperties().getTimezoneId() != null) {
                        propertiesModel.setTimezone(response.getProperties().getTimezoneId());
                    }
                    subscriptionModels = new ArrayList<E>();
                    for (SubscriptionObject subscription : response.getSubscriptions()) {
                        subscriptionModel = new SubscriptionModel();
                        subscriptionModel.setId(subscription.getId());
                        v4 = subscription.getToken();
                        if (v4 == null) {
                            v4 = "";
                        }
                        subscriptionModel.setAddress(v4);
                        v5 = subscription.getNotificationTypes();
                        v6 = SubscriptionStatus.Companion.fromInt(v5 != null ? v5.intValue() : SubscriptionStatus.SUBSCRIBED.getValue());
                        if (v6 == null) {
                            v6 = SubscriptionStatus.SUBSCRIBED;
                        }
                        subscriptionModel.setStatus(v6);
                        var10_14 = subscription.getType();
                        switch (WhenMappings.$EnumSwitchMapping$0[var10_14.ordinal()]) {
                            case 1: {
                                v7 = SubscriptionType.EMAIL;
                                break;
                            }
                            case 2: {
                                v7 = SubscriptionType.SMS;
                                break;
                            }
                            default: {
                                v7 = SubscriptionType.PUSH;
                            }
                        }
                        subscriptionModel.setType(v7);
                        subscriptionModel.setOptedIn(subscriptionModel.getStatus() != SubscriptionStatus.UNSUBSCRIBE);
                        subscriptionModels.add(subscriptionModel);
                    }
                    this._identityModelStore.replace((Model)identityModel, "HYDRATE");
                    this._propertiesModelStore.replace((Model)propertiesModel, "HYDRATE");
                    this._subscriptionsModelStore.replaceAll(subscriptionModels, "HYDRATE");
                    return new ExecutionResponse(ExecutionResult.SUCCESS, null, 2, null);
                }
                catch (BackendException ex) {
                    return NetworkUtils.INSTANCE.shouldRetryNetworkRequest(ex.getStatusCode()) != false ? new ExecutionResponse(ExecutionResult.FAIL_RETRY, null, 2, null) : new ExecutionResponse(ExecutionResult.FAIL_NORETRY, null, 2, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$getUser(RefreshUserOperationExecutor $this, RefreshUserOperation op, Continuation $completion) {
        return $this.getUser(op, (Continuation<? super ExecutionResponse>)$completion);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/onesignal/user/internal/operations/impl/executors/RefreshUserOperationExecutor$Companion;", "", "()V", "REFRESH_USER", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SubscriptionObjectType.values().length];
            nArray[SubscriptionObjectType.EMAIL.ordinal()] = 1;
            nArray[SubscriptionObjectType.SMS.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

