/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.session.internal.session.impl;

import com.onesignal.common.events.EventProducer;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.background.IBackgroundService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.session.internal.session.ISessionLifecycleHandler;
import com.onesignal.session.internal.session.ISessionService;
import com.onesignal.session.internal.session.SessionModel;
import com.onesignal.session.internal.session.SessionModelStore;
import com.onesignal.session.internal.session.impl.SessionService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u001c\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lcom/onesignal/session/internal/session/impl/SessionService;", "Lcom/onesignal/session/internal/session/ISessionService;", "Lcom/onesignal/core/internal/startup/IStartableService;", "Lcom/onesignal/core/internal/background/IBackgroundService;", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_sessionModelStore", "Lcom/onesignal/session/internal/session/SessionModelStore;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/session/internal/session/SessionModelStore;Lcom/onesignal/core/internal/time/ITime;)V", "_config", "Lcom/onesignal/core/internal/config/ConfigModel;", "_session", "Lcom/onesignal/session/internal/session/SessionModel;", "_sessionLifeCycleNotifier", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/session/internal/session/ISessionLifecycleHandler;", "scheduleBackgroundRunIn", "", "getScheduleBackgroundRunIn", "()Ljava/lang/Long;", "startTime", "getStartTime", "()J", "backgroundRun", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onFocus", "onUnfocused", "start", "subscribe", "handler", "unsubscribe", "core_release"})
public final class SessionService
implements ISessionService,
IStartableService,
IBackgroundService,
IApplicationLifecycleHandler {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final SessionModelStore _sessionModelStore;
    @NotNull
    private final ITime _time;
    @NotNull
    private final EventProducer<ISessionLifecycleHandler> _sessionLifeCycleNotifier;
    @Nullable
    private SessionModel _session;
    @Nullable
    private ConfigModel _config;

    public SessionService(@NotNull IApplicationService _applicationService, @NotNull ConfigModelStore _configModelStore, @NotNull SessionModelStore _sessionModelStore, @NotNull ITime _time) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_sessionModelStore, (String)"_sessionModelStore");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        this._applicationService = _applicationService;
        this._configModelStore = _configModelStore;
        this._sessionModelStore = _sessionModelStore;
        this._time = _time;
        this._sessionLifeCycleNotifier = new EventProducer();
    }

    @Override
    public long getStartTime() {
        SessionModel sessionModel = this._session;
        Intrinsics.checkNotNull((Object)sessionModel);
        return sessionModel.getStartTime();
    }

    @Override
    @Nullable
    public Long getScheduleBackgroundRunIn() {
        Long l;
        SessionModel sessionModel = this._session;
        Intrinsics.checkNotNull((Object)sessionModel);
        if (sessionModel.isValid()) {
            ConfigModel configModel = this._config;
            Intrinsics.checkNotNull((Object)configModel);
            l = configModel.getSessionFocusTimeout();
        } else {
            l = null;
        }
        return l;
    }

    @Override
    public void start() {
        this._session = (SessionModel)this._sessionModelStore.getModel();
        this._config = (ConfigModel)this._configModelStore.getModel();
        this._applicationService.addApplicationLifecycleHandler(this);
    }

    @Override
    @Nullable
    public Object backgroundRun(@NotNull Continuation<? super Unit> $completion) {
        Logging.log(LogLevel.DEBUG, "SessionService.backgroundRun()");
        SessionModel sessionModel = this._session;
        Intrinsics.checkNotNull((Object)sessionModel);
        if (!sessionModel.isValid()) {
            return Unit.INSTANCE;
        }
        StringBuilder stringBuilder = new StringBuilder().append("SessionService: Session ended. activeDuration: ");
        SessionModel sessionModel2 = this._session;
        Intrinsics.checkNotNull((Object)sessionModel2);
        Logging.debug$default(stringBuilder.append(sessionModel2.getActiveDuration()).toString(), null, 2, null);
        SessionModel sessionModel3 = this._session;
        Intrinsics.checkNotNull((Object)sessionModel3);
        sessionModel3.setValid(false);
        this._sessionLifeCycleNotifier.fire((Function1<ISessionLifecycleHandler, Unit>)((Function1)new Function1<ISessionLifecycleHandler, Unit>(this){
            final /* synthetic */ SessionService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ISessionLifecycleHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SessionModel sessionModel = SessionService.access$get_session$p(this.this$0);
                Intrinsics.checkNotNull((Object)sessionModel);
                it.onSessionEnded(sessionModel.getActiveDuration());
            }
        }));
        return Unit.INSTANCE;
    }

    @Override
    public void onFocus() {
        Logging.log(LogLevel.DEBUG, "SessionService.onFocus()");
        SessionModel sessionModel = this._session;
        Intrinsics.checkNotNull((Object)sessionModel);
        if (!sessionModel.isValid()) {
            SessionModel sessionModel2 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel2);
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            sessionModel2.setSessionId(string2);
            SessionModel sessionModel3 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel3);
            sessionModel3.setStartTime(this._time.getCurrentTimeMillis());
            SessionModel sessionModel4 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel4);
            SessionModel sessionModel5 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel5);
            sessionModel4.setFocusTime(sessionModel5.getStartTime());
            SessionModel sessionModel6 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel6);
            sessionModel6.setActiveDuration(0L);
            SessionModel sessionModel7 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel7);
            sessionModel7.setValid(true);
            StringBuilder stringBuilder = new StringBuilder().append("SessionService: New session started at ");
            SessionModel sessionModel8 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel8);
            Logging.debug$default(stringBuilder.append(sessionModel8.getStartTime()).toString(), null, 2, null);
            this._sessionLifeCycleNotifier.fire((Function1<ISessionLifecycleHandler, Unit>)((Function1)onFocus.1.INSTANCE));
        } else {
            SessionModel sessionModel9 = this._session;
            Intrinsics.checkNotNull((Object)sessionModel9);
            sessionModel9.setFocusTime(this._time.getCurrentTimeMillis());
            this._sessionLifeCycleNotifier.fire((Function1<ISessionLifecycleHandler, Unit>)((Function1)onFocus.2.INSTANCE));
        }
    }

    @Override
    public void onUnfocused() {
        Logging.log(LogLevel.DEBUG, "SessionService.onUnfocused()");
        long l = this._time.getCurrentTimeMillis();
        SessionModel sessionModel = this._session;
        Intrinsics.checkNotNull((Object)sessionModel);
        long dt = l - sessionModel.getFocusTime();
        SessionModel sessionModel2 = this._session;
        Intrinsics.checkNotNull((Object)sessionModel2);
        SessionModel sessionModel3 = sessionModel2;
        sessionModel3.setActiveDuration(sessionModel3.getActiveDuration() + dt);
    }

    @Override
    public void subscribe(@NotNull ISessionLifecycleHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._sessionLifeCycleNotifier.subscribe(handler);
    }

    @Override
    public void unsubscribe(@NotNull ISessionLifecycleHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._sessionLifeCycleNotifier.unsubscribe(handler);
    }

    public static final /* synthetic */ SessionModel access$get_session$p(SessionService $this) {
        return $this._session;
    }
}

