/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.operations.listeners;

import com.onesignal.common.modeling.IModelStore;
import com.onesignal.common.modeling.IModelStoreChangeHandler;
import com.onesignal.common.modeling.Model;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.core.internal.operations.IOperationRepo;
import com.onesignal.core.internal.operations.Operation;
import com.onesignal.core.internal.startup.IBootstrapService;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005B\u001b\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H&\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/onesignal/core/internal/operations/listeners/ModelStoreListener;", "TModel", "Lcom/onesignal/common/modeling/Model;", "Lcom/onesignal/common/modeling/IModelStoreChangeHandler;", "Lcom/onesignal/core/internal/startup/IBootstrapService;", "Ljava/io/Closeable;", "store", "Lcom/onesignal/common/modeling/IModelStore;", "opRepo", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "(Lcom/onesignal/common/modeling/IModelStore;Lcom/onesignal/core/internal/operations/IOperationRepo;)V", "bootstrap", "", "close", "getAddOperation", "Lcom/onesignal/core/internal/operations/Operation;", "model", "(Lcom/onesignal/common/modeling/Model;)Lcom/onesignal/core/internal/operations/Operation;", "getRemoveOperation", "getUpdateOperation", "path", "", "property", "oldValue", "", "newValue", "(Lcom/onesignal/common/modeling/Model;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Lcom/onesignal/core/internal/operations/Operation;", "onModelAdded", "tag", "(Lcom/onesignal/common/modeling/Model;Ljava/lang/String;)V", "onModelRemoved", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "core_release"})
public abstract class ModelStoreListener<TModel extends Model>
implements IModelStoreChangeHandler<TModel>,
IBootstrapService,
Closeable {
    @NotNull
    private final IModelStore<TModel> store;
    @NotNull
    private final IOperationRepo opRepo;

    public ModelStoreListener(@NotNull IModelStore<TModel> store, @NotNull IOperationRepo opRepo) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)opRepo, (String)"opRepo");
        this.store = store;
        this.opRepo = opRepo;
    }

    @Override
    public void bootstrap() {
        this.store.subscribe(this);
    }

    @Override
    public void close() {
        this.store.unsubscribe(this);
    }

    @Override
    public void onModelAdded(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!Intrinsics.areEqual((Object)tag, (Object)"NORMAL")) {
            return;
        }
        Operation operation = this.getAddOperation(model);
        if (operation != null) {
            IOperationRepo.DefaultImpls.enqueue$default(this.opRepo, operation, false, 2, null);
        }
    }

    @Override
    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!Intrinsics.areEqual((Object)tag, (Object)"NORMAL")) {
            return;
        }
        Model model = args.getModel();
        Intrinsics.checkNotNull((Object)model, (String)"null cannot be cast to non-null type TModel of com.onesignal.core.internal.operations.listeners.ModelStoreListener");
        Operation operation = this.getUpdateOperation(model, args.getPath(), args.getProperty(), args.getOldValue(), args.getNewValue());
        if (operation != null) {
            IOperationRepo.DefaultImpls.enqueue$default(this.opRepo, operation, false, 2, null);
        }
    }

    @Override
    public void onModelRemoved(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!Intrinsics.areEqual((Object)tag, (Object)"NORMAL")) {
            return;
        }
        Operation operation = this.getRemoveOperation(model);
        if (operation != null) {
            IOperationRepo.DefaultImpls.enqueue$default(this.opRepo, operation, false, 2, null);
        }
    }

    @Nullable
    public abstract Operation getAddOperation(@NotNull TModel var1);

    @Nullable
    public abstract Operation getRemoveOperation(@NotNull TModel var1);

    @Nullable
    public abstract Operation getUpdateOperation(@NotNull TModel var1, @NotNull String var2, @NotNull String var3, @Nullable Object var4, @Nullable Object var5);
}

