/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.application.impl;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.ViewTreeObserver;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.onesignal.common.AndroidUtils;
import com.onesignal.common.DeviceUtils;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.threading.Waiter;
import com.onesignal.core.internal.application.ActivityLifecycleHandlerBase;
import com.onesignal.core.internal.application.AppEntryAction;
import com.onesignal.core.internal.application.IActivityLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.application.impl.ApplicationService;
import com.onesignal.core.internal.application.impl.ISystemConditionHandler;
import com.onesignal.debug.internal.logging.Logging;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u0016J\u0016\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020'H\u0002J\b\u0010/\u001a\u00020'H\u0002J\u001a\u00100\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000f2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0010\u00104\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0018\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u000202H\u0016J\u0010\u00109\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0010\u0010:\u001a\u00020'2\u0006\u0010+\u001a\u00020\u000fH\u0016J\b\u0010;\u001a\u00020'H\u0016J\u0018\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u000fH\u0002J\u0010\u0010>\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u0016J\u000e\u0010@\u001a\u00020'2\u0006\u0010A\u001a\u00020\u000bJ\u0011\u0010B\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ\u0011\u0010D\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006E"}, d2={"Lcom/onesignal/core/internal/application/impl/ApplicationService;", "Lcom/onesignal/core/internal/application/IApplicationService;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "()V", "_activityLifecycleNotifier", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/core/internal/application/IActivityLifecycleHandler;", "_activityReferences", "", "_appContext", "Landroid/content/Context;", "_applicationLifecycleNotifier", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "_current", "Landroid/app/Activity;", "_isActivityChangingConfigurations", "", "_nextResumeIsFirstActivity", "_systemConditionNotifier", "Lcom/onesignal/core/internal/application/impl/ISystemConditionHandler;", "appContext", "getAppContext", "()Landroid/content/Context;", "value", "current", "getCurrent", "()Landroid/app/Activity;", "setCurrent", "(Landroid/app/Activity;)V", "entryState", "Lcom/onesignal/core/internal/application/AppEntryAction;", "getEntryState", "()Lcom/onesignal/core/internal/application/AppEntryAction;", "setEntryState", "(Lcom/onesignal/core/internal/application/AppEntryAction;)V", "isInForeground", "()Z", "addActivityLifecycleHandler", "", "handler", "addApplicationLifecycleHandler", "decorViewReady", "activity", "runnable", "Ljava/lang/Runnable;", "handleFocus", "handleLostFocus", "onActivityCreated", "bundle", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "p0", "p1", "onActivityStarted", "onActivityStopped", "onGlobalLayout", "onOrientationChanged", "orientation", "removeActivityLifecycleHandler", "removeApplicationLifecycleHandler", "start", "context", "waitUntilActivityReady", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitUntilSystemConditionsAvailable", "core_release"})
public final class ApplicationService
implements IApplicationService,
Application.ActivityLifecycleCallbacks,
ViewTreeObserver.OnGlobalLayoutListener {
    @NotNull
    private final EventProducer<IActivityLifecycleHandler> _activityLifecycleNotifier = new EventProducer();
    @NotNull
    private final EventProducer<IApplicationLifecycleHandler> _applicationLifecycleNotifier = new EventProducer();
    @NotNull
    private final EventProducer<ISystemConditionHandler> _systemConditionNotifier = new EventProducer();
    @NotNull
    private AppEntryAction entryState = AppEntryAction.APP_CLOSE;
    @Nullable
    private Context _appContext;
    @Nullable
    private Activity _current;
    private boolean _nextResumeIsFirstActivity;
    private int _activityReferences;
    private boolean _isActivityChangingConfigurations;

    @Override
    public boolean isInForeground() {
        return this.getEntryState().isAppOpen() || this.getEntryState().isNotificationClick();
    }

    @Override
    @NotNull
    public AppEntryAction getEntryState() {
        return this.entryState;
    }

    @Override
    public void setEntryState(@NotNull AppEntryAction appEntryAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)appEntryAction), (String)"<set-?>");
        this.entryState = appEntryAction;
    }

    @Override
    @NotNull
    public Context getAppContext() {
        Context context = this._appContext;
        Intrinsics.checkNotNull((Object)context);
        return context;
    }

    @Override
    @Nullable
    public Activity getCurrent() {
        return this._current;
    }

    public void setCurrent(@Nullable Activity value) {
        this._current = value;
        Logging.debug$default("ApplicationService: current activity=" + this.getCurrent(), null, 2, null);
        if (value != null) {
            this._activityLifecycleNotifier.fire((Function1<IActivityLifecycleHandler, Unit>)((Function1)new Function1<IActivityLifecycleHandler, Unit>(value){
                final /* synthetic */ Activity $value;
                {
                    this.$value = $value;
                    super(1);
                }

                public final void invoke(@NotNull IActivityLifecycleHandler it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onActivityAvailable(this.$value);
                }
            }));
            try {
                value.getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public final void start(@NotNull Context context) {
        boolean isCurrentActivityNull;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._appContext = context;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
        Application application = (Application)context2;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        ComponentCallbacks configuration2 = new ComponentCallbacks(this){
            final /* synthetic */ ApplicationService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConfigurationChanged(@NotNull Configuration newConfig) {
                Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
                if (this.this$0.getCurrent() != null) {
                    Activity activity = this.this$0.getCurrent();
                    Intrinsics.checkNotNull((Object)activity);
                    if (AndroidUtils.INSTANCE.hasConfigChangeFlag(activity, 128)) {
                        int n = newConfig.orientation;
                        Activity activity2 = this.this$0.getCurrent();
                        Intrinsics.checkNotNull((Object)activity2);
                        ApplicationService.access$onOrientationChanged(this.this$0, n, activity2);
                    }
                }
            }

            public void onLowMemory() {
            }
        };
        application.registerComponentCallbacks(configuration2);
        boolean isContextActivity = context instanceof Activity;
        boolean bl = isCurrentActivityNull = this.getCurrent() == null;
        if (!isCurrentActivityNull || isContextActivity) {
            this.setEntryState(AppEntryAction.APP_OPEN);
            if (isCurrentActivityNull && isContextActivity) {
                this.setCurrent((Activity)context);
                this._activityReferences = 1;
                this._nextResumeIsFirstActivity = true;
            }
        } else {
            this._nextResumeIsFirstActivity = true;
            this.setEntryState(AppEntryAction.APP_CLOSE);
        }
        Logging.debug$default("ApplicationService.init: entryState=" + (Object)((Object)this.getEntryState()), null, 2, null);
    }

    @Override
    public void addApplicationLifecycleHandler(@NotNull IApplicationLifecycleHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._applicationLifecycleNotifier.subscribe(handler);
    }

    @Override
    public void removeApplicationLifecycleHandler(@NotNull IApplicationLifecycleHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._applicationLifecycleNotifier.unsubscribe(handler);
    }

    @Override
    public void addActivityLifecycleHandler(@NotNull IActivityLifecycleHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._activityLifecycleNotifier.subscribe(handler);
        if (this.getCurrent() != null) {
            Activity activity = this.getCurrent();
            Intrinsics.checkNotNull((Object)activity);
            handler.onActivityAvailable(activity);
        }
    }

    @Override
    public void removeActivityLifecycleHandler(@NotNull IActivityLifecycleHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._activityLifecycleNotifier.unsubscribe(handler);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logging.debug$default("ApplicationService.onActivityCreated: " + activity, null, 2, null);
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logging.debug$default("ApplicationService.onActivityStarted: " + activity, null, 2, null);
        this.setCurrent(activity);
        ++this._activityReferences;
        if (this._activityReferences == 1 && !this._isActivityChangingConfigurations) {
            this.handleFocus();
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logging.debug$default("ApplicationService.onActivityResumed: " + activity, null, 2, null);
        if (!Intrinsics.areEqual((Object)this.getCurrent(), (Object)activity)) {
            this.setCurrent(activity);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logging.debug$default("ApplicationService.onActivityPaused: " + activity, null, 2, null);
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logging.debug$default("ApplicationService.onActivityStopped: " + activity, null, 2, null);
        this._isActivityChangingConfigurations = activity.isChangingConfigurations();
        this._activityReferences += -1;
        if (this._activityReferences == 0 && !this._isActivityChangingConfigurations) {
            this.setCurrent(null);
            this.handleLostFocus();
        }
        this._activityLifecycleNotifier.fire((Function1<IActivityLifecycleHandler, Unit>)((Function1)new Function1<IActivityLifecycleHandler, Unit>(activity){
            final /* synthetic */ Activity $activity;
            {
                this.$activity = $activity;
                super(1);
            }

            public final void invoke(@NotNull IActivityLifecycleHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onActivityStopped(this.$activity);
            }
        }));
    }

    public void onActivitySaveInstanceState(@NotNull Activity p0, @NotNull Bundle p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logging.debug$default("ApplicationService.onActivityDestroyed: " + activity, null, 2, null);
    }

    public void onGlobalLayout() {
        this._systemConditionNotifier.fire((Function1<ISystemConditionHandler, Unit>)((Function1)onGlobalLayout.1.INSTANCE));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object waitUntilSystemConditionsAvailable(@NotNull Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof waitUntilSystemConditionsAvailable.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ApplicationService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.waitUntilSystemConditionsAvailable((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                currentActivity = this.getCurrent();
                if (currentActivity == null) {
                    Logging.warn$default("ApplicationService.waitUntilSystemConditionsAvailable: current is null", null, 2, null);
                    return Boxing.boxBoolean((boolean)false);
                }
                if (!(currentActivity instanceof AppCompatActivity)) ** GOTO lbl45
                v0 = ((AppCompatActivity)currentActivity).getSupportFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"currentActivity.supportFragmentManager");
                manager = v0;
                v1 = manager.getFragments();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"manager.fragments");
                lastFragment = (Fragment)CollectionsKt.lastOrNull((List)v1);
                if (lastFragment == null || !lastFragment.isVisible() || !(lastFragment instanceof DialogFragment)) ** GOTO lbl45
                waiter = new Waiter();
                manager.registerFragmentLifecycleCallbacks(new FragmentManager.FragmentLifecycleCallbacks(manager, waiter){
                    final /* synthetic */ FragmentManager $manager;
                    final /* synthetic */ Waiter $waiter;
                    {
                        this.$manager = $manager;
                        this.$waiter = $waiter;
                    }

                    public void onFragmentDetached(@NotNull FragmentManager fm, @NotNull Fragment fragmentDetached) {
                        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
                        Intrinsics.checkNotNullParameter((Object)fragmentDetached, (String)"fragmentDetached");
                        super.onFragmentDetached(fm, fragmentDetached);
                        if (fragmentDetached instanceof DialogFragment) {
                            this.$manager.unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this);
                            this.$waiter.wake();
                        }
                    }
                }, true);
                $continuation.L$0 = this;
                $continuation.L$1 = currentActivity;
                $continuation.label = 1;
                v2 = waiter.waitForWake((Continuation<Object>)$continuation);
                ** if (v2 != var8_4) goto lbl34
lbl33:
                // 1 sources

                return var8_4;
lbl34:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                currentActivity = (Activity)$continuation.L$1;
                this = (ApplicationService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (NoClassDefFoundError exception) {
                    Logging.info$default("ApplicationService.waitUntilSystemConditionsAvailable: AppCompatActivity is not used in this app, skipping 'isDialogFragmentShowing' check: " + exception, null, 2, null);
                }
lbl45:
                // 5 sources

                waiter = new Waiter();
                systemConditionHandler = new ISystemConditionHandler(this, waiter){
                    final /* synthetic */ ApplicationService this$0;
                    final /* synthetic */ Waiter $waiter;
                    {
                        this.this$0 = $receiver;
                        this.$waiter = $waiter;
                    }

                    public void systemConditionChanged() {
                        boolean keyboardUp = DeviceUtils.INSTANCE.isKeyboardUp(new WeakReference<Activity>(this.this$0.getCurrent()));
                        if (!keyboardUp) {
                            this.$waiter.wake();
                        }
                    }
                };
                this._systemConditionNotifier.subscribe(systemConditionHandler);
                keyboardUp = DeviceUtils.INSTANCE.isKeyboardUp(new WeakReference<Activity>(currentActivity));
                if (keyboardUp) {
                    Logging.warn$default("ApplicationService.waitUntilSystemConditionsAvailable: keyboard up detected", null, 2, null);
                    $continuation.L$0 = this;
                    $continuation.L$1 = systemConditionHandler;
                    $continuation.label = 2;
                    v3 = waiter.waitForWake((Continuation<Object>)$continuation);
                    if (v3 == var8_4) {
                        return var8_4;
                    }
                }
                ** GOTO lbl63
            }
            case 2: {
                systemConditionHandler = $continuation.L$1;
                this = (ApplicationService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl63:
                // 2 sources

                this._systemConditionNotifier.unsubscribe(systemConditionHandler);
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object waitUntilActivityReady(@NotNull Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof waitUntilActivityReady.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ ApplicationService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.waitUntilActivityReady((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getCurrent();
                if (v0 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                currentActivity = v0;
                waiter = new Waiter();
                this.decorViewReady(currentActivity, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, waitUntilActivityReady$lambda-0(com.onesignal.common.threading.Waiter ), ()V)((Waiter)waiter));
                $continuation.label = 1;
                v1 = waiter.waitForWake((Continuation<Object>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void decorViewReady(@NotNull Activity activity, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        String listenerKey = "decorViewReady:" + runnable;
        ApplicationService self = this;
        activity.getWindow().getDecorView().post(() -> ApplicationService.decorViewReady$lambda-1(self, runnable, this));
    }

    private final void onOrientationChanged(int orientation, Activity activity) {
        switch (orientation) {
            case 2: {
                Logging.debug$default("ApplicationService.onOrientationChanged: Configuration Orientation Change: LANDSCAPE (" + orientation + ") on activity: " + activity, null, 2, null);
                break;
            }
            case 1: {
                Logging.debug$default("ApplicationService.onOrientationChanged: Configuration Orientation Change: PORTRAIT (" + orientation + ") on activity: " + activity, null, 2, null);
            }
        }
        this.handleLostFocus();
        this._activityLifecycleNotifier.fire((Function1<IActivityLifecycleHandler, Unit>)((Function1)new Function1<IActivityLifecycleHandler, Unit>(activity){
            final /* synthetic */ Activity $activity;
            {
                this.$activity = $activity;
                super(1);
            }

            public final void invoke(@NotNull IActivityLifecycleHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onActivityStopped(this.$activity);
            }
        }));
        this._activityLifecycleNotifier.fire((Function1<IActivityLifecycleHandler, Unit>)((Function1)new Function1<IActivityLifecycleHandler, Unit>(activity){
            final /* synthetic */ Activity $activity;
            {
                this.$activity = $activity;
                super(1);
            }

            public final void invoke(@NotNull IActivityLifecycleHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onActivityAvailable(this.$activity);
            }
        }));
        activity.getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.handleFocus();
    }

    private final void handleLostFocus() {
        if (this.isInForeground()) {
            Logging.debug$default("ApplicationService.handleLostFocus: application is now out of focus", null, 2, null);
            this.setEntryState(AppEntryAction.APP_CLOSE);
            this._applicationLifecycleNotifier.fire((Function1<IApplicationLifecycleHandler, Unit>)((Function1)handleLostFocus.1.INSTANCE));
        } else {
            Logging.debug$default("ApplicationService.handleLostFocus: application already out of focus", null, 2, null);
        }
    }

    private final void handleFocus() {
        if (!this.isInForeground() || this._nextResumeIsFirstActivity) {
            Logging.debug$default("ApplicationService.handleFocus: application is now in focus, nextResumeIsFirstActivity=" + this._nextResumeIsFirstActivity, null, 2, null);
            this._nextResumeIsFirstActivity = false;
            if (this.getEntryState() != AppEntryAction.NOTIFICATION_CLICK) {
                this.setEntryState(AppEntryAction.APP_OPEN);
            }
            this._applicationLifecycleNotifier.fire((Function1<IApplicationLifecycleHandler, Unit>)((Function1)handleFocus.1.INSTANCE));
        } else {
            Logging.debug$default("ApplicationService.handleFocus: application never lost focus", null, 2, null);
        }
    }

    private static final void waitUntilActivityReady$lambda-0(Waiter $waiter) {
        Intrinsics.checkNotNullParameter((Object)$waiter, (String)"$waiter");
        $waiter.wake();
    }

    private static final void decorViewReady$lambda-1(ApplicationService $self, Runnable $runnable, ApplicationService this$0) {
        Intrinsics.checkNotNullParameter((Object)$self, (String)"$self");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $self.addActivityLifecycleHandler(new ActivityLifecycleHandlerBase($self, $runnable, this$0){
            final /* synthetic */ ApplicationService $self;
            final /* synthetic */ Runnable $runnable;
            final /* synthetic */ ApplicationService this$0;
            {
                this.$self = $self;
                this.$runnable = $runnable;
                this.this$0 = $receiver;
            }

            public void onActivityAvailable(@NotNull Activity currentActivity) {
                Intrinsics.checkNotNullParameter((Object)currentActivity, (String)"currentActivity");
                this.$self.removeActivityLifecycleHandler(this);
                if (AndroidUtils.INSTANCE.isActivityFullyReady(currentActivity)) {
                    this.$runnable.run();
                } else {
                    this.this$0.decorViewReady(currentActivity, this.$runnable);
                }
            }
        });
    }

    public static final /* synthetic */ void access$onOrientationChanged(ApplicationService $this, int orientation, Activity activity) {
        $this.onOrientationChanged(orientation, activity);
    }
}

