/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.Nullable;
import com.onesignal.ImmutableJSONObject;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import com.onesignal.UserStateSynchronizer;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UserStateSecondaryChannelSynchronizer
extends UserStateSynchronizer {
    UserStateSecondaryChannelSynchronizer(OneSignalStateSynchronizer.UserStateSynchronizerType channel) {
        super(channel);
    }

    @Override
    protected abstract UserState newUserState(String var1, boolean var2);

    @Override
    protected abstract String getId();

    @Override
    abstract void logoutChannel();

    protected abstract String getChannelKey();

    protected abstract String getAuthHashKey();

    protected abstract int getDeviceType();

    abstract void fireUpdateSuccess(JSONObject var1);

    abstract void fireUpdateFailure();

    @Override
    abstract void updateIdDependents(String var1);

    @Override
    protected OneSignal.LOG_LEVEL getLogLevel() {
        return OneSignal.LOG_LEVEL.INFO;
    }

    @Override
    boolean getSubscribed() {
        return false;
    }

    @Override
    UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        return null;
    }

    @Override
    @Nullable
    String getExternalId(boolean fromServer) {
        return null;
    }

    @Override
    void setSubscription(boolean enable) {
    }

    @Override
    public boolean getUserSubscribePreference() {
        return false;
    }

    @Override
    public void setPermission(boolean enable) {
    }

    @Override
    void updateState(JSONObject state) {
    }

    void refresh() {
        this.scheduleSyncToServer();
    }

    @Override
    protected void scheduleSyncToServer() {
        boolean userNotRegistered;
        boolean bl = userNotRegistered = this.getId() == null && this.getRegistrationId() == null;
        if (userNotRegistered || OneSignal.getUserId() == null) {
            return;
        }
        this.getNetworkHandlerThread(0).runNewJobDelayed();
    }

    @Override
    protected void addOnSessionOrCreateExtras(JSONObject jsonBody) {
        try {
            jsonBody.put("device_type", this.getDeviceType());
            jsonBody.putOpt("device_player_id", (Object)OneSignal.getUserId());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void fireEventsForUpdateFailure(JSONObject jsonFields) {
        if (jsonFields.has("identifier")) {
            this.fireUpdateFailure();
        }
    }

    @Override
    protected void onSuccessfulSync(JSONObject jsonFields) {
        if (jsonFields.has("identifier")) {
            JSONObject result = new JSONObject();
            try {
                result.put(this.getChannelKey(), jsonFields.get("identifier"));
                if (jsonFields.has(this.getAuthHashKey())) {
                    result.put(this.getAuthHashKey(), jsonFields.get(this.getAuthHashKey()));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.fireUpdateSuccess(result);
        }
    }

    void setChannelId(String id2, String idAuthHash) {
        boolean noChange;
        UserState userState = this.getUserStateForModification();
        ImmutableJSONObject syncValues = userState.getSyncValues();
        boolean bl = id2.equals(syncValues.optString("identifier")) && syncValues.optString(this.getAuthHashKey()).equals(idAuthHash == null ? "" : idAuthHash) ? true : (noChange = false);
        if (noChange) {
            JSONObject result = new JSONObject();
            try {
                result.put(this.getChannelKey(), (Object)id2);
                result.put(this.getAuthHashKey(), (Object)idAuthHash);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.fireUpdateSuccess(result);
            return;
        }
        String existingEmail = syncValues.optString("identifier", null);
        if (existingEmail == null) {
            this.setNewSession();
        }
        try {
            JSONObject emailJSON = new JSONObject();
            emailJSON.put("identifier", (Object)id2);
            if (idAuthHash != null) {
                emailJSON.put(this.getAuthHashKey(), (Object)idAuthHash);
            }
            if (idAuthHash == null && existingEmail != null && !existingEmail.equals(id2)) {
                this.saveChannelId("");
                this.resetCurrentState();
                this.setNewSession();
            }
            userState.generateJsonDiffFromIntoSyncValued(emailJSON, null);
            this.scheduleSyncToServer();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

