/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import androidx.work.Configuration;
import androidx.work.WorkManager;
import com.onesignal.OneSignal;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/onesignal/OSWorkManagerHelper;", "", "()V", "getInstance", "Landroidx/work/WorkManager;", "context", "Landroid/content/Context;", "initializeWorkManager", "", "onesignal_release"})
public final class OSWorkManagerHelper {
    @NotNull
    public static final OSWorkManagerHelper INSTANCE = new OSWorkManagerHelper();

    private OSWorkManagerHelper() {
    }

    @JvmStatic
    @NotNull
    public static final synchronized WorkManager getInstance(@NotNull Context context) {
        WorkManager workManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            workManager = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"{\n            WorkManage\u2026stance(context)\n        }");
        }
        catch (IllegalStateException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "OSWorkManagerHelper.getInstance failed, attempting to initialize: ", e);
            INSTANCE.initializeWorkManager(context);
            WorkManager workManager2 = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager2, (String)"{\n            /*\n       \u2026stance(context)\n        }");
            workManager = workManager2;
        }
        return workManager;
    }

    private final void initializeWorkManager(Context context) {
        try {
            Context context2 = context.getApplicationContext();
            Configuration.Provider provider = context2 instanceof Configuration.Provider ? (Configuration.Provider)context2 : null;
            Configuration configuration = provider == null ? null : provider.getWorkManagerConfiguration();
            Configuration configuration2 = configuration == null ? new Configuration.Builder().build() : configuration;
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"(context.applicationCont\u2026uration.Builder().build()");
            Configuration configuration3 = configuration2;
            WorkManager.initialize((Context)context, (Configuration)configuration3);
        }
        catch (IllegalStateException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "OSWorkManagerHelper initializing WorkManager failed: ", e);
        }
    }
}

