/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import com.onesignal.OSInAppMessageRedisplayStats;
import com.onesignal.OSTrigger;
import com.onesignal.OneSignalSimpleDateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessage {
    private static final String IAM_ID = "id";
    private static final String IAM_VARIANTS = "variants";
    private static final String IAM_TRIGGERS = "triggers";
    private static final String IAM_REDISPLAY_STATS = "redisplay";
    private static final String DISPLAY_DURATION = "displayDuration";
    private static final String END_TIME = "end_time";
    private static final String HAS_LIQUID = "has_liquid";
    @NonNull
    public String messageId;
    @NonNull
    public HashMap<String, HashMap<String, String>> variants;
    @NonNull
    public ArrayList<ArrayList<OSTrigger>> triggers;
    @NonNull
    private Set<String> clickedClickIds;
    private OSInAppMessageRedisplayStats redisplayStats = new OSInAppMessageRedisplayStats();
    private double displayDuration;
    private boolean displayedInSession = false;
    private boolean triggerChanged = false;
    private boolean actionTaken;
    private Date endTime;
    boolean isPreview;
    private boolean hasLiquid;

    OSInAppMessage(boolean isPreview) {
        this.isPreview = isPreview;
    }

    OSInAppMessage(@NonNull String messageId, @NonNull Set<String> clickIds, boolean displayedInSession, OSInAppMessageRedisplayStats redisplayStats) {
        this.messageId = messageId;
        this.clickedClickIds = clickIds;
        this.displayedInSession = displayedInSession;
        this.redisplayStats = redisplayStats;
    }

    OSInAppMessage(JSONObject json) throws JSONException {
        this.messageId = json.getString(IAM_ID);
        this.variants = this.parseVariants(json.getJSONObject(IAM_VARIANTS));
        this.triggers = this.parseTriggerJson(json.getJSONArray(IAM_TRIGGERS));
        this.clickedClickIds = new HashSet<String>();
        this.endTime = this.parseEndTimeJson(json);
        if (json.has(HAS_LIQUID)) {
            this.hasLiquid = json.getBoolean(HAS_LIQUID);
        }
        if (json.has(IAM_REDISPLAY_STATS)) {
            this.redisplayStats = new OSInAppMessageRedisplayStats(json.getJSONObject(IAM_REDISPLAY_STATS));
        }
    }

    private Date parseEndTimeJson(JSONObject json) {
        String endTimeString;
        try {
            endTimeString = json.getString(END_TIME);
        }
        catch (JSONException e) {
            return null;
        }
        if (endTimeString.equals("null")) {
            return null;
        }
        try {
            SimpleDateFormat format = OneSignalSimpleDateFormat.iso8601Format();
            return format.parse(endTimeString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap<String, HashMap<String, String>> parseVariants(JSONObject json) throws JSONException {
        HashMap<String, HashMap<String, String>> variantTypes = new HashMap<String, HashMap<String, String>>();
        Iterator keyIterator = json.keys();
        while (keyIterator.hasNext()) {
            String variantType = (String)keyIterator.next();
            JSONObject variant = json.getJSONObject(variantType);
            HashMap<String, String> variantMap = new HashMap<String, String>();
            Iterator variantIterator = variant.keys();
            while (variantIterator.hasNext()) {
                String languageType = (String)variantIterator.next();
                variantMap.put(languageType, variant.getString(languageType));
            }
            variantTypes.put(variantType, variantMap);
        }
        return variantTypes;
    }

    protected ArrayList<ArrayList<OSTrigger>> parseTriggerJson(JSONArray triggersJson) throws JSONException {
        ArrayList<ArrayList<OSTrigger>> parsedTriggers = new ArrayList<ArrayList<OSTrigger>>();
        for (int i = 0; i < triggersJson.length(); ++i) {
            JSONArray ands = triggersJson.getJSONArray(i);
            ArrayList<OSTrigger> converted = new ArrayList<OSTrigger>();
            for (int j = 0; j < ands.length(); ++j) {
                OSTrigger trigger = new OSTrigger(ands.getJSONObject(j));
                converted.add(trigger);
            }
            parsedTriggers.add(converted);
        }
        return parsedTriggers;
    }

    JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put(IAM_ID, (Object)this.messageId);
            JSONObject variants = new JSONObject();
            for (String string2 : this.variants.keySet()) {
                HashMap<String, String> hashMap = this.variants.get(string2);
                JSONObject converted = new JSONObject();
                for (String variantKey : hashMap.keySet()) {
                    converted.put(variantKey, (Object)hashMap.get(variantKey));
                }
                variants.put(string2, (Object)converted);
            }
            json.put(IAM_VARIANTS, (Object)variants);
            json.put(DISPLAY_DURATION, this.displayDuration);
            json.put(IAM_REDISPLAY_STATS, (Object)this.redisplayStats.toJSONObject());
            JSONArray orConditions = new JSONArray();
            for (ArrayList<OSTrigger> arrayList : this.triggers) {
                JSONArray andConditions = new JSONArray();
                for (OSTrigger trigger : arrayList) {
                    andConditions.put((Object)trigger.toJSONObject());
                }
                orConditions.put((Object)andConditions);
            }
            json.put(IAM_TRIGGERS, (Object)orConditions);
            if (this.endTime != null) {
                SimpleDateFormat simpleDateFormat = OneSignalSimpleDateFormat.iso8601Format();
                String string3 = simpleDateFormat.format(this.endTime);
                json.put(END_TIME, (Object)string3);
            }
            json.put(HAS_LIQUID, this.hasLiquid);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json;
    }

    boolean takeActionAsUnique() {
        if (this.actionTaken) {
            return false;
        }
        this.actionTaken = true;
        return true;
    }

    double getDisplayDuration() {
        return this.displayDuration;
    }

    void setDisplayDuration(double displayDuration) {
        this.displayDuration = displayDuration;
    }

    boolean isTriggerChanged() {
        return this.triggerChanged;
    }

    void setTriggerChanged(boolean triggerChanged) {
        this.triggerChanged = triggerChanged;
    }

    public boolean isDisplayedInSession() {
        return this.displayedInSession;
    }

    public void setDisplayedInSession(boolean displayedInSession) {
        this.displayedInSession = displayedInSession;
    }

    boolean getHasLiquid() {
        return this.hasLiquid;
    }

    void setHasLiquid(boolean hasLiquid) {
        this.hasLiquid = hasLiquid;
    }

    @NonNull
    Set<String> getClickedClickIds() {
        return this.clickedClickIds;
    }

    boolean isClickAvailable(String clickId) {
        return !this.clickedClickIds.contains(clickId);
    }

    void clearClickIds() {
        this.clickedClickIds.clear();
    }

    void addClickId(String clickId) {
        this.clickedClickIds.add(clickId);
    }

    void removeClickId(String clickId) {
        this.clickedClickIds.remove(clickId);
    }

    OSInAppMessageRedisplayStats getRedisplayStats() {
        return this.redisplayStats;
    }

    void setRedisplayStats(int displayQuantity, long lastDisplayTime) {
        this.redisplayStats = new OSInAppMessageRedisplayStats(displayQuantity, lastDisplayTime);
    }

    public String toString() {
        return "OSInAppMessage{messageId='" + this.messageId + '\'' + ", variants=" + this.variants + ", triggers=" + this.triggers + ", clickedClickIds=" + this.clickedClickIds + ", redisplayStats=" + this.redisplayStats + ", displayDuration=" + this.displayDuration + ", displayedInSession=" + this.displayedInSession + ", triggerChanged=" + this.triggerChanged + ", actionTaken=" + this.actionTaken + ", isPreview=" + this.isPreview + ", endTime=" + this.endTime + ", hasLiquid=" + this.hasLiquid + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSInAppMessage that = (OSInAppMessage)o;
        return this.messageId.equals(that.messageId);
    }

    public int hashCode() {
        int result = this.messageId.hashCode();
        return result;
    }

    public boolean isFinished() {
        if (this.endTime == null) {
            return false;
        }
        Date now = new Date();
        return this.endTime.before(now);
    }
}

