/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.work.ListenableWorker;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.BundleCompat;
import com.onesignal.GenerateNotification;
import com.onesignal.OSInAppMessagePreviewHandler;
import com.onesignal.OSNotificationController;
import com.onesignal.OSNotificationDataController;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSNotificationWorkManager;
import com.onesignal.OSReceiveReceiptController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationBundleProcessor {
    public static final String PUSH_ADDITIONAL_DATA_KEY = "a";
    public static final String PUSH_MINIFIED_BUTTONS_LIST = "o";
    public static final String PUSH_MINIFIED_BUTTON_ID = "i";
    public static final String PUSH_MINIFIED_BUTTON_TEXT = "n";
    public static final String PUSH_MINIFIED_BUTTON_ICON = "p";
    private static final String ANDROID_NOTIFICATION_ID = "android_notif_id";
    static final String IAM_PREVIEW_KEY = "os_in_app_message_preview_id";
    static final String DEFAULT_ACTION = "__DEFAULT__";

    NotificationBundleProcessor() {
    }

    static void processFromFCMIntentService(final Context context, BundleCompat bundle) {
        OneSignal.initWithContext(context);
        try {
            final String jsonStrPayload = bundle.getString("json_payload");
            if (jsonStrPayload == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "json_payload key is nonexistent from mBundle passed to ProcessFromFCMIntentService: " + bundle);
                return;
            }
            final JSONObject jsonPayload = new JSONObject(jsonStrPayload);
            final boolean isRestoring = bundle.getBoolean("is_restoring", false);
            final long shownTimeStamp = bundle.getLong("timestamp");
            int androidNotificationId = 0;
            if (bundle.containsKey(ANDROID_NOTIFICATION_ID)) {
                androidNotificationId = bundle.getInt(ANDROID_NOTIFICATION_ID);
            }
            final int finalAndroidNotificationId = androidNotificationId;
            OSNotificationDataController.InvalidOrDuplicateNotificationCallback callback = new OSNotificationDataController.InvalidOrDuplicateNotificationCallback(){

                @Override
                public void onResult(boolean result) {
                    if (!isRestoring && result) {
                        return;
                    }
                    String osNotificationId = OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonPayload);
                    OSNotificationWorkManager.beginEnqueueingWork(context, osNotificationId, finalAndroidNotificationId, jsonStrPayload, shownTimeStamp, isRestoring, false, true);
                    if (isRestoring) {
                        OSUtils.sleep(100);
                    }
                }
            };
            OneSignal.notValidOrDuplicated(context, jsonPayload, callback);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @WorkerThread
    static int processJobForDisplay(OSNotificationGenerationJob notificationJob, boolean fromBackgroundLogic) {
        OSNotificationController notificationController = new OSNotificationController(notificationJob, notificationJob.isRestoring(), true);
        return NotificationBundleProcessor.processJobForDisplay(notificationController, false, fromBackgroundLogic);
    }

    @WorkerThread
    static int processJobForDisplay(OSNotificationController notificationController, boolean fromBackgroundLogic) {
        return NotificationBundleProcessor.processJobForDisplay(notificationController, false, fromBackgroundLogic);
    }

    @WorkerThread
    private static int processJobForDisplay(OSNotificationController notificationController, boolean opened, boolean fromBackgroundLogic) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Starting processJobForDisplay opened: " + opened + " fromBackgroundLogic: " + fromBackgroundLogic);
        OSNotificationGenerationJob notificationJob = notificationController.getNotificationJob();
        NotificationBundleProcessor.processCollapseKey(notificationJob);
        int androidNotificationId = notificationJob.getAndroidIdWithoutCreate();
        boolean doDisplay = NotificationBundleProcessor.shouldDisplayNotification(notificationJob);
        boolean notificationDisplayed = false;
        if (doDisplay) {
            androidNotificationId = notificationJob.getAndroidId();
            if (fromBackgroundLogic && OneSignal.shouldFireForegroundHandlers()) {
                notificationController.setFromBackgroundLogic(false);
                OneSignal.fireForegroundHandlers(notificationController);
                return androidNotificationId;
            }
            notificationDisplayed = GenerateNotification.displayNotification(notificationJob);
        }
        if (!notificationJob.isRestoring()) {
            NotificationBundleProcessor.processNotification(notificationJob, opened, notificationDisplayed);
            String osNotificationId = OSNotificationFormatHelper.getOSNotificationIdFromJson(notificationController.getNotificationJob().getJsonPayload());
            OSNotificationWorkManager.removeNotificationIdProcessed(osNotificationId);
            OneSignal.handleNotificationReceived(notificationJob);
        } else {
            CallbackToFutureAdapter.Completer<ListenableWorker.Result> callbackCompleter = notificationJob.getCallbackCompleter();
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Process notification restored or IAM with callback completer: " + callbackCompleter);
            if (callbackCompleter != null) {
                callbackCompleter.set((Object)ListenableWorker.Result.success());
            }
        }
        return androidNotificationId;
    }

    private static boolean shouldDisplayNotification(OSNotificationGenerationJob notificationJob) {
        return notificationJob.hasExtender() || OSUtils.isStringNotEmpty(notificationJob.getJsonPayload().optString("alert"));
    }

    static void processNotification(OSNotificationGenerationJob notificationJob, boolean opened, boolean notificationDisplayed) {
        NotificationBundleProcessor.saveNotification(notificationJob, opened);
        CallbackToFutureAdapter.Completer<ListenableWorker.Result> callbackCompleter = notificationJob.getCallbackCompleter();
        if (!notificationDisplayed) {
            NotificationBundleProcessor.markNotificationAsDismissed(notificationJob);
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Process notification not displayed with callback completer: " + callbackCompleter);
            if (callbackCompleter != null) {
                callbackCompleter.set((Object)ListenableWorker.Result.success());
            }
            return;
        }
        String notificationId = notificationJob.getApiNotificationId();
        OSReceiveReceiptController.getInstance().sendReceiveReceipt(callbackCompleter, notificationId);
        OneSignal.getSessionManager().onNotificationReceived(notificationId);
    }

    private static void saveNotification(OSNotificationGenerationJob notificationJob, boolean opened) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Saving Notification job: " + notificationJob.toString());
        Context context = notificationJob.getContext();
        JSONObject jsonPayload = notificationJob.getJsonPayload();
        try {
            JSONObject customJSON = NotificationBundleProcessor.getCustomJSONObject(notificationJob.getJsonPayload());
            OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notificationJob.getContext());
            if (notificationJob.isNotificationToDisplay()) {
                String whereStr = "android_notification_id = " + notificationJob.getAndroidIdWithoutCreate();
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                dbHelper.update("notification", values, whereStr, null);
                BadgeCountUpdater.update(dbHelper, context);
            }
            ContentValues values = new ContentValues();
            values.put("notification_id", customJSON.optString(PUSH_MINIFIED_BUTTON_ID));
            if (jsonPayload.has("grp")) {
                values.put("group_id", jsonPayload.optString("grp"));
            }
            if (jsonPayload.has("collapse_key") && !"do_not_collapse".equals(jsonPayload.optString("collapse_key"))) {
                values.put("collapse_id", jsonPayload.optString("collapse_key"));
            }
            values.put("opened", Integer.valueOf(opened ? 1 : 0));
            if (!opened) {
                values.put("android_notification_id", Integer.valueOf(notificationJob.getAndroidIdWithoutCreate()));
            }
            if (notificationJob.getTitle() != null) {
                values.put("title", notificationJob.getTitle().toString());
            }
            if (notificationJob.getBody() != null) {
                values.put("message", notificationJob.getBody().toString());
            }
            long sentTime = jsonPayload.optLong("google.sent_time", OneSignal.getTime().getCurrentThreadTimeMillis()) / 1000L;
            int ttl = jsonPayload.optInt("google.ttl", 259200);
            long expireTime = sentTime + (long)ttl;
            values.put("expire_time", Long.valueOf(expireTime));
            values.put("full_data", jsonPayload.toString());
            dbHelper.insertOrThrow("notification", null, values);
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Notification saved values: " + values.toString());
            if (!opened) {
                BadgeCountUpdater.update(dbHelper, context);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void markNotificationAsDismissed(OSNotificationGenerationJob notifiJob) {
        if (notifiJob.getAndroidIdWithoutCreate() == -1) {
            return;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Marking restored or disabled notifications as dismissed: " + notifiJob.toString());
        String whereStr = "android_notification_id = " + notifiJob.getAndroidIdWithoutCreate();
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notifiJob.getContext());
        ContentValues values = new ContentValues();
        values.put("dismissed", Integer.valueOf(1));
        dbHelper.update("notification", values, whereStr, null);
        BadgeCountUpdater.update(dbHelper, notifiJob.getContext());
    }

    @NonNull
    static JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "bundleAsJSONObject error for key: " + key, e);
            }
        }
        return json;
    }

    private static void maximizeButtonsFromBundle(Bundle fcmBundle) {
        if (!fcmBundle.containsKey(PUSH_MINIFIED_BUTTONS_LIST)) {
            return;
        }
        try {
            JSONObject customJSON = new JSONObject(fcmBundle.getString("custom"));
            JSONObject additionalDataJSON = customJSON.has(PUSH_ADDITIONAL_DATA_KEY) ? customJSON.getJSONObject(PUSH_ADDITIONAL_DATA_KEY) : new JSONObject();
            JSONArray buttons = new JSONArray(fcmBundle.getString(PUSH_MINIFIED_BUTTONS_LIST));
            fcmBundle.remove(PUSH_MINIFIED_BUTTONS_LIST);
            for (int i = 0; i < buttons.length(); ++i) {
                String buttonId;
                JSONObject button = buttons.getJSONObject(i);
                String buttonText = button.getString(PUSH_MINIFIED_BUTTON_TEXT);
                button.remove(PUSH_MINIFIED_BUTTON_TEXT);
                if (button.has(PUSH_MINIFIED_BUTTON_ID)) {
                    buttonId = button.getString(PUSH_MINIFIED_BUTTON_ID);
                    button.remove(PUSH_MINIFIED_BUTTON_ID);
                } else {
                    buttonId = buttonText;
                }
                button.put("id", (Object)buttonId);
                button.put("text", (Object)buttonText);
                if (!button.has(PUSH_MINIFIED_BUTTON_ICON)) continue;
                button.put("icon", (Object)button.getString(PUSH_MINIFIED_BUTTON_ICON));
                button.remove(PUSH_MINIFIED_BUTTON_ICON);
            }
            additionalDataJSON.put("actionButtons", (Object)buttons);
            additionalDataJSON.put("actionId", (Object)DEFAULT_ACTION);
            if (!customJSON.has(PUSH_ADDITIONAL_DATA_KEY)) {
                customJSON.put(PUSH_ADDITIONAL_DATA_KEY, (Object)additionalDataJSON);
            }
            fcmBundle.putString("custom", customJSON.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void processCollapseKey(OSNotificationGenerationJob notificationJob) {
        if (notificationJob.isRestoring()) {
            return;
        }
        if (!notificationJob.getJsonPayload().has("collapse_key") || "do_not_collapse".equals(notificationJob.getJsonPayload().optString("collapse_key"))) {
            return;
        }
        String collapse_id = notificationJob.getJsonPayload().optString("collapse_key");
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notificationJob.getContext());
        Cursor cursor = dbHelper.query("notification", new String[]{"android_notification_id"}, "collapse_id = ? AND dismissed = 0 AND opened = 0 ", new String[]{collapse_id}, null, null, null);
        if (cursor.moveToFirst()) {
            int androidNotificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
            notificationJob.setAndroidIdWithoutOverriding(androidNotificationId);
        }
        cursor.close();
    }

    static void processBundleFromReceiver(Context context, Bundle bundle, final ProcessBundleReceiverCallback bundleReceiverCallback2) {
        final ProcessedBundleResult bundleResult = new ProcessedBundleResult();
        if (!OSNotificationFormatHelper.isOneSignalBundle(bundle)) {
            bundleReceiverCallback2.onBundleProcessed(bundleResult);
            return;
        }
        bundleResult.setOneSignalPayload(true);
        NotificationBundleProcessor.maximizeButtonsFromBundle(bundle);
        if (OSInAppMessagePreviewHandler.inAppMessagePreviewHandled(context, bundle)) {
            bundleResult.setInAppPreviewShown(true);
            bundleReceiverCallback2.onBundleProcessed(bundleResult);
            return;
        }
        NotificationProcessingCallback processingCallback = new NotificationProcessingCallback(){

            @Override
            public void onResult(boolean notificationProcessed) {
                if (!notificationProcessed) {
                    bundleResult.setDup(true);
                }
                bundleReceiverCallback2.onBundleProcessed(bundleResult);
            }
        };
        NotificationBundleProcessor.startNotificationProcessing(context, bundle, bundleResult, processingCallback);
    }

    private static void startNotificationProcessing(final Context context, final Bundle bundle, final ProcessedBundleResult bundleResult, final NotificationProcessingCallback notificationProcessingCallback) {
        final JSONObject jsonPayload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        final long timestamp = OneSignal.getTime().getCurrentTimeMillis() / 1000L;
        final boolean isRestoring = bundle.getBoolean("is_restoring", false);
        final boolean isHighPriority = Integer.parseInt(bundle.getString("pri", "0")) > 9;
        OSNotificationDataController.InvalidOrDuplicateNotificationCallback callback = new OSNotificationDataController.InvalidOrDuplicateNotificationCallback(){

            @Override
            public void onResult(boolean result) {
                if (!isRestoring && result) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "startNotificationProcessing returning, with context: " + context + " and bundle: " + bundle);
                    notificationProcessingCallback.onResult(false);
                    return;
                }
                String osNotificationId = OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonPayload);
                int androidNotificationId = 0;
                if (bundle.containsKey(NotificationBundleProcessor.ANDROID_NOTIFICATION_ID)) {
                    androidNotificationId = bundle.getInt(NotificationBundleProcessor.ANDROID_NOTIFICATION_ID);
                }
                OSNotificationWorkManager.beginEnqueueingWork(context, osNotificationId, androidNotificationId, jsonPayload.toString(), timestamp, isRestoring, isHighPriority, true);
                bundleResult.setWorkManagerProcessing(true);
                notificationProcessingCallback.onResult(true);
            }
        };
        OneSignal.notValidOrDuplicated(context, jsonPayload, callback);
    }

    @NonNull
    static JSONArray newJsonArray(JSONObject jsonObject) {
        return new JSONArray().put((Object)jsonObject);
    }

    static JSONObject getCustomJSONObject(JSONObject jsonObject) throws JSONException {
        return new JSONObject(jsonObject.optString("custom"));
    }

    static boolean hasRemoteResource(Bundle bundle) {
        return NotificationBundleProcessor.isBuildKeyRemote(bundle, "licon") || NotificationBundleProcessor.isBuildKeyRemote(bundle, "bicon") || bundle.getString("bg_img", null) != null;
    }

    private static boolean isBuildKeyRemote(Bundle bundle, String key) {
        String value = bundle.getString(key, "").trim();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    static interface NotificationProcessingCallback {
        public void onResult(boolean var1);
    }

    static interface ProcessBundleReceiverCallback {
        public void onBundleProcessed(@Nullable ProcessedBundleResult var1);
    }

    static class ProcessedBundleResult {
        private boolean isOneSignalPayload;
        private boolean isDup;
        private boolean inAppPreviewShown;
        private boolean isWorkManagerProcessing;

        ProcessedBundleResult() {
        }

        boolean processed() {
            return !this.isOneSignalPayload || this.isDup || this.inAppPreviewShown || this.isWorkManagerProcessing;
        }

        void setOneSignalPayload(boolean oneSignalPayload) {
            this.isOneSignalPayload = oneSignalPayload;
        }

        boolean isDup() {
            return this.isDup;
        }

        void setDup(boolean dup) {
            this.isDup = dup;
        }

        public void setInAppPreviewShown(boolean inAppPreviewShown) {
            this.inAppPreviewShown = inAppPreviewShown;
        }

        public boolean isWorkManagerProcessing() {
            return this.isWorkManagerProcessing;
        }

        public void setWorkManagerProcessing(boolean workManagerProcessing) {
            this.isWorkManagerProcessing = workManagerProcessing;
        }
    }
}

