/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes.data;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.WorkerThread;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalDb;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import com.onesignal.influence.domain.OSInfluenceType;
import com.onesignal.outcomes.data.OSOutcomeEventsCache$WhenMappings;
import com.onesignal.outcomes.domain.OSCachedUniqueOutcome;
import com.onesignal.outcomes.domain.OSOutcomeEventParams;
import com.onesignal.outcomes.domain.OSOutcomeSource;
import com.onesignal.outcomes.domain.OSOutcomeSourceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0007J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0007J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$H\u0007J4\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010&H\u0002J$\u0010-\u001a\b\u0012\u0004\u0012\u00020.0$2\u0006\u0010/\u001a\u00020\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0$H\u0007J*\u00101\u001a\u0004\u0018\u00010&2\u0006\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u000eH\u0002J\u0010\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\"H\u0007J\u0018\u00106\u001a\u00020\u00122\u0010\u00107\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rJ\u0010\u00108\u001a\u00020\u00122\u0006\u00105\u001a\u00020\"H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00069"}, d2={"Lcom/onesignal/outcomes/data/OSOutcomeEventsCache;", "", "logger", "Lcom/onesignal/OSLogger;", "dbHelper", "Lcom/onesignal/OneSignalDb;", "preferences", "Lcom/onesignal/OSSharedPreferences;", "(Lcom/onesignal/OSLogger;Lcom/onesignal/OneSignalDb;Lcom/onesignal/OSSharedPreferences;)V", "isOutcomesV2ServiceEnabled", "", "()Z", "unattributedUniqueOutcomeEventsSentByChannel", "", "", "getUnattributedUniqueOutcomeEventsSentByChannel", "()Ljava/util/Set;", "addIdToListFromChannel", "", "cachedUniqueOutcomes", "", "Lcom/onesignal/outcomes/domain/OSCachedUniqueOutcome;", "channelIds", "Lorg/json/JSONArray;", "channel", "Lcom/onesignal/influence/domain/OSInfluenceChannel;", "addIdsToListFromSource", "sourceBody", "Lcom/onesignal/outcomes/domain/OSOutcomeSourceBody;", "cleanCachedUniqueOutcomeEventNotifications", "notificationTableName", "notificationIdColumnName", "deleteOldOutcomeEvent", "event", "Lcom/onesignal/outcomes/domain/OSOutcomeEventParams;", "getAllEventsToSend", "", "getIAMInfluenceSource", "Lcom/onesignal/outcomes/domain/OSOutcomeSource;", "iamInfluenceType", "Lcom/onesignal/influence/domain/OSInfluenceType;", "directSourceBody", "indirectSourceBody", "iamIds", "source", "getNotCachedUniqueInfluencesForOutcome", "Lcom/onesignal/influence/domain/OSInfluence;", "name", "influences", "getNotificationInfluenceSource", "notificationInfluenceType", "notificationIds", "saveOutcomeEvent", "eventParams", "saveUnattributedUniqueOutcomeEventsSentByChannel", "unattributedUniqueOutcomeEvents", "saveUniqueOutcomeEventParams", "onesignal_release"})
public final class OSOutcomeEventsCache {
    private final OSLogger logger;
    private final OneSignalDb dbHelper;
    private final OSSharedPreferences preferences;

    public final boolean isOutcomesV2ServiceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), this.preferences.getOutcomesV2KeyName(), false);
    }

    @Nullable
    public final Set<String> getUnattributedUniqueOutcomeEventsSentByChannel() {
        return this.preferences.getStringSet(this.preferences.getPreferencesName(), "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT", null);
    }

    public final void saveUnattributedUniqueOutcomeEventsSentByChannel(@Nullable Set<String> unattributedUniqueOutcomeEvents) {
        String string2 = this.preferences.getPreferencesName();
        Set<String> set = unattributedUniqueOutcomeEvents;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        this.preferences.saveStringSet(string2, "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT", set);
    }

    @WorkerThread
    public final synchronized void deleteOldOutcomeEvent(@NotNull OSOutcomeEventParams event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.dbHelper.delete("outcome", "timestamp = ?", new String[]{String.valueOf(event.getTimestamp())});
    }

    @WorkerThread
    public final synchronized void saveOutcomeEvent(@NotNull OSOutcomeEventParams eventParams) {
        Object object;
        JSONArray it;
        boolean bl;
        boolean bl2;
        Object object2;
        boolean bl3;
        boolean bl4;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)eventParams, (String)"eventParams");
        JSONArray notificationIds = new JSONArray();
        JSONArray iamIds = new JSONArray();
        OSInfluenceType notificationInfluenceType = OSInfluenceType.UNATTRIBUTED;
        OSInfluenceType iamInfluenceType = OSInfluenceType.UNATTRIBUTED;
        Object object4 = eventParams.getOutcomeSource();
        if (object4 != null && (object4 = ((OSOutcomeSource)object4).getDirectBody()) != null) {
            object3 = object4;
            bl4 = false;
            bl3 = false;
            Object directBody = object3;
            boolean bl5 = false;
            JSONArray jSONArray = ((OSOutcomeSourceBody)directBody).getNotificationIds();
            if (jSONArray != null) {
                object2 = jSONArray;
                bl2 = false;
                bl = false;
                it = object2;
                boolean bl6 = false;
                if (it.length() > 0) {
                    notificationInfluenceType = OSInfluenceType.DIRECT;
                    notificationIds = it;
                }
            }
            JSONArray jSONArray2 = ((OSOutcomeSourceBody)directBody).getInAppMessagesIds();
            if (jSONArray2 != null) {
                object2 = jSONArray2;
                bl2 = false;
                bl = false;
                it = object2;
                boolean bl7 = false;
                if (it.length() > 0) {
                    iamInfluenceType = OSInfluenceType.DIRECT;
                    iamIds = it;
                }
            }
        }
        if ((object = eventParams.getOutcomeSource()) != null && (object = ((OSOutcomeSource)object).getIndirectBody()) != null) {
            object3 = object;
            bl4 = false;
            bl3 = false;
            Object indirectBody = object3;
            boolean bl8 = false;
            JSONArray jSONArray = ((OSOutcomeSourceBody)indirectBody).getNotificationIds();
            if (jSONArray != null) {
                object2 = jSONArray;
                bl2 = false;
                bl = false;
                it = object2;
                boolean bl9 = false;
                if (it.length() > 0) {
                    notificationInfluenceType = OSInfluenceType.INDIRECT;
                    notificationIds = it;
                }
            }
            JSONArray jSONArray3 = ((OSOutcomeSourceBody)indirectBody).getInAppMessagesIds();
            if (jSONArray3 != null) {
                object2 = jSONArray3;
                bl2 = false;
                bl = false;
                it = object2;
                boolean bl10 = false;
                if (it.length() > 0) {
                    iamInfluenceType = OSInfluenceType.INDIRECT;
                    iamIds = it;
                }
            }
        }
        object3 = new ContentValues();
        bl4 = false;
        bl3 = false;
        Object $this$apply = object3;
        boolean bl11 = false;
        $this$apply.put("notification_ids", notificationIds.toString());
        $this$apply.put("iam_ids", iamIds.toString());
        object2 = notificationInfluenceType.toString();
        String string2 = "notification_influence_type";
        Object object5 = $this$apply;
        boolean bl12 = false;
        Object object6 = object2;
        if (object6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object6).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        object5.put(string2, string4);
        object2 = iamInfluenceType.toString();
        string2 = "iam_influence_type";
        object5 = $this$apply;
        bl12 = false;
        Object object7 = object2;
        if (object7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = ((String)object7).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        string4 = string5;
        object5.put(string2, string4);
        $this$apply.put("name", eventParams.getOutcomeId());
        $this$apply.put("weight", Float.valueOf(eventParams.getWeight()));
        $this$apply.put("timestamp", Long.valueOf(eventParams.getTimestamp()));
        bl4 = false;
        bl3 = false;
        Object values = object3;
        boolean bl13 = false;
        this.dbHelper.insert("outcome", null, (ContentValues)values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final synchronized List<OSOutcomeEventParams> getAllEventsToSend() {
        Cursor it;
        List events = new ArrayList();
        Cursor cursor = null;
        try {
            Cursor cursor2 = cursor = this.dbHelper.query("outcome", null, null, null, null, null, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            Cursor cursor3 = cursor2;
            boolean bl = false;
            boolean bl2 = false;
            Cursor $this$with = cursor3;
            boolean bl3 = false;
            if ($this$with.moveToFirst()) {
                do {
                    String string2;
                    String notificationIds;
                    String notificationInfluenceTypeString = $this$with.getString($this$with.getColumnIndex("notification_influence_type"));
                    OSInfluenceType notificationInfluenceType = OSInfluenceType.Companion.fromString(notificationInfluenceTypeString);
                    String iamInfluenceTypeString = $this$with.getString($this$with.getColumnIndex("iam_influence_type"));
                    OSInfluenceType iamInfluenceType = OSInfluenceType.Companion.fromString(iamInfluenceTypeString);
                    String string3 = $this$with.getString($this$with.getColumnIndex("notification_ids"));
                    if (string3 == null) {
                        string3 = notificationIds = "[]";
                    }
                    if ((string2 = $this$with.getString($this$with.getColumnIndex("iam_ids"))) == null) {
                        string2 = "[]";
                    }
                    String iamIds = string2;
                    String name = $this$with.getString($this$with.getColumnIndex("name"));
                    float weight = $this$with.getFloat($this$with.getColumnIndex("weight"));
                    long timestamp = $this$with.getLong($this$with.getColumnIndex("timestamp"));
                    try {
                        OSOutcomeSourceBody directSourceBody = new OSOutcomeSourceBody(null, null, 3, null);
                        OSOutcomeSourceBody indirectSourceBody = new OSOutcomeSourceBody(null, null, 3, null);
                        Object object = this.getNotificationInfluenceSource(notificationInfluenceType, directSourceBody, indirectSourceBody, notificationIds);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Object it2 = object;
                        boolean bl6 = false;
                        this.getIAMInfluenceSource(iamInfluenceType, directSourceBody, indirectSourceBody, iamIds, (OSOutcomeSource)it2);
                        Object object2 = object;
                        if (object2 == null) {
                            object2 = new OSOutcomeSource(null, null);
                        }
                        OSOutcomeSource source = object2;
                        String string4 = name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name");
                        object = new OSOutcomeEventParams(string4, source, weight, timestamp);
                        bl4 = false;
                        bl5 = false;
                        it2 = object;
                        boolean bl7 = false;
                        events.add(it2);
                    }
                    catch (JSONException e) {
                        this.logger.error("Generating JSONArray from notifications ids outcome:JSON Failed.", e);
                    }
                } while ($this$with.moveToNext());
            }
            cursor3 = cursor;
            bl = false;
            bl2 = false;
            it = cursor3;
            boolean bl8 = false;
        }
        catch (Throwable throwable) {
            Cursor cursor4 = cursor;
            if (cursor4 != null) {
                Cursor cursor5 = cursor4;
                boolean bl = false;
                boolean bl9 = false;
                Cursor it3 = cursor5;
                boolean bl10 = false;
                if (!it3.isClosed()) {
                    it3.close();
                }
            }
            throw throwable;
        }
        if (!it.isClosed()) {
            it.close();
        }
        return events;
    }

    private final OSOutcomeSource getNotificationInfluenceSource(OSInfluenceType notificationInfluenceType, OSOutcomeSourceBody directSourceBody, OSOutcomeSourceBody indirectSourceBody, String notificationIds) {
        OSOutcomeSource oSOutcomeSource;
        switch (OSOutcomeEventsCache$WhenMappings.$EnumSwitchMapping$0[notificationInfluenceType.ordinal()]) {
            case 1: {
                directSourceBody.setNotificationIds(new JSONArray(notificationIds));
                oSOutcomeSource = new OSOutcomeSource(directSourceBody, null);
                break;
            }
            case 2: {
                indirectSourceBody.setNotificationIds(new JSONArray(notificationIds));
                oSOutcomeSource = new OSOutcomeSource(null, indirectSourceBody);
                break;
            }
            default: {
                oSOutcomeSource = null;
            }
        }
        return oSOutcomeSource;
    }

    private final OSOutcomeSource getIAMInfluenceSource(OSInfluenceType iamInfluenceType, OSOutcomeSourceBody directSourceBody, OSOutcomeSourceBody indirectSourceBody, String iamIds, OSOutcomeSource source) {
        OSOutcomeSource oSOutcomeSource;
        switch (OSOutcomeEventsCache$WhenMappings.$EnumSwitchMapping$1[iamInfluenceType.ordinal()]) {
            case 1: {
                directSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
                oSOutcomeSource = source;
                if (oSOutcomeSource != null && (oSOutcomeSource = oSOutcomeSource.setDirectBody(directSourceBody)) != null) break;
                oSOutcomeSource = new OSOutcomeSource(directSourceBody, null);
                break;
            }
            case 2: {
                indirectSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
                oSOutcomeSource = source;
                if (oSOutcomeSource != null && (oSOutcomeSource = oSOutcomeSource.setIndirectBody(indirectSourceBody)) != null) break;
                oSOutcomeSource = new OSOutcomeSource(null, indirectSourceBody);
                break;
            }
            default: {
                oSOutcomeSource = source;
            }
        }
        return oSOutcomeSource;
    }

    /*
     * WARNING - void declaration
     */
    private final void addIdToListFromChannel(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, JSONArray channelIds, OSInfluenceChannel channel) {
        JSONArray jSONArray = channelIds;
        if (jSONArray != null) {
            JSONArray jSONArray2 = jSONArray;
            boolean bl = false;
            boolean bl2 = false;
            JSONArray it = jSONArray2;
            boolean bl3 = false;
            int n = 0;
            int n2 = it.length();
            while (n < n2) {
                void i;
                try {
                    String influenceId;
                    String string2 = influenceId = it.getString((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"influenceId");
                    cachedUniqueOutcomes.add(new OSCachedUniqueOutcome(string2, channel));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    private final void addIdsToListFromSource(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, OSOutcomeSourceBody sourceBody) {
        block0: {
            OSOutcomeSourceBody oSOutcomeSourceBody = sourceBody;
            if (oSOutcomeSourceBody == null) break block0;
            OSOutcomeSourceBody oSOutcomeSourceBody2 = oSOutcomeSourceBody;
            boolean bl = false;
            boolean bl2 = false;
            OSOutcomeSourceBody it = oSOutcomeSourceBody2;
            boolean bl3 = false;
            JSONArray iamIds = it.getInAppMessagesIds();
            JSONArray notificationIds = it.getNotificationIds();
            this.addIdToListFromChannel(cachedUniqueOutcomes, iamIds, OSInfluenceChannel.IAM);
            this.addIdToListFromChannel(cachedUniqueOutcomes, notificationIds, OSInfluenceChannel.NOTIFICATION);
        }
    }

    @WorkerThread
    public final synchronized void saveUniqueOutcomeEventParams(@NotNull OSOutcomeEventParams eventParams) {
        Intrinsics.checkParameterIsNotNull((Object)eventParams, (String)"eventParams");
        this.logger.debug("OneSignal saveUniqueOutcomeEventParams: " + eventParams);
        String outcomeName = eventParams.getOutcomeId();
        List cachedUniqueOutcomes = new ArrayList();
        OSOutcomeSource oSOutcomeSource = eventParams.getOutcomeSource();
        OSOutcomeSourceBody directBody = oSOutcomeSource != null ? oSOutcomeSource.getDirectBody() : null;
        OSOutcomeSource oSOutcomeSource2 = eventParams.getOutcomeSource();
        OSOutcomeSourceBody indirectBody = oSOutcomeSource2 != null ? oSOutcomeSource2.getIndirectBody() : null;
        this.addIdsToListFromSource(cachedUniqueOutcomes, directBody);
        this.addIdsToListFromSource(cachedUniqueOutcomes, indirectBody);
        for (OSCachedUniqueOutcome uniqueOutcome : cachedUniqueOutcomes) {
            ContentValues contentValues = new ContentValues();
            boolean bl = false;
            boolean bl2 = false;
            ContentValues $this$apply = contentValues;
            boolean bl3 = false;
            $this$apply.put("channel_influence_id", uniqueOutcome.getInfluenceId());
            $this$apply.put("channel_type", uniqueOutcome.getChannel().toString());
            $this$apply.put("name", outcomeName);
            bl = false;
            bl2 = false;
            ContentValues values = contentValues;
            boolean bl4 = false;
            this.dbHelper.insert("cached_unique_outcome", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public final synchronized List<OSInfluence> getNotCachedUniqueInfluencesForOutcome(@NotNull String name, @NotNull List<OSInfluence> influences) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(influences, (String)"influences");
        List uniqueInfluences = new ArrayList();
        Cursor cursor = null;
        try {
            for (OSInfluence influence : influences) {
                JSONArray influenceIds;
                JSONArray availableInfluenceIds = new JSONArray();
                if (influence.getIds() == null) {
                    continue;
                }
                int n = 0;
                int n2 = influenceIds.length();
                while (n < n2) {
                    void i;
                    String channelInfluenceId = influenceIds.getString((int)i);
                    OSInfluenceChannel channel = influence.getInfluenceChannel();
                    String[] columns = new String[]{};
                    String where = "channel_influence_id = ? AND channel_type = ? AND name = ?";
                    String[] args = new String[]{channelInfluenceId, channel.toString(), name};
                    Cursor cursor2 = cursor = this.dbHelper.query("cached_unique_outcome", columns, where, args, null, null, null, "1");
                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                    if (cursor2.getCount() == 0) {
                        availableInfluenceIds.put((Object)channelInfluenceId);
                    }
                    ++i;
                }
                if (availableInfluenceIds.length() <= 0) continue;
                OSInfluence i = influence.copy();
                n2 = 0;
                boolean bl = false;
                OSInfluence $this$apply = i;
                boolean bl2 = false;
                $this$apply.setIds(availableInfluenceIds);
                n2 = 0;
                bl = false;
                OSInfluence newInfluence = i;
                boolean bl3 = false;
                uniqueInfluences.add(newInfluence);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            Cursor cursor3 = cursor;
            if (cursor3 != null) {
                Cursor cursor4 = cursor3;
                boolean bl = false;
                boolean bl4 = false;
                Cursor it = cursor4;
                boolean bl5 = false;
                if (!it.isClosed()) {
                    it.close();
                }
            }
        }
        return uniqueInfluences;
    }

    @WorkerThread
    public final synchronized void cleanCachedUniqueOutcomeEventNotifications(@NotNull String notificationTableName, @NotNull String notificationIdColumnName) {
        Intrinsics.checkParameterIsNotNull((Object)notificationTableName, (String)"notificationTableName");
        Intrinsics.checkParameterIsNotNull((Object)notificationIdColumnName, (String)"notificationIdColumnName");
        StringBuilder stringBuilder = new StringBuilder().append("NOT EXISTS(SELECT NULL FROM ").append(notificationTableName).append(" n ").append("WHERE").append(" n.").append(notificationIdColumnName).append(" = ").append("channel_influence_id").append(" AND ").append("channel_type").append(" = \"");
        String string2 = OSInfluenceChannel.NOTIFICATION.toString();
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string5 = string4;
        String whereStr = stringBuilder2.append(string5).append("\")").toString();
        this.dbHelper.delete("cached_unique_outcome", whereStr, null);
    }

    public OSOutcomeEventsCache(@NotNull OSLogger logger, @NotNull OneSignalDb dbHelper, @NotNull OSSharedPreferences preferences) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)dbHelper, (String)"dbHelper");
        Intrinsics.checkParameterIsNotNull((Object)preferences, (String)"preferences");
        this.logger = logger;
        this.dbHelper = dbHelper;
        this.preferences = preferences;
    }
}

