/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import com.onesignal.UserStateEmail;
import com.onesignal.UserStateSecondaryChannelSynchronizer;
import java.util.ArrayList;
import org.json.JSONObject;

class UserStateEmailSynchronizer
extends UserStateSecondaryChannelSynchronizer {
    UserStateEmailSynchronizer() {
        super(OneSignalStateSynchronizer.UserStateSynchronizerType.EMAIL);
    }

    @Override
    protected UserState newUserState(String inPersistKey, boolean load) {
        return new UserStateEmail(inPersistKey, load);
    }

    @Override
    protected String getId() {
        return OneSignal.getEmailId();
    }

    @Override
    void saveChannelId(String id2) {
        OneSignal.saveEmailId(id2);
    }

    @Override
    void logoutChannel() {
        OneSignal.saveEmailId("");
        this.resetCurrentState();
        this.getToSyncUserState().removeFromSyncValues("identifier");
        ArrayList<String> keysToRemove = new ArrayList<String>();
        keysToRemove.add("email_auth_hash");
        keysToRemove.add("device_player_id");
        keysToRemove.add("external_user_id");
        this.getToSyncUserState().removeFromSyncValues(keysToRemove);
        this.getToSyncUserState().persistState();
        OneSignal.getEmailSubscriptionState().clearEmailAndId();
    }

    @Override
    protected String getChannelKey() {
        return "email";
    }

    @Override
    protected String getAuthHashKey() {
        return "email_auth_hash";
    }

    @Override
    protected int getDeviceType() {
        return 11;
    }

    @Override
    void fireUpdateSuccess(JSONObject result) {
        OneSignal.fireEmailUpdateSuccess();
    }

    @Override
    void fireUpdateFailure() {
        OneSignal.fireEmailUpdateFailure();
    }

    @Override
    void updateIdDependents(String id2) {
        OneSignal.updateEmailIdDependents(id2);
    }
}

