/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes.data;

import com.onesignal.OSLogger;
import com.onesignal.OneSignalApiResponseHandler;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.outcomes.data.OSOutcomeEventsCache;
import com.onesignal.outcomes.data.OutcomeEventsService;
import com.onesignal.outcomes.domain.OSOutcomeEventParams;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H&J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0016\u0010%\u001a\u00020\u000e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lcom/onesignal/outcomes/data/OSOutcomeEventsRepository;", "Lcom/onesignal/outcomes/domain/OSOutcomeEventsRepository;", "logger", "Lcom/onesignal/OSLogger;", "outcomeEventsCache", "Lcom/onesignal/outcomes/data/OSOutcomeEventsCache;", "outcomeEventsService", "Lcom/onesignal/outcomes/data/OutcomeEventsService;", "(Lcom/onesignal/OSLogger;Lcom/onesignal/outcomes/data/OSOutcomeEventsCache;Lcom/onesignal/outcomes/data/OutcomeEventsService;)V", "getLogger", "()Lcom/onesignal/OSLogger;", "getOutcomeEventsService", "()Lcom/onesignal/outcomes/data/OutcomeEventsService;", "cleanCachedUniqueOutcomeEventNotifications", "", "notificationTableName", "", "notificationIdColumnName", "getNotCachedUniqueOutcome", "", "Lcom/onesignal/influence/domain/OSInfluence;", "name", "influences", "getSavedOutcomeEvents", "Lcom/onesignal/outcomes/domain/OSOutcomeEventParams;", "getUnattributedUniqueOutcomeEventsSent", "", "removeEvent", "outcomeEvent", "requestMeasureOutcomeEvent", "appId", "deviceType", "", "event", "responseHandler", "Lcom/onesignal/OneSignalApiResponseHandler;", "saveOutcomeEvent", "saveUnattributedUniqueOutcomeEventsSent", "unattributedUniqueOutcomeEvents", "saveUniqueOutcomeNotifications", "eventParams", "onesignal_release"})
public abstract class OSOutcomeEventsRepository
implements com.onesignal.outcomes.domain.OSOutcomeEventsRepository {
    @NotNull
    private final OSLogger logger;
    private final OSOutcomeEventsCache outcomeEventsCache;
    @NotNull
    private final OutcomeEventsService outcomeEventsService;

    @Override
    public abstract void requestMeasureOutcomeEvent(@NotNull String var1, int var2, @NotNull OSOutcomeEventParams var3, @NotNull OneSignalApiResponseHandler var4);

    @Override
    @NotNull
    public List<OSOutcomeEventParams> getSavedOutcomeEvents() {
        return this.outcomeEventsCache.getAllEventsToSend();
    }

    @Override
    public void saveOutcomeEvent(@NotNull OSOutcomeEventParams event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.outcomeEventsCache.saveOutcomeEvent(event);
    }

    @Override
    public void removeEvent(@NotNull OSOutcomeEventParams outcomeEvent) {
        Intrinsics.checkParameterIsNotNull((Object)outcomeEvent, (String)"outcomeEvent");
        this.outcomeEventsCache.deleteOldOutcomeEvent(outcomeEvent);
    }

    @Override
    public void saveUniqueOutcomeNotifications(@NotNull OSOutcomeEventParams eventParams) {
        Intrinsics.checkParameterIsNotNull((Object)eventParams, (String)"eventParams");
        this.outcomeEventsCache.saveUniqueOutcomeEventParams(eventParams);
    }

    @Override
    @NotNull
    public List<OSInfluence> getNotCachedUniqueOutcome(@NotNull String name, @NotNull List<OSInfluence> influences) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(influences, (String)"influences");
        List<OSInfluence> influencesNotCached = this.outcomeEventsCache.getNotCachedUniqueInfluencesForOutcome(name, influences);
        this.logger.debug("OneSignal getNotCachedUniqueOutcome influences: " + influencesNotCached);
        return influencesNotCached;
    }

    @Override
    @Nullable
    public Set<String> getUnattributedUniqueOutcomeEventsSent() {
        Set<String> unattributedUniqueOutcomeEvents = this.outcomeEventsCache.getUnattributedUniqueOutcomeEventsSentByChannel();
        this.logger.debug("OneSignal getUnattributedUniqueOutcomeEventsSentByChannel: " + unattributedUniqueOutcomeEvents);
        return unattributedUniqueOutcomeEvents;
    }

    @Override
    public void saveUnattributedUniqueOutcomeEventsSent(@NotNull Set<String> unattributedUniqueOutcomeEvents) {
        Intrinsics.checkParameterIsNotNull(unattributedUniqueOutcomeEvents, (String)"unattributedUniqueOutcomeEvents");
        this.logger.debug("OneSignal save unattributedUniqueOutcomeEvents: " + unattributedUniqueOutcomeEvents);
        this.outcomeEventsCache.saveUnattributedUniqueOutcomeEventsSentByChannel(unattributedUniqueOutcomeEvents);
    }

    @Override
    public void cleanCachedUniqueOutcomeEventNotifications(@NotNull String notificationTableName, @NotNull String notificationIdColumnName) {
        Intrinsics.checkParameterIsNotNull((Object)notificationTableName, (String)"notificationTableName");
        Intrinsics.checkParameterIsNotNull((Object)notificationIdColumnName, (String)"notificationIdColumnName");
        this.outcomeEventsCache.cleanCachedUniqueOutcomeEventNotifications(notificationTableName, notificationIdColumnName);
    }

    @NotNull
    protected final OSLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final OutcomeEventsService getOutcomeEventsService() {
        return this.outcomeEventsService;
    }

    public OSOutcomeEventsRepository(@NotNull OSLogger logger, @NotNull OSOutcomeEventsCache outcomeEventsCache, @NotNull OutcomeEventsService outcomeEventsService) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)outcomeEventsCache, (String)"outcomeEventsCache");
        Intrinsics.checkParameterIsNotNull((Object)outcomeEventsService, (String)"outcomeEventsService");
        this.logger = logger;
        this.outcomeEventsCache = outcomeEventsCache;
        this.outcomeEventsService = outcomeEventsService;
    }
}

