/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;
import com.onesignal.R;

public class PermissionsActivity
extends Activity {
    private static final String TAG = PermissionsActivity.class.getCanonicalName();
    private static final int DELAY_TIME_CALLBACK_CALL = 500;
    private static final int REQUEST_LOCATION = 2;
    private static final int REQUEST_SETTINGS = 3;
    static boolean waiting;
    static boolean answered;
    static boolean fallbackToSettings;
    static boolean neverAskAgainClicked;
    private static ActivityLifecycleHandler.ActivityAvailableListener activityAvailableListener;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        OneSignal.initWithContext((Context)this);
        if (savedInstanceState != null && savedInstanceState.getBoolean("android:hasCurrentPermissionsRequest", false)) {
            waiting = true;
        } else {
            this.requestPermission();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (OneSignal.isInitDone()) {
            this.requestPermission();
        }
    }

    private void requestPermission() {
        if (Build.VERSION.SDK_INT < 23) {
            this.finish();
            this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
            return;
        }
        if (!waiting) {
            waiting = true;
            neverAskAgainClicked = !AndroidSupportV4Compat.ActivityCompat.shouldShowRequestPermissionRationale(this, LocationController.requestPermission);
            AndroidSupportV4Compat.ActivityCompat.requestPermissions(this, new String[]{LocationController.requestPermission}, 2);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, final @NonNull int[] grantResults) {
        ActivityLifecycleHandler activityLifecycleHandler;
        answered = true;
        waiting = false;
        if (requestCode == 2) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    boolean granted = grantResults.length > 0 && grantResults[0] == 0;
                    OneSignal.PromptActionResult result = granted ? OneSignal.PromptActionResult.PERMISSION_GRANTED : OneSignal.PromptActionResult.PERMISSION_DENIED;
                    LocationController.sendAndClearPromptHandlers(true, result);
                    if (granted) {
                        LocationController.startGetLocation();
                    } else {
                        PermissionsActivity.this.attemptToShowLocationPermissionSettings();
                        LocationController.fireFailedComplete();
                    }
                }
            }, 500L);
        }
        if ((activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler()) != null) {
            activityLifecycleHandler.removeActivityAvailableListener(TAG);
        }
        this.finish();
        this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
    }

    private void attemptToShowLocationPermissionSettings() {
        if (fallbackToSettings && neverAskAgainClicked && !AndroidSupportV4Compat.ActivityCompat.shouldShowRequestPermissionRationale(this, LocationController.requestPermission)) {
            this.showLocationPermissionSettings();
        }
    }

    private void showLocationPermissionSettings() {
        new AlertDialog.Builder((Context)OneSignal.getCurrentActivity()).setTitle(R.string.location_not_available_title).setMessage(R.string.location_not_available_open_settings_message).setPositiveButton(R.string.location_not_available_open_settings_option, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.parse((String)("package:" + PermissionsActivity.this.getPackageName())));
                PermissionsActivity.this.startActivity(intent);
                LocationController.sendAndClearPromptHandlers(true, OneSignal.PromptActionResult.PERMISSION_DENIED);
            }
        }).setNegativeButton(17039369, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LocationController.sendAndClearPromptHandlers(true, OneSignal.PromptActionResult.PERMISSION_DENIED);
            }
        }).show();
    }

    static void startPrompt(boolean fallbackCondition) {
        if (waiting || answered) {
            return;
        }
        fallbackToSettings = fallbackCondition;
        activityAvailableListener = new ActivityLifecycleHandler.ActivityAvailableListener(){

            @Override
            public void available(@NonNull Activity activity) {
                if (!activity.getClass().equals(PermissionsActivity.class)) {
                    Intent intent = new Intent((Context)activity, PermissionsActivity.class);
                    intent.setFlags(131072);
                    activity.startActivity(intent);
                    activity.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
                }
            }
        };
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.addActivityAvailableListener(TAG, activityAvailableListener);
        }
    }
}

