/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import com.onesignal.OSLogger;
import com.onesignal.OSRemoteParamController;
import com.onesignal.OneSignal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

class OSTaskController {
    static final String OS_PENDING_EXECUTOR = "OS_PENDING_EXECUTOR_";
    static final String GET_TAGS = "getTags()";
    static final String SET_EMAIL = "setEmail()";
    static final String LOGOUT_EMAIL = "logoutEmail()";
    static final String SYNC_HASHED_EMAIL = "syncHashedEmail()";
    static final String SET_EXTERNAL_USER_ID = "setExternalUserId()";
    static final String SET_SUBSCRIPTION = "setSubscription()";
    static final String PROMPT_LOCATION = "promptLocation()";
    static final String IDS_AVAILABLE = "idsAvailable()";
    static final String SEND_TAG = "sendTag()";
    static final String SEND_TAGS = "sendTags()";
    static final String SET_LOCATION_SHARED = "setLocationShared()";
    static final String SET_REQUIRES_USER_PRIVACY_CONSENT = "setRequiresUserPrivacyConsent()";
    static final String UNSUBSCRIBE_WHEN_NOTIFICATION_ARE_DISABLED = "unsubscribeWhenNotificationsAreDisabled()";
    static final String HANDLE_NOTIFICATION_OPEN = "handleNotificationOpen()";
    static final String CANCEL_GROUPED_NOTIFICATIONS = "cancelGroupedNotifications()";
    static final String PAUSE_IN_APP_MESSAGES = "pauseInAppMessages()";
    static final String APP_LOST_FOCUS = "onAppLostFocus()";
    static final String SEND_OUTCOME = "sendOutcome()";
    static final String SEND_UNIQUE_OUTCOME = "sendUniqueOutcome()";
    static final String SEND_OUTCOME_WITH_VALUE = "sendOutcomeWithValue()";
    static final HashSet<String> METHODS_AVAILABLE_FOR_DELAY = new HashSet<String>(Arrays.asList("getTags()", "setEmail()", "logoutEmail()", "syncHashedEmail()", "setExternalUserId()", "setSubscription()", "promptLocation()", "idsAvailable()", "sendTag()", "sendTags()", "setLocationShared()", "setRequiresUserPrivacyConsent()", "unsubscribeWhenNotificationsAreDisabled()", "handleNotificationOpen()", "onAppLostFocus()", "sendOutcome()", "sendUniqueOutcome()", "sendOutcomeWithValue()"));
    private final ConcurrentLinkedQueue<Runnable> taskQueueWaitingForInit = new ConcurrentLinkedQueue();
    private final AtomicLong lastTaskId = new AtomicLong();
    private ExecutorService pendingTaskExecutor;
    private final OSLogger logger;
    private final OSRemoteParamController paramController;

    OSTaskController(OSRemoteParamController paramController, OSLogger logger) {
        this.paramController = paramController;
        this.logger = logger;
    }

    boolean shouldQueueTaskForInit(String task) {
        return !this.paramController.isRemoteParamsCallDone() && METHODS_AVAILABLE_FOR_DELAY.contains(task);
    }

    boolean shouldRunTaskThroughQueue() {
        if (Thread.currentThread().getName().contains(OS_PENDING_EXECUTOR)) {
            return false;
        }
        if (OneSignal.isInitDone() && this.pendingTaskExecutor == null) {
            return false;
        }
        if (!OneSignal.isInitDone() && this.pendingTaskExecutor == null) {
            return true;
        }
        return !this.pendingTaskExecutor.isShutdown();
    }

    void addTaskToQueue(Runnable runnable) {
        this.addTaskToQueue(new PendingTaskRunnable(this, runnable));
    }

    private void addTaskToQueue(PendingTaskRunnable task) {
        task.taskId = this.lastTaskId.incrementAndGet();
        if (this.pendingTaskExecutor == null) {
            this.logger.debug("Adding a task to the pending queue with ID: " + task.taskId);
            this.taskQueueWaitingForInit.add(task);
        } else if (!this.pendingTaskExecutor.isShutdown()) {
            this.logger.debug("Executor is still running, add to the executor with ID: " + task.taskId);
            try {
                this.pendingTaskExecutor.submit(task);
            }
            catch (RejectedExecutionException e) {
                this.logger.info("Executor is shutdown, running task manually with ID: " + task.taskId);
                task.run();
                e.printStackTrace();
            }
        }
    }

    void startPendingTasks() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "startPendingTasks with task queue quantity: " + this.taskQueueWaitingForInit.size());
        if (!this.taskQueueWaitingForInit.isEmpty()) {
            this.pendingTaskExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(@NonNull Runnable runnable) {
                    Thread newThread = new Thread(runnable);
                    newThread.setName(OSTaskController.OS_PENDING_EXECUTOR + newThread.getId());
                    return newThread;
                }
            });
            while (!this.taskQueueWaitingForInit.isEmpty()) {
                this.pendingTaskExecutor.submit(this.taskQueueWaitingForInit.poll());
            }
        }
    }

    private void onTaskRan(long taskId) {
        if (this.lastTaskId.get() == taskId) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Last Pending Task has ran, shutting down");
            this.pendingTaskExecutor.shutdown();
        }
    }

    ConcurrentLinkedQueue<Runnable> getTaskQueueWaitingForInit() {
        return this.taskQueueWaitingForInit;
    }

    private static class PendingTaskRunnable
    implements Runnable {
        private OSTaskController controller;
        private Runnable innerTask;
        private long taskId;

        PendingTaskRunnable(OSTaskController controller, Runnable innerTask) {
            this.controller = controller;
            this.innerTask = innerTask;
        }

        @Override
        public void run() {
            this.innerTask.run();
            this.controller.onTaskRan(this.taskId);
        }

        public String toString() {
            return "PendingTaskRunnable{innerTask=" + this.innerTask + ", taskId=" + this.taskId + '}';
        }
    }
}

