/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.BadgeCountUpdater;
import com.onesignal.OSPermissionState;
import com.onesignal.OSPermissionStateChanges;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;

class OSPermissionChangedInternalObserver {
    OSPermissionChangedInternalObserver() {
    }

    void changed(OSPermissionState state) {
        OSPermissionChangedInternalObserver.handleInternalChanges(state);
        OSPermissionChangedInternalObserver.fireChangesToPublicObserver(state);
    }

    static void handleInternalChanges(OSPermissionState state) {
        if (!state.areNotificationsEnabled()) {
            BadgeCountUpdater.updateCount(0, OneSignal.appContext);
        }
        OneSignalStateSynchronizer.setPermission(OneSignal.areNotificationsEnabledForSubscribedState());
    }

    static void fireChangesToPublicObserver(OSPermissionState state) {
        OSPermissionStateChanges stateChanges = new OSPermissionStateChanges(OneSignal.lastPermissionState, (OSPermissionState)state.clone());
        boolean hasReceiver = OneSignal.getPermissionStateChangesObserver().notifyChange(stateChanges);
        if (hasReceiver) {
            OneSignal.lastPermissionState = (OSPermissionState)state.clone();
            OneSignal.lastPermissionState.persistAsFrom();
        }
    }
}

