/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessageRedisplayStats {
    private static final String DISPLAY_LIMIT = "limit";
    private static final String DISPLAY_DELAY = "delay";
    private long lastDisplayTime = -1L;
    private int displayQuantity = 0;
    private int displayLimit = 1;
    private long displayDelay = 0L;
    private boolean redisplayEnabled = false;

    OSInAppMessageRedisplayStats() {
    }

    OSInAppMessageRedisplayStats(int displayQuantity, long lastDisplayTime) {
        this.displayQuantity = displayQuantity;
        this.lastDisplayTime = lastDisplayTime;
    }

    OSInAppMessageRedisplayStats(JSONObject json) throws JSONException {
        this.redisplayEnabled = true;
        Object displayLimit = json.get(DISPLAY_LIMIT);
        Object displayDelay = json.get(DISPLAY_DELAY);
        if (displayLimit instanceof Integer) {
            this.displayLimit = (Integer)displayLimit;
        }
        if (displayDelay instanceof Long) {
            this.displayDelay = (Long)displayDelay;
        } else if (displayDelay instanceof Integer) {
            this.displayDelay = ((Integer)displayDelay).intValue();
        }
    }

    void setDisplayStats(OSInAppMessageRedisplayStats displayStats) {
        this.setLastDisplayTime(displayStats.getLastDisplayTime());
        this.setDisplayQuantity(displayStats.getDisplayQuantity());
    }

    long getLastDisplayTime() {
        return this.lastDisplayTime;
    }

    void setLastDisplayTime(long lastDisplayTime) {
        this.lastDisplayTime = lastDisplayTime;
    }

    void incrementDisplayQuantity() {
        ++this.displayQuantity;
    }

    int getDisplayQuantity() {
        return this.displayQuantity;
    }

    void setDisplayQuantity(int displayQuantity) {
        this.displayQuantity = displayQuantity;
    }

    int getDisplayLimit() {
        return this.displayLimit;
    }

    void setDisplayLimit(int displayLimit) {
        this.displayLimit = displayLimit;
    }

    long getDisplayDelay() {
        return this.displayDelay;
    }

    void setDisplayDelay(long displayDelay) {
        this.displayDelay = displayDelay;
    }

    boolean shouldDisplayAgain() {
        return this.displayQuantity < this.displayLimit;
    }

    boolean isDelayTimeSatisfied() {
        if (this.lastDisplayTime < 0L) {
            return true;
        }
        long currentTimeInSeconds = OneSignal.getTime().getCurrentTimeMillis() / 1000L;
        long diffInSeconds = currentTimeInSeconds - this.lastDisplayTime;
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OSInAppMessage lastDisplayTime: " + this.lastDisplayTime + " currentTimeInSeconds: " + currentTimeInSeconds + " diffInSeconds: " + diffInSeconds + " displayDelay: " + this.displayDelay);
        return diffInSeconds >= this.displayDelay;
    }

    public boolean isRedisplayEnabled() {
        return this.redisplayEnabled;
    }

    JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put(DISPLAY_LIMIT, this.displayLimit);
            json.put(DISPLAY_DELAY, this.displayDelay);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json;
    }

    public String toString() {
        return "OSInAppMessageDisplayStats{lastDisplayTime=" + this.lastDisplayTime + ", displayQuantity=" + this.displayQuantity + ", displayLimit=" + this.displayLimit + ", displayDelay=" + this.displayDelay + '}';
    }
}

