/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.Handler;
import android.os.HandlerThread;
import com.onesignal.JSONUtils;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UserStateSynchronizer {
    protected final Object syncLock = new Object(){};
    private AtomicBoolean runningSyncUserState = new AtomicBoolean();
    HashMap<Integer, NetworkHandlerThread> networkHandlerThreads = new HashMap();
    private final Object networkHandlerSyncLock = new Object(){};
    protected boolean nextSyncIsSession = false;
    protected boolean waitingForSessionResponse = false;
    protected UserState currentUserState;
    protected UserState toSyncUserState;

    UserStateSynchronizer() {
    }

    abstract boolean getSubscribed();

    String getRegistrationId() {
        return this.getToSyncUserState().syncValues.optString("identifier", null);
    }

    abstract GetTagsResult getTags(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        Object object = this.syncLock;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(cur, changedTo, baseOutput, includeFields);
        }
    }

    protected synchronized UserState getToSyncUserState() {
        if (this.toSyncUserState == null) {
            this.toSyncUserState = this.newUserState("TOSYNC_STATE", true);
        }
        return this.toSyncUserState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initUserState() {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.currentUserState == null) {
                this.currentUserState = this.newUserState("CURRENT_STATE", true);
            }
        }
        this.getToSyncUserState();
    }

    protected abstract UserState newUserState(String var1, boolean var2);

    void clearLocation() {
        this.getToSyncUserState().clearLocation();
        this.getToSyncUserState().persistState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean persist() {
        if (this.toSyncUserState != null) {
            Object object = this.syncLock;
            synchronized (object) {
                boolean unSynced = this.currentUserState.generateJsonDiff(this.toSyncUserState, this.isSessionCall()) != null;
                this.toSyncUserState.persistState();
                return unSynced;
            }
        }
        return false;
    }

    protected abstract String getId();

    private boolean isSessionCall() {
        return this.nextSyncIsSession && !this.waitingForSessionResponse;
    }

    private boolean syncEmailLogout() {
        return this.getToSyncUserState().dependValues.optBoolean("logoutEmail", false);
    }

    synchronized void syncUserState(boolean fromSyncService) {
        this.runningSyncUserState.set(true);
        this.internalSyncUserState(fromSyncService);
        this.runningSyncUserState.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSyncUserState(boolean fromSyncService) {
        JSONObject dependDiff;
        JSONObject jsonBody;
        String userId = this.getId();
        if (this.syncEmailLogout() && userId != null) {
            this.doEmailLogout(userId);
            return;
        }
        if (this.currentUserState == null) {
            this.initUserState();
        }
        boolean isSessionCall = this.isSessionCall();
        Object object = this.syncLock;
        synchronized (object) {
            jsonBody = this.currentUserState.generateJsonDiff(this.getToSyncUserState(), isSessionCall);
            dependDiff = this.generateJsonDiff(this.currentUserState.dependValues, this.getToSyncUserState().dependValues, null, null);
            if (jsonBody == null) {
                this.currentUserState.persistStateAfterSync(dependDiff, null);
                return;
            }
            this.getToSyncUserState().persistState();
        }
        if (!isSessionCall || fromSyncService) {
            this.doPutSync(userId, jsonBody, dependDiff);
        } else {
            this.doCreateOrNewSession(userId, jsonBody, dependDiff);
        }
    }

    private void doEmailLogout(String userId) {
        String urlStr = "players/" + userId + "/email_logout";
        JSONObject jsonBody = new JSONObject();
        try {
            JSONObject syncValues;
            JSONObject dependValues = this.currentUserState.dependValues;
            if (dependValues.has("email_auth_hash")) {
                jsonBody.put("email_auth_hash", (Object)dependValues.optString("email_auth_hash"));
            }
            if ((syncValues = this.currentUserState.syncValues).has("parent_player_id")) {
                jsonBody.put("parent_player_id", (Object)syncValues.optString("parent_player_id"));
            }
            jsonBody.put("app_id", (Object)syncValues.optString("app_id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "already logged out of email")) {
                    UserStateSynchronizer.this.logoutEmailSyncSuccess();
                    return;
                }
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                    UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                } else {
                    UserStateSynchronizer.this.handleNetworkFailure();
                }
            }

            @Override
            void onSuccess(String response) {
                UserStateSynchronizer.this.logoutEmailSyncSuccess();
            }
        });
    }

    private void logoutEmailSyncSuccess() {
        this.getToSyncUserState().dependValues.remove("logoutEmail");
        this.toSyncUserState.dependValues.remove("email_auth_hash");
        this.toSyncUserState.syncValues.remove("parent_player_id");
        this.toSyncUserState.persistState();
        this.currentUserState.dependValues.remove("email_auth_hash");
        this.currentUserState.syncValues.remove("parent_player_id");
        String emailLoggedOut = this.currentUserState.syncValues.optString("email");
        this.currentUserState.syncValues.remove("email");
        OneSignalStateSynchronizer.setSyncAsNewSessionForEmail();
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device successfully logged out of email: " + emailLoggedOut);
        OneSignal.handleSuccessfulEmailLogout();
    }

    private void doPutSync(String userId, final JSONObject jsonBody, final JSONObject dependDiff) {
        if (userId == null) {
            return;
        }
        OneSignalRestClient.putSync("players/" + userId, jsonBody, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "No user with this id found")) {
                    UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                } else {
                    UserStateSynchronizer.this.handleNetworkFailure();
                }
            }

            @Override
            void onSuccess(String response) {
                UserStateSynchronizer.this.currentUserState.persistStateAfterSync(dependDiff, jsonBody);
                UserStateSynchronizer.this.onSuccessfulSync(jsonBody);
            }
        });
    }

    private void doCreateOrNewSession(final String userId, final JSONObject jsonBody, final JSONObject dependDiff) {
        String urlStr = userId == null ? "players" : "players/" + userId + "/on_session";
        this.waitingForSessionResponse = true;
        this.addOnSessionOrCreateExtras(jsonBody);
        OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                UserStateSynchronizer.this.waitingForSessionResponse = false;
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                    UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                } else {
                    UserStateSynchronizer.this.handleNetworkFailure();
                }
            }

            @Override
            void onSuccess(String response) {
                UserStateSynchronizer.this.waitingForSessionResponse = false;
                UserStateSynchronizer.this.nextSyncIsSession = false;
                UserStateSynchronizer.this.currentUserState.persistStateAfterSync(dependDiff, jsonBody);
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    if (jsonResponse.has("id")) {
                        String newUserId = jsonResponse.optString("id");
                        UserStateSynchronizer.this.updateIdDependents(newUserId);
                        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, UserId = " + newUserId);
                    } else {
                        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "session sent, UserId = " + userId);
                    }
                    OneSignal.updateOnSessionDependents();
                    UserStateSynchronizer.this.onSuccessfulSync(jsonBody);
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "ERROR parsing on_session or create JSON Response.", t);
                }
            }
        });
    }

    protected abstract void onSuccessfulSync(JSONObject var1);

    private void handleNetworkFailure() {
        boolean retried = this.getNetworkHandlerThread(0).doRetry();
        if (retried) {
            return;
        }
        JSONObject jsonBody = this.currentUserState.generateJsonDiff(this.toSyncUserState, false);
        if (jsonBody != null) {
            this.fireEventsForUpdateFailure(jsonBody);
        }
        if (this.getToSyncUserState().dependValues.optBoolean("logoutEmail", false)) {
            OneSignal.handleFailedEmailLogout();
        }
    }

    protected abstract void fireEventsForUpdateFailure(JSONObject var1);

    protected abstract void addOnSessionOrCreateExtras(JSONObject var1);

    private boolean response400WithErrorsContaining(int statusCode, String response, String contains) {
        if (statusCode == 400 && response != null) {
            try {
                JSONObject responseJson = new JSONObject(response);
                return responseJson.has("errors") && responseJson.optString("errors").contains(contains);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkHandlerThread getNetworkHandlerThread(Integer type) {
        Object object = this.networkHandlerSyncLock;
        synchronized (object) {
            if (!this.networkHandlerThreads.containsKey(type)) {
                this.networkHandlerThreads.put(type, new NetworkHandlerThread(type));
            }
            return this.networkHandlerThreads.get(type);
        }
    }

    protected UserState getUserStateForModification() {
        if (this.toSyncUserState == null) {
            this.toSyncUserState = this.currentUserState.deepClone("TOSYNC_STATE");
        }
        this.scheduleSyncToServer();
        return this.toSyncUserState;
    }

    protected abstract void scheduleSyncToServer();

    void updateDeviceInfo(JSONObject deviceInfo) {
        JSONObject toSync = this.getUserStateForModification().syncValues;
        this.generateJsonDiff(toSync, deviceInfo, toSync, null);
    }

    abstract void updateState(JSONObject var1);

    void setSyncAsNewSession() {
        this.nextSyncIsSession = true;
    }

    void sendTags(JSONObject tags) {
        JSONObject userStateTags = this.getUserStateForModification().syncValues;
        this.generateJsonDiff(userStateTags, tags, userStateTags, null);
    }

    void syncHashedEmail(JSONObject emailFields) {
        JSONObject syncValues = this.getUserStateForModification().syncValues;
        this.generateJsonDiff(syncValues, emailFields, syncValues, null);
    }

    abstract void setSubscription(boolean var1);

    private void handlePlayerDeletedFromServer() {
        OneSignal.handleSuccessfulEmailLogout();
        this.resetCurrentState();
        this.nextSyncIsSession = true;
        this.scheduleSyncToServer();
    }

    void resetCurrentState() {
        this.currentUserState.syncValues = new JSONObject();
        this.currentUserState.persistState();
    }

    public abstract boolean getUserSubscribePreference();

    public abstract void setPermission(boolean var1);

    void updateLocation(LocationGMS.LocationPoint point) {
        UserState userState = this.getUserStateForModification();
        userState.setLocation(point);
    }

    abstract void updateIdDependents(String var1);

    abstract void logoutEmail();

    class NetworkHandlerThread
    extends HandlerThread {
        protected static final int NETWORK_HANDLER_USERSTATE = 0;
        int mType;
        Handler mHandler;
        static final int MAX_RETRIES = 3;
        static final int NETWORK_CALL_DELAY_TO_BUFFER_MS = 5000;
        int currentRetry;

        NetworkHandlerThread(int type) {
            super("OSH_NetworkHandlerThread");
            this.mHandler = null;
            this.mType = type;
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runNewJobDelayed() {
            Handler handler = this.mHandler;
            synchronized (handler) {
                this.currentRetry = 0;
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler.postDelayed(this.getNewRunnable(), 5000L);
            }
        }

        private Runnable getNewRunnable() {
            switch (this.mType) {
                case 0: {
                    return new Runnable(){

                        @Override
                        public void run() {
                            if (!UserStateSynchronizer.this.runningSyncUserState.get()) {
                                UserStateSynchronizer.this.syncUserState(false);
                            }
                        }
                    };
                }
            }
            return null;
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doRetry() {
            Handler handler = this.mHandler;
            synchronized (handler) {
                boolean doRetry = this.currentRetry < 3;
                boolean futureSync = this.mHandler.hasMessages(0);
                if (doRetry && !futureSync) {
                    ++this.currentRetry;
                    this.mHandler.postDelayed(this.getNewRunnable(), (long)(this.currentRetry * 15000));
                }
                return this.mHandler.hasMessages(0);
            }
        }
    }

    static class GetTagsResult {
        boolean serverSuccess;
        JSONObject result;

        GetTagsResult(boolean serverSuccess, JSONObject result) {
            this.serverSuccess = serverSuccess;
            this.result = result;
        }
    }
}

