/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.JSONUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import com.onesignal.UserState;
import com.onesignal.UserStatePush;
import com.onesignal.UserStateSynchronizer;
import org.json.JSONException;
import org.json.JSONObject;

class UserStatePushSynchronizer
extends UserStateSynchronizer {
    private static boolean serverSuccess;

    UserStatePushSynchronizer() {
    }

    @Override
    protected UserState newUserState(String inPersistKey, boolean load) {
        return new UserStatePush(inPersistKey, load);
    }

    @Override
    boolean getSubscribed() {
        return this.getToSyncUserState().isSubscribed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        if (fromServer) {
            String userId = OneSignal.getUserId();
            String appId = OneSignal.getSavedAppId();
            OneSignalRestClient.getSync("players/" + userId + "?app_id=" + appId, new OneSignalRestClient.ResponseHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void onSuccess(String responseStr) {
                    block5: {
                        serverSuccess = true;
                        try {
                            JSONObject lastGetTagsResponse = new JSONObject(responseStr);
                            if (!lastGetTagsResponse.has("tags")) break block5;
                            Object object = UserStatePushSynchronizer.this.syncLock;
                            synchronized (object) {
                                JSONObject dependDiff = UserStatePushSynchronizer.this.generateJsonDiff(UserStatePushSynchronizer.this.currentUserState.syncValues.optJSONObject("tags"), UserStatePushSynchronizer.this.toSyncUserState.syncValues.optJSONObject("tags"), null, null);
                                UserStatePushSynchronizer.this.currentUserState.syncValues.put("tags", (Object)lastGetTagsResponse.optJSONObject("tags"));
                                UserStatePushSynchronizer.this.currentUserState.persistState();
                                UserStatePushSynchronizer.this.toSyncUserState.mergeTags(lastGetTagsResponse, dependDiff);
                                UserStatePushSynchronizer.this.toSyncUserState.persistState();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        Object object = this.syncLock;
        synchronized (object) {
            return new UserStateSynchronizer.GetTagsResult(serverSuccess, JSONUtils.getJSONObjectWithoutBlankValues(this.getToSyncUserState().syncValues, "tags"));
        }
    }

    @Override
    protected void scheduleSyncToServer() {
        this.getNetworkHandlerThread(0).runNewJob();
    }

    @Override
    void updateState(JSONObject pushState) {
        try {
            JSONObject syncUpdate = new JSONObject();
            syncUpdate.putOpt("identifier", (Object)pushState.optString("identifier", null));
            if (pushState.has("device_type")) {
                syncUpdate.put("device_type", pushState.optInt("device_type"));
            }
            syncUpdate.putOpt("parent_player_id", (Object)pushState.optString("parent_player_id", null));
            JSONObject toSync = this.getUserStateForModification().syncValues;
            this.generateJsonDiff(toSync, syncUpdate, toSync, null);
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
        try {
            JSONObject dependUpdate = new JSONObject();
            if (pushState.has("subscribableStatus")) {
                dependUpdate.put("subscribableStatus", pushState.optInt("subscribableStatus"));
            }
            if (pushState.has("androidPermission")) {
                dependUpdate.put("androidPermission", pushState.optBoolean("androidPermission"));
            }
            JSONObject dependValues = this.getUserStateForModification().dependValues;
            this.generateJsonDiff(dependValues, dependUpdate, dependValues, null);
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    void setEmail(String email) {
        try {
            JSONObject emailJSON = new JSONObject();
            emailJSON.put("email", (Object)email);
            JSONObject syncValues = this.getUserStateForModification().syncValues;
            this.generateJsonDiff(syncValues, emailJSON, syncValues, null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    void setSubscription(boolean enable) {
        try {
            this.getUserStateForModification().dependValues.put("userSubscribePref", enable);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getUserSubscribePreference() {
        return this.getToSyncUserState().dependValues.optBoolean("userSubscribePref", true);
    }

    @Override
    public void setPermission(boolean enable) {
        try {
            this.getUserStateForModification().dependValues.put("androidPermission", enable);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getId() {
        return OneSignal.getUserId();
    }

    @Override
    void updateIdDependents(String id2) {
        OneSignal.updateUserIdDependents(id2);
    }

    @Override
    protected void addOnSessionOrCreateExtras(JSONObject jsonBody) {
    }

    @Override
    void logoutEmail() {
        try {
            this.getUserStateForModification().dependValues.put("logoutEmail", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void fireEventsForUpdateFailure(JSONObject jsonFields) {
        if (jsonFields.has("email")) {
            OneSignal.fireEmailUpdateFailure();
        }
    }

    @Override
    protected void onSuccessfulSync(JSONObject jsonFields) {
        if (jsonFields.has("email")) {
            OneSignal.fireEmailUpdateSuccess();
        }
    }
}

