/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;

public class SyncService
extends Service {
    static final int TASK_APP_STARTUP = 0;
    static final int TASK_SYNC = 1;
    private static boolean startedFromActivity;

    private static void checkOnFocusSync() {
        long unsentTime = OneSignal.GetUnsentActiveTime();
        if (unsentTime < 60L) {
            return;
        }
        OneSignal.sendOnFocus(unsentTime, true);
    }

    private void doSync() {
        if (startedFromActivity) {
            this.doForegroundSync();
        } else {
            this.doBackgroundSync();
        }
    }

    private void doForegroundSync() {
        LocationGMS.getLocation((Context)this, false, new LocationGMS.LocationHandler(){

            @Override
            public void complete(LocationGMS.LocationPoint point) {
                if (point != null) {
                    OneSignalStateSynchronizer.updateLocation(point);
                }
            }
        });
    }

    private void doBackgroundSync() {
        OneSignal.appContext = this.getApplicationContext();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (OneSignal.getUserId() == null) {
                    SyncService.this.stopSelf();
                    return;
                }
                OneSignal.appId = OneSignal.getSavedAppId();
                OneSignalStateSynchronizer.initUserState(OneSignal.appContext);
                LocationGMS.getLocation(OneSignal.appContext, false, new LocationGMS.LocationHandler(){

                    @Override
                    public void complete(LocationGMS.LocationPoint point) {
                        if (point != null) {
                            OneSignalStateSynchronizer.updateLocation(point);
                        }
                        OneSignalStateSynchronizer.syncUserState(true);
                        SyncService.checkOnFocusSync();
                        SyncService.this.stopSelf();
                    }
                });
            }
        }, "OS_SYNCSRV_BG_SYNC").start();
    }

    public void onCreate() {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int task = intent != null ? intent.getIntExtra("task", 0) : 1;
        if (task == 0) {
            startedFromActivity = true;
        } else if (task == 1) {
            this.doSync();
        }
        return startedFromActivity ? 1 : 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        SyncService.onTaskRemoved(this);
    }

    static void onTaskRemoved(Service service) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Starting SyncService:onTaskRemoved.");
        ActivityLifecycleHandler.focusHandlerThread.stopScheduledRunnable();
        boolean scheduleServerRestart = OneSignalStateSynchronizer.stopAndPersist();
        scheduleServerRestart = OneSignal.onAppLostFocus(true) || scheduleServerRestart;
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Completed SyncService:onTaskRemoved.");
        service.stopSelf();
        if (scheduleServerRestart) {
            SyncService.scheduleServiceSyncTask((Context)service, System.currentTimeMillis() + 10000L);
        } else {
            LocationGMS.scheduleUpdate((Context)service);
        }
    }

    static void scheduleServiceSyncTask(Context context, long atTime) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleServiceSyncTask:atTime: " + atTime);
        Intent intent = new Intent(context, SyncService.class);
        intent.putExtra("task", 1);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        alarm.set(0, atTime, pendingIntent);
    }
}

