/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;

public class GcmBroadcastReceiver
extends WakefulBroadcastReceiver {
    private static final String GCM_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_TYPE = "gcm";

    private static boolean isGcmMessage(Intent intent) {
        if (GCM_RECEIVE.equals(intent.getAction())) {
            String messageType = intent.getStringExtra("message_type");
            return messageType == null || GCM_TYPE.equals(messageType);
        }
        return false;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || "google.com/iid".equals(bundle.getString("from"))) {
            return;
        }
        GcmBroadcastReceiver.processOrderBroadcast(context, intent, bundle);
        this.setResultCode(-1);
    }

    private static void processOrderBroadcast(Context context, Intent intent, Bundle bundle) {
        if (!GcmBroadcastReceiver.isGcmMessage(intent)) {
            return;
        }
        if (NotificationBundleProcessor.processBundle(context, bundle)) {
            return;
        }
        Intent intentForService = new Intent();
        intentForService.putExtra("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
        intentForService.setComponent(new ComponentName(context.getPackageName(), GcmIntentService.class.getName()));
        GcmBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
    }
}

