/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Base64;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.google.firebase.messaging.FirebaseMessaging;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorAbstractGoogle;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;

class PushRegistratorFCM
extends PushRegistratorAbstractGoogle {
    private static final String FCM_DEFAULT_PROJECT_ID = "onesignal-shared-public";
    private static final String FCM_DEFAULT_APP_ID = "1:754795614042:android:c682b8144a8dd52bc1ad63";
    private static final String FCM_DEFAULT_API_KEY_BASE64 = "QUl6YVN5QW5UTG41LV80TWMyYTJQLWRLVWVFLWFCdGd5Q3JqbFlV";
    private static final String FCM_APP_NAME = "ONESIGNAL_SDK_FCM_APP_NAME";
    private FirebaseApp firebaseApp;

    PushRegistratorFCM() {
    }

    static void disableFirebaseInstanceIdService(Context context) {
        String senderId = OSUtils.getResourceString(context, "gcm_defaultSenderId", null);
        int componentState = senderId == null ? 2 : 1;
        PackageManager pm = context.getPackageManager();
        try {
            ComponentName componentName = new ComponentName(context, FirebaseInstanceIdService.class);
            pm.setComponentEnabledSetting(componentName, componentState, 1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    String getProviderName() {
        return "FCM";
    }

    @Override
    @WorkerThread
    String getToken(String senderId) throws ExecutionException, InterruptedException, IOException {
        this.initFirebaseApp(senderId);
        try {
            return this.getTokenWithClassFirebaseMessaging();
        }
        catch (Error e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "FirebaseMessaging.getToken not found, attempting to use FirebaseInstanceId.getToken");
            return this.getTokenWithClassFirebaseInstanceId(senderId);
        }
    }

    @WorkerThread
    private String getTokenWithClassFirebaseInstanceId(String senderId) throws IOException {
        FirebaseInstanceId instanceId = FirebaseInstanceId.getInstance((FirebaseApp)this.firebaseApp);
        return instanceId.getToken(senderId, "FCM");
    }

    @WorkerThread
    private String getTokenWithClassFirebaseMessaging() throws ExecutionException, InterruptedException {
        ReflectiveOperationException exception;
        FirebaseMessaging firebaseMessagingInstance = (FirebaseMessaging)this.firebaseApp.get(FirebaseMessaging.class);
        if (firebaseMessagingInstance == null) {
            throw new Error("firebaseMessagingInstance is null");
        }
        try {
            Method getTokenMethod = firebaseMessagingInstance.getClass().getMethod("getToken", new Class[0]);
            Object tokenTask = getTokenMethod.invoke((Object)firebaseMessagingInstance, new Object[0]);
            return (String)Tasks.await((Task)((Task)tokenTask));
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        throw new Error("Reflection error on FirebaseMessaging.getToken()", exception);
    }

    private void initFirebaseApp(String senderId) {
        if (this.firebaseApp != null) {
            return;
        }
        FirebaseOptions firebaseOptions = new FirebaseOptions.Builder().setGcmSenderId(senderId).setApplicationId(PushRegistratorFCM.getAppId()).setApiKey(PushRegistratorFCM.getApiKey()).setProjectId(PushRegistratorFCM.getProjectId()).build();
        this.firebaseApp = FirebaseApp.initializeApp((Context)OneSignal.appContext, (FirebaseOptions)firebaseOptions, (String)FCM_APP_NAME);
    }

    @NonNull
    private static String getAppId() {
        if (OneSignal.remoteParams.fcmParams.appId != null) {
            return OneSignal.remoteParams.fcmParams.appId;
        }
        return FCM_DEFAULT_APP_ID;
    }

    @NonNull
    private static String getApiKey() {
        if (OneSignal.remoteParams.fcmParams.apiKey != null) {
            return OneSignal.remoteParams.fcmParams.apiKey;
        }
        return new String(Base64.decode((String)FCM_DEFAULT_API_KEY_BASE64, (int)0));
    }

    @NonNull
    private static String getProjectId() {
        if (OneSignal.remoteParams.fcmParams.projectId != null) {
            return OneSignal.remoteParams.fcmParams.projectId;
        }
        return FCM_DEFAULT_PROJECT_ID;
    }
}

