/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.view.ViewTreeObserver;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OneSignal;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ActivityLifecycleHandler
implements OSSystemConditionController.OSSystemConditionHandler {
    private static final Object SYNC_LOCK = new Object();
    private static final String FOCUS_LOST_WORKER_TAG = "FOCUS_LOST_WORKER_TAG";
    private static final Map<String, ActivityAvailableListener> sActivityAvailableListeners = new ConcurrentHashMap<String, ActivityAvailableListener>();
    private static final Map<String, OSSystemConditionController.OSSystemConditionObserver> sSystemConditionObservers = new ConcurrentHashMap<String, OSSystemConditionController.OSSystemConditionObserver>();
    private static final Map<String, KeyboardListener> sKeyboardListeners = new ConcurrentHashMap<String, KeyboardListener>();
    static FocusHandlerThread focusHandlerThread = new FocusHandlerThread();
    @SuppressLint(value={"StaticFieldLeak"})
    private Activity curActivity = null;
    private boolean nextResumeIsFirstActivity = false;

    ActivityLifecycleHandler() {
    }

    void onConfigurationChanged(Configuration newConfig, Activity activity) {
        if (this.curActivity != null && OSUtils.hasConfigChangeFlag(this.curActivity, 128)) {
            this.logOrientationChange(newConfig.orientation, activity);
            this.onOrientationChanged(activity);
        }
    }

    void onActivityCreated(Activity activity) {
    }

    void onActivityStarted(Activity activity) {
    }

    void onActivityResumed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityResumed: " + activity);
        this.setCurActivity(activity);
        this.logCurActivity();
        this.handleFocus();
    }

    void onActivityPaused(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityPaused: " + activity);
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        this.logCurActivity();
    }

    void onActivityStopped(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityStopped: " + activity);
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(activity);
        }
        this.logCurActivity();
    }

    void onActivityDestroyed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityDestroyed: " + activity);
        sKeyboardListeners.clear();
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        this.logCurActivity();
    }

    private void logCurActivity() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "curActivity is NOW: " + (this.curActivity != null ? "" + this.curActivity.getClass().getName() + ":" + this.curActivity : "null"));
    }

    private void logOrientationChange(int orientation, Activity activity) {
        if (orientation == 2) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: LANDSCAPE (" + orientation + ") on activity: " + activity);
        } else if (orientation == 1) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: PORTRAIT (" + orientation + ") on activity: " + activity);
        }
    }

    private void onOrientationChanged(Activity activity) {
        this.handleLostFocus();
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(activity);
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(this.curActivity);
        }
        ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
        for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
            KeyboardListener keyboardListener = new KeyboardListener(this, entry.getValue(), entry.getKey());
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(entry.getKey(), keyboardListener);
        }
        this.handleFocus();
    }

    void addSystemConditionObserver(String key, OSSystemConditionController.OSSystemConditionObserver systemConditionObserver) {
        if (this.curActivity != null) {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            KeyboardListener keyboardListener = new KeyboardListener(this, systemConditionObserver, key);
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(key, keyboardListener);
        }
        sSystemConditionObservers.put(key, systemConditionObserver);
    }

    @Override
    public void removeSystemConditionObserver(@NonNull String key, @NonNull KeyboardListener keyboardListener) {
        if (this.curActivity != null) {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            if (Build.VERSION.SDK_INT < 16) {
                treeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            } else {
                treeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            }
        }
        sKeyboardListeners.remove(key);
        sSystemConditionObservers.remove(key);
    }

    void addActivityAvailableListener(String key, ActivityAvailableListener activityAvailableListener) {
        sActivityAvailableListeners.put(key, activityAvailableListener);
        if (this.curActivity != null) {
            activityAvailableListener.available(this.curActivity);
        }
    }

    void removeActivityAvailableListener(String key) {
        sActivityAvailableListeners.remove(key);
    }

    public Activity getCurActivity() {
        return this.curActivity;
    }

    public void setCurActivity(Activity activity) {
        this.curActivity = activity;
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(this.curActivity);
        }
        try {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
                KeyboardListener keyboardListener = new KeyboardListener(this, entry.getValue(), entry.getKey());
                treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
                sKeyboardListeners.put(entry.getKey(), keyboardListener);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    void setNextResumeIsFirstActivity(boolean nextResumeIsFirstActivity) {
        this.nextResumeIsFirstActivity = nextResumeIsFirstActivity;
    }

    private void handleLostFocus() {
        focusHandlerThread.runRunnable(new AppFocusRunnable());
    }

    private void handleFocus() {
        if (focusHandlerThread.hasBackgrounded() || this.nextResumeIsFirstActivity) {
            this.setNextResumeIsFirstActivity(false);
            focusHandlerThread.resetBackgroundState();
            OneSignal.onAppFocus();
        } else {
            focusHandlerThread.stopScheduledRunnable();
        }
    }

    static class KeyboardListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final OSSystemConditionController.OSSystemConditionObserver observer;
        private final OSSystemConditionController.OSSystemConditionHandler systemConditionListener;
        private final String key;

        private KeyboardListener(OSSystemConditionController.OSSystemConditionHandler systemConditionListener, OSSystemConditionController.OSSystemConditionObserver observer, String key) {
            this.systemConditionListener = systemConditionListener;
            this.observer = observer;
            this.key = key;
        }

        public void onGlobalLayout() {
            boolean keyboardUp = OSViewUtils.isKeyboardUp(new WeakReference<Activity>(OneSignal.getCurrentActivity()));
            if (!keyboardUp) {
                this.systemConditionListener.removeSystemConditionObserver(this.key, this);
                this.observer.systemConditionChanged();
            }
        }
    }

    private static class AppFocusRunnable
    implements Runnable {
        private boolean backgrounded;
        private boolean completed;

        private AppFocusRunnable() {
        }

        @Override
        public void run() {
            if (OneSignal.getCurrentActivity() != null) {
                return;
            }
            this.backgrounded = true;
            for (Map.Entry entry : sActivityAvailableListeners.entrySet()) {
                ((ActivityAvailableListener)entry.getValue()).lostFocus();
            }
            OneSignal.onAppLostFocus();
            this.completed = true;
        }
    }

    static class FocusHandlerThread
    extends HandlerThread {
        private Handler mHandler;
        private AppFocusRunnable appFocusRunnable;

        FocusHandlerThread() {
            super("FocusHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        Looper getHandlerLooper() {
            return this.mHandler.getLooper();
        }

        void resetBackgroundState() {
            if (this.appFocusRunnable != null) {
                this.appFocusRunnable.backgrounded = false;
            }
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        void runRunnable(AppFocusRunnable runnable) {
            if (this.appFocusRunnable != null && this.appFocusRunnable.backgrounded && !this.appFocusRunnable.completed) {
                return;
            }
            this.appFocusRunnable = runnable;
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed((Runnable)runnable, 2000L);
        }

        boolean hasBackgrounded() {
            return this.appFocusRunnable != null && this.appFocusRunnable.backgrounded;
        }
    }

    static abstract class ActivityAvailableListener {
        ActivityAvailableListener() {
        }

        void available(@NonNull Activity activity) {
        }

        void stopped(@NonNull Activity activity) {
        }

        void lostFocus() {
        }
    }
}

