/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalAPIClient;
import com.onesignal.OneSignalDb;
import com.onesignal.outcomes.OSOutcomeEventsCache;
import com.onesignal.outcomes.OSOutcomeEventsV1Repository;
import com.onesignal.outcomes.OSOutcomeEventsV1Service;
import com.onesignal.outcomes.OSOutcomeEventsV2Repository;
import com.onesignal.outcomes.OSOutcomeEventsV2Service;
import com.onesignal.outcomes.domain.OSOutcomeEventsRepository;

public class OSOutcomeEventsFactory {
    private final OSLogger logger;
    private final OSOutcomeEventsCache outcomeEventsCache;
    private final OneSignalAPIClient apiClient;
    private OSOutcomeEventsRepository repository;

    public OSOutcomeEventsFactory(OSLogger logger, OneSignalAPIClient apiClient, OneSignalDb dbHelper, OSSharedPreferences preferences) {
        this.logger = logger;
        this.apiClient = apiClient;
        this.outcomeEventsCache = new OSOutcomeEventsCache(logger, dbHelper, preferences);
    }

    public OSOutcomeEventsRepository getRepository() {
        if (this.repository == null) {
            this.createRepository();
        } else {
            this.validateRepositoryVersion();
        }
        return this.repository;
    }

    private void validateRepositoryVersion() {
        if (!this.outcomeEventsCache.isOutcomesV2ServiceEnabled() && this.repository instanceof OSOutcomeEventsV1Repository) {
            return;
        }
        if (this.outcomeEventsCache.isOutcomesV2ServiceEnabled() && this.repository instanceof OSOutcomeEventsV2Repository) {
            return;
        }
        this.createRepository();
    }

    private void createRepository() {
        this.repository = this.outcomeEventsCache.isOutcomesV2ServiceEnabled() ? new OSOutcomeEventsV2Repository(this.logger, this.outcomeEventsCache, new OSOutcomeEventsV2Service(this.apiClient)) : new OSOutcomeEventsV1Repository(this.logger, this.outcomeEventsCache, new OSOutcomeEventsV1Service(this.apiClient));
    }
}

