/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.support.annotation.WorkerThread;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OSInAppMessageRepository;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.influence.model.OSInfluenceChannel;

class OneSignalCacheCleaner {
    private static final long NOTIFICATION_CACHE_DATA_LIFETIME = 604800L;
    private static final String OS_DELETE_CACHED_NOTIFICATIONS_THREAD = "OS_DELETE_CACHED_NOTIFICATIONS_THREAD";
    private static final String OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD = "OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD";

    OneSignalCacheCleaner() {
    }

    static void cleanOldCachedData(Context context) {
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        OneSignalCacheCleaner.cleanNotificationCache(dbHelper);
        OneSignalCacheCleaner.cleanCachedInAppMessages(dbHelper);
    }

    static synchronized void cleanNotificationCache(final OneSignalDbHelper writableDb) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OneSignalCacheCleaner.cleanCachedNotifications(writableDb);
                OneSignalCacheCleaner.cleanCachedUniqueOutcomeEventNotifications(writableDb);
            }
        }, OS_DELETE_CACHED_NOTIFICATIONS_THREAD).start();
    }

    @WorkerThread
    static synchronized void cleanCachedInAppMessages(final OneSignalDbHelper dbHelper) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OSInAppMessageRepository inAppMessageRepository = OSInAppMessageController.getController().getInAppMessageRepository(dbHelper);
                inAppMessageRepository.cleanCachedInAppMessages();
            }
        }, OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD).start();
    }

    private static void cleanCachedNotifications(OneSignalDbHelper writableDb) {
        String whereStr = "created_time < ?";
        String sevenDaysAgoInSeconds = String.valueOf(System.currentTimeMillis() / 1000L - 604800L);
        String[] whereArgs = new String[]{sevenDaysAgoInSeconds};
        writableDb.delete("notification", whereStr, whereArgs);
    }

    private static void cleanCachedUniqueOutcomeEventNotifications(OneSignalDbHelper writableDb) {
        String whereStr = "NOT EXISTS(SELECT NULL FROM notification n WHERE n.notification_id = channel_influence_id AND channel_type = \"" + OSInfluenceChannel.NOTIFICATION.toString().toLowerCase() + "\")";
        writableDb.delete("cached_unique_outcome", whereStr, null);
    }
}

