/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.BundleCompat;
import com.onesignal.GenerateNotification;
import com.onesignal.NotificationExtenderService;
import com.onesignal.NotificationGenerationJob;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OSReceiveReceiptController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationBundleProcessor {
    private static final String PUSH_ADDITIONAL_DATA_KEY = "a";
    public static final String PUSH_MINIFIED_BUTTONS_LIST = "o";
    public static final String PUSH_MINIFIED_BUTTON_ID = "i";
    public static final String PUSH_MINIFIED_BUTTON_TEXT = "n";
    public static final String PUSH_MINIFIED_BUTTON_ICON = "p";
    private static final String IAM_PREVIEW_KEY = "os_in_app_message_preview_id";
    static final String DEFAULT_ACTION = "__DEFAULT__";

    NotificationBundleProcessor() {
    }

    static void ProcessFromGCMIntentService(Context context, BundleCompat bundle, NotificationExtenderService.OverrideSettings overrideSettings) {
        OneSignal.setAppContext(context);
        try {
            String jsonStrPayload = bundle.getString("json_payload");
            if (jsonStrPayload == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "json_payload key is nonexistent from mBundle passed to ProcessFromGCMIntentService: " + bundle);
                return;
            }
            NotificationGenerationJob notifJob = new NotificationGenerationJob(context);
            notifJob.restoring = bundle.getBoolean("restoring", false);
            notifJob.shownTimeStamp = bundle.getLong("timestamp");
            notifJob.jsonPayload = new JSONObject(jsonStrPayload);
            boolean bl = notifJob.isInAppPreviewPush = NotificationBundleProcessor.inAppPreviewPushUUID(notifJob.jsonPayload) != null;
            if (!notifJob.restoring && !notifJob.isInAppPreviewPush && OneSignal.notValidOrDuplicated(context, notifJob.jsonPayload)) {
                return;
            }
            if (bundle.containsKey("android_notif_id")) {
                if (overrideSettings == null) {
                    overrideSettings = new NotificationExtenderService.OverrideSettings();
                }
                overrideSettings.androidNotificationId = bundle.getInt("android_notif_id");
            }
            notifJob.overrideSettings = overrideSettings;
            NotificationBundleProcessor.ProcessJobForDisplay(notifJob);
            if (notifJob.restoring) {
                OSUtils.sleep(100);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static int ProcessJobForDisplay(NotificationGenerationJob notifJob) {
        notifJob.showAsAlert = OneSignal.getInAppAlertNotificationEnabled() && OneSignal.isAppActive();
        NotificationBundleProcessor.processCollapseKey(notifJob);
        boolean doDisplay = NotificationBundleProcessor.shouldDisplayNotif(notifJob);
        if (doDisplay) {
            GenerateNotification.fromJsonPayload(notifJob);
        }
        if (!notifJob.restoring && !notifJob.isInAppPreviewPush) {
            NotificationBundleProcessor.processNotification(notifJob, false);
            try {
                JSONObject jsonObject = new JSONObject(notifJob.jsonPayload.toString());
                jsonObject.put("androidNotificationId", (Object)notifJob.getAndroidId());
                OneSignal.handleNotificationReceived(NotificationBundleProcessor.newJsonArray(jsonObject), true, notifJob.showAsAlert);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return notifJob.getAndroidId();
    }

    private static boolean shouldDisplayNotif(NotificationGenerationJob notifJob) {
        if (notifJob.isInAppPreviewPush && Build.VERSION.SDK_INT <= 18) {
            return false;
        }
        return notifJob.hasExtender() || NotificationBundleProcessor.shouldDisplay(notifJob.jsonPayload.optString("alert"));
    }

    private static JSONArray bundleAsJsonArray(Bundle bundle) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)NotificationBundleProcessor.bundleAsJSONObject(bundle));
        return jsonArray;
    }

    private static void saveAndProcessNotification(Context context, Bundle bundle, boolean opened, int notificationId) {
        NotificationGenerationJob notifJob = new NotificationGenerationJob(context);
        notifJob.jsonPayload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        notifJob.overrideSettings = new NotificationExtenderService.OverrideSettings();
        notifJob.overrideSettings.androidNotificationId = notificationId;
        NotificationBundleProcessor.processNotification(notifJob, opened);
    }

    static void processNotification(NotificationGenerationJob notifiJob, boolean opened) {
        NotificationBundleProcessor.saveNotification(notifiJob, opened);
        if (!notifiJob.isNotificationToDisplay()) {
            return;
        }
        String notificationId = notifiJob.getApiNotificationId();
        OneSignal.getSessionManager().onNotificationReceived(notificationId);
        OSReceiveReceiptController.getInstance().sendReceiveReceipt(notificationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveNotification(NotificationGenerationJob notifiJob, boolean opened) {
        Context context = notifiJob.context;
        JSONObject jsonPayload = notifiJob.jsonPayload;
        try {
            JSONObject customJSON = NotificationBundleProcessor.getCustomJSONObject(notifiJob.jsonPayload);
            OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notifiJob.context);
            SQLiteDatabase writableDb = null;
            try {
                writableDb = dbHelper.getSQLiteDatabaseWithRetries();
                writableDb.beginTransaction();
                if (notifiJob.isNotificationToDisplay()) {
                    String whereStr = "android_notification_id = " + notifiJob.getAndroidIdWithoutCreate();
                    ContentValues values = new ContentValues();
                    values.put("dismissed", Integer.valueOf(1));
                    writableDb.update("notification", values, whereStr, null);
                    BadgeCountUpdater.update(writableDb, context);
                }
                ContentValues values = new ContentValues();
                values.put("notification_id", customJSON.optString(PUSH_MINIFIED_BUTTON_ID));
                if (jsonPayload.has("grp")) {
                    values.put("group_id", jsonPayload.optString("grp"));
                }
                if (jsonPayload.has("collapse_key") && !"do_not_collapse".equals(jsonPayload.optString("collapse_key"))) {
                    values.put("collapse_id", jsonPayload.optString("collapse_key"));
                }
                values.put("opened", Integer.valueOf(opened ? 1 : 0));
                if (!opened) {
                    values.put("android_notification_id", Integer.valueOf(notifiJob.getAndroidIdWithoutCreate()));
                }
                if (notifiJob.getTitle() != null) {
                    values.put("title", notifiJob.getTitle().toString());
                }
                if (notifiJob.getBody() != null) {
                    values.put("message", notifiJob.getBody().toString());
                }
                long sentTime = jsonPayload.optLong("google.sent_time", SystemClock.currentThreadTimeMillis()) / 1000L;
                int ttl = jsonPayload.optInt("google.ttl", 259200);
                long expireTime = sentTime + (long)ttl;
                values.put("expire_time", Long.valueOf(expireTime));
                values.put("full_data", jsonPayload.toString());
                writableDb.insertOrThrow("notification", null, values);
                if (!opened) {
                    BadgeCountUpdater.update(writableDb, context);
                }
                writableDb.setTransactionSuccessful();
            }
            catch (Exception e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error saving notification record! ", e);
            }
            finally {
                if (writableDb != null) {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (Throwable t) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void markRestoredNotificationAsDismissed(NotificationGenerationJob notifiJob) {
        if (notifiJob.getAndroidIdWithoutCreate() == -1) {
            return;
        }
        String whereStr = "android_notification_id = " + notifiJob.getAndroidIdWithoutCreate();
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notifiJob.context);
        SQLiteDatabase writableDb = null;
        try {
            writableDb = dbHelper.getSQLiteDatabaseWithRetries();
            writableDb.beginTransaction();
            ContentValues values = new ContentValues();
            values.put("dismissed", Integer.valueOf(1));
            writableDb.update("notification", values, whereStr, null);
            BadgeCountUpdater.update(writableDb, notifiJob.context);
            writableDb.setTransactionSuccessful();
        }
        catch (Exception e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error saving notification record! ", e);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                }
            }
        }
    }

    @NonNull
    static JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "bundleAsJSONObject error for key: " + key, e);
            }
        }
        return json;
    }

    private static void unMinifyButtonsFromBundle(Bundle gcmBundle) {
        if (!gcmBundle.containsKey(PUSH_MINIFIED_BUTTONS_LIST)) {
            return;
        }
        try {
            JSONObject customJSON = new JSONObject(gcmBundle.getString("custom"));
            JSONObject additionalDataJSON = customJSON.has(PUSH_ADDITIONAL_DATA_KEY) ? customJSON.getJSONObject(PUSH_ADDITIONAL_DATA_KEY) : new JSONObject();
            JSONArray buttons = new JSONArray(gcmBundle.getString(PUSH_MINIFIED_BUTTONS_LIST));
            gcmBundle.remove(PUSH_MINIFIED_BUTTONS_LIST);
            for (int i = 0; i < buttons.length(); ++i) {
                String buttonId;
                JSONObject button = buttons.getJSONObject(i);
                String buttonText = button.getString(PUSH_MINIFIED_BUTTON_TEXT);
                button.remove(PUSH_MINIFIED_BUTTON_TEXT);
                if (button.has(PUSH_MINIFIED_BUTTON_ID)) {
                    buttonId = button.getString(PUSH_MINIFIED_BUTTON_ID);
                    button.remove(PUSH_MINIFIED_BUTTON_ID);
                } else {
                    buttonId = buttonText;
                }
                button.put("id", (Object)buttonId);
                button.put("text", (Object)buttonText);
                if (!button.has(PUSH_MINIFIED_BUTTON_ICON)) continue;
                button.put("icon", (Object)button.getString(PUSH_MINIFIED_BUTTON_ICON));
                button.remove(PUSH_MINIFIED_BUTTON_ICON);
            }
            additionalDataJSON.put("actionButtons", (Object)buttons);
            additionalDataJSON.put("actionId", (Object)DEFAULT_ACTION);
            if (!customJSON.has(PUSH_ADDITIONAL_DATA_KEY)) {
                customJSON.put(PUSH_ADDITIONAL_DATA_KEY, (Object)additionalDataJSON);
            }
            gcmBundle.putString("custom", customJSON.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static OSNotificationPayload OSNotificationPayloadFrom(JSONObject currentJsonPayload) {
        OSNotificationPayload notification = new OSNotificationPayload();
        try {
            JSONObject customJson = NotificationBundleProcessor.getCustomJSONObject(currentJsonPayload);
            notification.notificationID = customJson.optString(PUSH_MINIFIED_BUTTON_ID);
            notification.templateId = customJson.optString("ti");
            notification.templateName = customJson.optString("tn");
            notification.rawPayload = currentJsonPayload.toString();
            notification.additionalData = customJson.optJSONObject(PUSH_ADDITIONAL_DATA_KEY);
            notification.launchURL = customJson.optString("u", null);
            notification.body = currentJsonPayload.optString("alert", null);
            notification.title = currentJsonPayload.optString("title", null);
            notification.smallIcon = currentJsonPayload.optString("sicon", null);
            notification.bigPicture = currentJsonPayload.optString("bicon", null);
            notification.largeIcon = currentJsonPayload.optString("licon", null);
            notification.sound = currentJsonPayload.optString("sound", null);
            notification.groupKey = currentJsonPayload.optString("grp", null);
            notification.groupMessage = currentJsonPayload.optString("grp_msg", null);
            notification.smallIconAccentColor = currentJsonPayload.optString("bgac", null);
            notification.ledColor = currentJsonPayload.optString("ledc", null);
            String visibility = currentJsonPayload.optString("vis", null);
            if (visibility != null) {
                notification.lockScreenVisibility = Integer.parseInt(visibility);
            }
            notification.fromProjectNumber = currentJsonPayload.optString("from", null);
            notification.priority = currentJsonPayload.optInt("pri", 0);
            String collapseKey = currentJsonPayload.optString("collapse_key", null);
            if (!"do_not_collapse".equals(collapseKey)) {
                notification.collapseId = collapseKey;
            }
            try {
                NotificationBundleProcessor.setActionButtons(notification);
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload.actionButtons values!", t);
            }
            try {
                NotificationBundleProcessor.setBackgroundImageLayout(notification, currentJsonPayload);
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload.backgroundImageLayout values!", t);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload values!", t);
        }
        return notification;
    }

    private static void setActionButtons(OSNotificationPayload notification) throws Throwable {
        if (notification.additionalData != null && notification.additionalData.has("actionButtons")) {
            JSONArray jsonActionButtons = notification.additionalData.getJSONArray("actionButtons");
            notification.actionButtons = new ArrayList<OSNotificationPayload.ActionButton>();
            for (int i = 0; i < jsonActionButtons.length(); ++i) {
                JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                OSNotificationPayload.ActionButton actionButton = new OSNotificationPayload.ActionButton();
                actionButton.id = jsonActionButton.optString("id", null);
                actionButton.text = jsonActionButton.optString("text", null);
                actionButton.icon = jsonActionButton.optString("icon", null);
                notification.actionButtons.add(actionButton);
            }
            notification.additionalData.remove("actionId");
            notification.additionalData.remove("actionButtons");
        }
    }

    private static void setBackgroundImageLayout(OSNotificationPayload notification, JSONObject currentJsonPayload) throws Throwable {
        String jsonStrBgImage = currentJsonPayload.optString("bg_img", null);
        if (jsonStrBgImage != null) {
            JSONObject jsonBgImage = new JSONObject(jsonStrBgImage);
            notification.backgroundImageLayout = new OSNotificationPayload.BackgroundImageLayout();
            notification.backgroundImageLayout.image = jsonBgImage.optString("img");
            notification.backgroundImageLayout.titleTextColor = jsonBgImage.optString("tc");
            notification.backgroundImageLayout.bodyTextColor = jsonBgImage.optString("bc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCollapseKey(NotificationGenerationJob notifJob) {
        if (notifJob.restoring) {
            return;
        }
        if (!notifJob.jsonPayload.has("collapse_key") || "do_not_collapse".equals(notifJob.jsonPayload.optString("collapse_key"))) {
            return;
        }
        String collapse_id = notifJob.jsonPayload.optString("collapse_key");
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(notifJob.context);
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = dbHelper.getSQLiteDatabaseWithRetries();
            cursor = readableDb.query("notification", new String[]{"android_notification_id"}, "collapse_id = ? AND dismissed = 0 AND opened = 0 ", new String[]{collapse_id}, null, null, null);
            if (cursor.moveToFirst()) {
                int androidNotificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                notifJob.setAndroidIdWithOutOverriding(androidNotificationId);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not read DB to find existing collapse_key!", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    @NonNull
    static ProcessedBundleResult processBundleFromReceiver(Context context, final Bundle bundle) {
        ProcessedBundleResult result = new ProcessedBundleResult();
        if (!OSNotificationFormatHelper.isOneSignalBundle(bundle)) {
            return result;
        }
        result.isOneSignalPayload = true;
        NotificationBundleProcessor.unMinifyButtonsFromBundle(bundle);
        JSONObject pushPayloadJson = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        String previewUUID = NotificationBundleProcessor.inAppPreviewPushUUID(pushPayloadJson);
        if (previewUUID != null) {
            if (OneSignal.isAppActive()) {
                result.inAppPreviewShown = true;
                OSInAppMessageController.getController().displayPreviewMessage(previewUUID);
            }
            return result;
        }
        if (NotificationBundleProcessor.startExtenderService(context, bundle, result)) {
            return result;
        }
        result.isDup = OneSignal.notValidOrDuplicated(context, pushPayloadJson);
        if (result.isDup) {
            return result;
        }
        String alert = bundle.getString("alert");
        if (!NotificationBundleProcessor.shouldDisplay(alert)) {
            NotificationBundleProcessor.saveAndProcessNotification(context, bundle, true, -1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.handleNotificationReceived(NotificationBundleProcessor.bundleAsJsonArray(bundle), false, false);
                }
            }, "OS_PROC_BUNDLE").start();
        }
        return result;
    }

    @Nullable
    static String inAppPreviewPushUUID(JSONObject payload) {
        JSONObject osCustom;
        try {
            osCustom = NotificationBundleProcessor.getCustomJSONObject(payload);
        }
        catch (JSONException e) {
            return null;
        }
        if (!osCustom.has(PUSH_ADDITIONAL_DATA_KEY)) {
            return null;
        }
        JSONObject additionalData = osCustom.optJSONObject(PUSH_ADDITIONAL_DATA_KEY);
        if (additionalData.has(IAM_PREVIEW_KEY)) {
            return additionalData.optString(IAM_PREVIEW_KEY);
        }
        return null;
    }

    private static boolean startExtenderService(Context context, Bundle bundle, ProcessedBundleResult result) {
        boolean isHighPriority;
        Intent intent = NotificationExtenderService.getIntent(context);
        if (intent == null) {
            return false;
        }
        intent.putExtra("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
        intent.putExtra("timestamp", System.currentTimeMillis() / 1000L);
        boolean bl = isHighPriority = Integer.parseInt(bundle.getString("pri", "0")) > 9;
        if (Build.VERSION.SDK_INT >= 21) {
            NotificationExtenderService.enqueueWork(context, intent.getComponent(), 2071862121, intent, isHighPriority);
        } else {
            context.startService(intent);
        }
        result.hasExtenderService = true;
        return true;
    }

    static boolean shouldDisplay(String body) {
        boolean hasBody = body != null && !"".equals(body);
        boolean showAsAlert = OneSignal.getInAppAlertNotificationEnabled();
        boolean isActive = OneSignal.isAppActive();
        return hasBody && (OneSignal.getNotificationsWhenActiveEnabled() || showAsAlert || !isActive);
    }

    @NonNull
    static JSONArray newJsonArray(JSONObject jsonObject) {
        return new JSONArray().put((Object)jsonObject);
    }

    static JSONObject getCustomJSONObject(JSONObject jsonObject) throws JSONException {
        return new JSONObject(jsonObject.optString("custom"));
    }

    static boolean hasRemoteResource(Bundle bundle) {
        return NotificationBundleProcessor.isBuildKeyRemote(bundle, "licon") || NotificationBundleProcessor.isBuildKeyRemote(bundle, "bicon") || bundle.getString("bg_img", null) != null;
    }

    private static boolean isBuildKeyRemote(Bundle bundle, String key) {
        String value = bundle.getString(key, "").trim();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    static class ProcessedBundleResult {
        boolean isOneSignalPayload;
        boolean hasExtenderService;
        boolean isDup;
        boolean inAppPreviewShown;

        ProcessedBundleResult() {
        }

        boolean processed() {
            return !this.isOneSignalPayload || this.hasExtenderService || this.isDup || this.inAppPreviewShown;
        }
    }
}

