/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.onesignal.influence.model.OSInfluenceChannel;

public class OSOutcomeTableProvider {
    private static final String INTEGER_PRIMARY_KEY_TYPE = " INTEGER PRIMARY KEY";
    private static final String TEXT_TYPE = " TEXT";
    private static final String INT_TYPE = " INTEGER";
    private static final String FLOAT_TYPE = " FLOAT";
    private static final String TIMESTAMP_TYPE = " TIMESTAMP";
    public static final String OUTCOME_EVENT_TABLE = "outcome";
    public static final String CACHE_UNIQUE_OUTCOME_TABLE = "cached_unique_outcome";
    public static final String CACHE_UNIQUE_OUTCOME_COLUMN_CHANNEL_INFLUENCE_ID = "channel_influence_id";
    public static final String CACHE_UNIQUE_OUTCOME_COLUMN_CHANNEL_TYPE = "channel_type";
    private static final String SQL_CREATE_OUTCOME_ENTRIES = "CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_influence_type TEXT,iam_influence_type TEXT,notification_ids TEXT,iam_ids TEXT,name TEXT,timestamp TIMESTAMP,weight FLOAT);";
    private static final String SQL_CREATE_UNIQUE_OUTCOME_ENTRIES = "CREATE TABLE cached_unique_outcome (_id INTEGER PRIMARY KEY,channel_influence_id TEXT,channel_type TEXT,name TEXT);";

    public void upgradeOutcomeTableRevision2To3(SQLiteDatabase db) {
        String commonColumns = "_id,name,timestamp,notification_ids,weight";
        String commonColumnsWithSessionColumn = commonColumns + "," + "session";
        String commonColumnsWithNewSessionColumn = commonColumns + "," + "notification_influence_type";
        String auxOutcomeTableName = "outcome_aux";
        try {
            db.execSQL("BEGIN TRANSACTION;");
            db.execSQL("ALTER TABLE outcome RENAME TO " + auxOutcomeTableName + ";");
            db.execSQL(this.getSqlCreateOutcomeEntries());
            db.execSQL("INSERT INTO outcome(" + commonColumnsWithNewSessionColumn + ") SELECT " + commonColumnsWithSessionColumn + " FROM " + auxOutcomeTableName + ";");
            db.execSQL("DROP TABLE " + auxOutcomeTableName + ";");
            db.execSQL("COMMIT;");
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public void upgradeCacheOutcomeTableRevision1To2(SQLiteDatabase db) {
        String commonColumns = "_id,name";
        String commonColumnsWithNotificationIdColumn = commonColumns + "," + "notification_id";
        String commonColumnsWithNewInfluenceIdColumn = commonColumns + "," + CACHE_UNIQUE_OUTCOME_COLUMN_CHANNEL_INFLUENCE_ID;
        String oldCacheUniqueOutcomeTable = "cached_unique_outcome_notification";
        try {
            db.execSQL("BEGIN TRANSACTION;");
            db.execSQL(this.getSqlCreateUniqueOutcomeEntries());
            db.execSQL("INSERT INTO cached_unique_outcome(" + commonColumnsWithNewInfluenceIdColumn + ") SELECT " + commonColumnsWithNotificationIdColumn + " FROM " + oldCacheUniqueOutcomeTable + ";");
            db.execSQL("UPDATE cached_unique_outcome SET channel_type = '" + OSInfluenceChannel.NOTIFICATION.toString() + "';");
            db.execSQL("DROP TABLE " + oldCacheUniqueOutcomeTable + ";");
            db.execSQL("COMMIT;");
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public String getSqlCreateOutcomeEntries() {
        return SQL_CREATE_OUTCOME_ENTRIES;
    }

    public String getSqlCreateUniqueOutcomeEntries() {
        return SQL_CREATE_UNIQUE_OUTCOME_ENTRIES;
    }
}

