/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.WorkerThread;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSInAppMessageRedisplayStats;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

class OSInAppMessageRepository {
    private final OneSignalDbHelper dbHelper;

    OSInAppMessageRepository(OneSignalDbHelper dbHelper) {
        this.dbHelper = dbHelper;
    }

    @WorkerThread
    synchronized void saveInAppMessage(OSInAppMessage inAppMessage) {
        SQLiteDatabase writableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
        ContentValues values = new ContentValues();
        values.put("message_id", inAppMessage.messageId);
        values.put("display_quantity", Integer.valueOf(inAppMessage.getRedisplayStats().getDisplayQuantity()));
        values.put("last_display", Long.valueOf(inAppMessage.getRedisplayStats().getLastDisplayTime()));
        values.put("click_ids", inAppMessage.getClickedClickIds().toString());
        values.put("displayed_in_session", Boolean.valueOf(inAppMessage.isDisplayedInSession()));
        int rowsUpdated = writableDb.update("in_app_message", values, "message_id = ?", new String[]{inAppMessage.messageId});
        if (rowsUpdated == 0) {
            writableDb.insert("in_app_message", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized List<OSInAppMessage> getCachedInAppMessages() {
        ArrayList<OSInAppMessage> iams = new ArrayList<OSInAppMessage>();
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
            cursor = readableDb.query("in_app_message", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    String messageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    String clickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                    int displayQuantity = cursor.getInt(cursor.getColumnIndex("display_quantity"));
                    long lastDisplay = cursor.getLong(cursor.getColumnIndex("last_display"));
                    boolean displayed = cursor.getInt(cursor.getColumnIndex("displayed_in_session")) == 1;
                    Set<String> clickIdsSet = OSUtils.newStringSetFromJSONArray(new JSONArray(clickIds));
                    OSInAppMessage inAppMessage = new OSInAppMessage(messageId, clickIdsSet, displayed, new OSInAppMessageRedisplayStats(displayQuantity, lastDisplay));
                    iams.add(inAppMessage);
                } while (cursor.moveToNext());
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating JSONArray from iam click ids:JSON Failed.", e);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return iams;
    }
}

