/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.DelayedConsentInitializationParameters;
import com.onesignal.FocusTimeController;
import com.onesignal.JSONUtils;
import com.onesignal.LocationGMS;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationChannelManager;
import com.onesignal.NotificationRestorer;
import com.onesignal.NotificationSummaryManager;
import com.onesignal.OSEmailSubscriptionChangedInternalObserver;
import com.onesignal.OSEmailSubscriptionObserver;
import com.onesignal.OSEmailSubscriptionState;
import com.onesignal.OSEmailSubscriptionStateChanges;
import com.onesignal.OSInAppMessageAction;
import com.onesignal.OSInAppMessageController;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationAction;
import com.onesignal.OSNotificationOpenResult;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OSObservable;
import com.onesignal.OSPermissionChangedInternalObserver;
import com.onesignal.OSPermissionObserver;
import com.onesignal.OSPermissionState;
import com.onesignal.OSPermissionStateChanges;
import com.onesignal.OSPermissionSubscriptionState;
import com.onesignal.OSSessionManager;
import com.onesignal.OSSubscriptionChangedInternalObserver;
import com.onesignal.OSSubscriptionObserver;
import com.onesignal.OSSubscriptionState;
import com.onesignal.OSSubscriptionStateChanges;
import com.onesignal.OSUtils;
import com.onesignal.OneSignalCacheCleaner;
import com.onesignal.OneSignalChromeTabAndroidFrame;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.OneSignalSyncServiceUtils;
import com.onesignal.OutcomeEvent;
import com.onesignal.OutcomeEventsController;
import com.onesignal.OutcomesUtils;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorFCM;
import com.onesignal.PushRegistratorGCM;
import com.onesignal.RootToolsInternalMethods;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackFirebaseAnalytics;
import com.onesignal.TrackGooglePurchase;
import com.onesignal.UserStateSynchronizer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final long MIN_ON_SESSION_TIME_MILLIS = 30000L;
    private static EmailUpdateHandler emailUpdateHandler;
    private static EmailUpdateHandler emailLogoutHandler;
    @Nullable
    static String appId;
    private static String mGoogleProjectNumber;
    static Context appContext;
    private static LOG_LEVEL visualLogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String userId;
    private static String emailId;
    private static int subscribableStatus;
    private static boolean initDone;
    private static boolean foreground;
    @NonNull
    private static AppEntryAction appEntryState;
    static ExecutorService pendingTaskExecutor;
    public static ConcurrentLinkedQueue<Runnable> taskQueueWaitingForInit;
    static AtomicLong lastTaskId;
    private static IdsAvailableHandler idsAvailableHandler;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    private static TrackFirebaseAnalytics trackFirebaseAnalytics;
    public static final String VERSION = "031302";
    @Nullable
    private static OSSessionManager sessionManager;
    @Nullable
    private static OutcomeEventsController outcomeEventsController;
    private static AdvertisingIdentifierProvider mainAdIdProvider;
    public static String sdkType;
    @NonNull
    private static OSUtils osUtils;
    private static String lastRegistrationId;
    private static boolean registerForPushFired;
    private static boolean locationFired;
    private static boolean promptedLocation;
    private static LocationGMS.LocationPoint lastLocationPoint;
    static boolean shareLocation;
    @NonNull
    static Builder mInitBuilder;
    private static Collection<JSONArray> unprocessedOpenedNotifis;
    private static HashSet<String> postedOpenedNotifIds;
    private static ArrayList<GetTagsHandler> pendingGetTagsHandlers;
    private static boolean getTagsCall;
    private static boolean waitingToPostStateSync;
    static boolean requiresUserPrivacyConsent;
    static DelayedConsentInitializationParameters delayedInitParams;
    static OneSignalRemoteParams.Params remoteParams;
    private static OSPermissionState currentPermissionState;
    static OSPermissionState lastPermissionState;
    private static OSObservable<OSPermissionObserver, OSPermissionStateChanges> permissionStateChangesObserver;
    private static OSSubscriptionState currentSubscriptionState;
    static OSSubscriptionState lastSubscriptionState;
    private static OSObservable<OSSubscriptionObserver, OSSubscriptionStateChanges> subscriptionStateChangesObserver;
    private static OSEmailSubscriptionState currentEmailSubscriptionState;
    static OSEmailSubscriptionState lastEmailSubscriptionState;
    private static OSObservable<OSEmailSubscriptionObserver, OSEmailSubscriptionStateChanges> emailSubscriptionStateChangesObserver;
    private static IAPUpdateJob iapUpdateJob;
    private static PushRegistrator mPushRegistrator;

    static boolean isInitDone() {
        return initDone;
    }

    static boolean isForeground() {
        return foreground;
    }

    @NonNull
    static AppEntryAction getAppEntryState() {
        return appEntryState;
    }

    private static OSSessionManager.SessionListener getNewSessionListener() {
        return new OSSessionManager.SessionListener(){

            @Override
            public void onSessionEnding(@NonNull OSSessionManager.SessionResult lastSessionResult) {
                outcomeEventsController.cleanOutcomes();
                FocusTimeController.getInstance().onSessionEnded(lastSessionResult);
            }
        };
    }

    private static OSPermissionState getCurrentPermissionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentPermissionState == null) {
            currentPermissionState = new OSPermissionState(false);
            OneSignal.currentPermissionState.observable.addObserverStrong(new OSPermissionChangedInternalObserver());
        }
        return currentPermissionState;
    }

    private static OSPermissionState getLastPermissionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastPermissionState == null) {
            lastPermissionState = new OSPermissionState(true);
        }
        return lastPermissionState;
    }

    static OSObservable<OSPermissionObserver, OSPermissionStateChanges> getPermissionStateChangesObserver() {
        if (permissionStateChangesObserver == null) {
            permissionStateChangesObserver = new OSObservable("onOSPermissionChanged", true);
        }
        return permissionStateChangesObserver;
    }

    private static OSSubscriptionState getCurrentSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentSubscriptionState == null) {
            currentSubscriptionState = new OSSubscriptionState(false, OneSignal.getCurrentPermissionState(context).getEnabled());
            OneSignal.getCurrentPermissionState((Context)context).observable.addObserver(currentSubscriptionState);
            OneSignal.currentSubscriptionState.observable.addObserverStrong(new OSSubscriptionChangedInternalObserver());
        }
        return currentSubscriptionState;
    }

    private static OSSubscriptionState getLastSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastSubscriptionState == null) {
            lastSubscriptionState = new OSSubscriptionState(true, false);
        }
        return lastSubscriptionState;
    }

    static OSObservable<OSSubscriptionObserver, OSSubscriptionStateChanges> getSubscriptionStateChangesObserver() {
        if (subscriptionStateChangesObserver == null) {
            subscriptionStateChangesObserver = new OSObservable("onOSSubscriptionChanged", true);
        }
        return subscriptionStateChangesObserver;
    }

    private static OSEmailSubscriptionState getCurrentEmailSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (currentEmailSubscriptionState == null) {
            currentEmailSubscriptionState = new OSEmailSubscriptionState(false);
            OneSignal.currentEmailSubscriptionState.observable.addObserverStrong(new OSEmailSubscriptionChangedInternalObserver());
        }
        return currentEmailSubscriptionState;
    }

    private static OSEmailSubscriptionState getLastEmailSubscriptionState(Context context) {
        if (context == null) {
            return null;
        }
        if (lastEmailSubscriptionState == null) {
            lastEmailSubscriptionState = new OSEmailSubscriptionState(true);
        }
        return lastEmailSubscriptionState;
    }

    static OSObservable<OSEmailSubscriptionObserver, OSEmailSubscriptionStateChanges> getEmailSubscriptionStateChangesObserver() {
        if (emailSubscriptionStateChangesObserver == null) {
            emailSubscriptionStateChangesObserver = new OSObservable("onOSEmailSubscriptionChanged", true);
        }
        return emailSubscriptionStateChangesObserver;
    }

    public static Builder getCurrentOrNewInitBuilder() {
        return mInitBuilder;
    }

    public static void setAppContext(@NonNull Context context) {
        if (context == null) {
            OneSignal.Log(LOG_LEVEL.WARN, "setAppContext(null) is not valid, ignoring!");
            return;
        }
        boolean wasAppContextNull = appContext == null;
        appContext = context.getApplicationContext();
        ActivityLifecycleListener.registerActivityLifecycleCallbacks((Application)appContext);
        if (wasAppContextNull) {
            sessionManager = new OSSessionManager(OneSignal.getNewSessionListener());
            outcomeEventsController = new OutcomeEventsController(sessionManager, OneSignal.getDBHelperInstance());
            OneSignalPrefs.startDelayedWrite();
            OneSignalCacheCleaner.cleanOldCachedData(context);
        }
    }

    static OneSignalDbHelper getDBHelperInstance() {
        return OneSignalDbHelper.getInstance(appContext);
    }

    public static Builder startInit(Context context) {
        return new Builder(context);
    }

    private static void init(Builder inBuilder) {
        if (OneSignal.mInitBuilder.mDisplayOptionCarryOver) {
            inBuilder.mDisplayOption = OneSignal.mInitBuilder.mDisplayOption;
        }
        mInitBuilder = inBuilder;
        Context context = OneSignal.mInitBuilder.mContext;
        OneSignal.mInitBuilder.mContext = null;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String sender_id = bundle.getString("onesignal_google_project_number");
            if (sender_id != null && sender_id.length() > 4) {
                sender_id = sender_id.substring(4);
            }
            OneSignal.init(context, sender_id, bundle.getString("onesignal_app_id"), OneSignal.mInitBuilder.mNotificationOpenedHandler, OneSignal.mInitBuilder.mNotificationReceivedHandler);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, null, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler notificationOpenedHandler) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, notificationOpenedHandler, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler notificationOpenedHandler, NotificationReceivedHandler notificationReceivedHandler) {
        mInitBuilder = OneSignal.createInitBuilder(notificationOpenedHandler, notificationReceivedHandler);
        OneSignal.setAppContext(context);
        OneSignal.setupPrivacyConsent(context);
        if (OneSignal.requiresUserPrivacyConsent()) {
            OneSignal.Log(LOG_LEVEL.VERBOSE, "OneSignal SDK initialization delayed, user privacy consent is set to required for this application.");
            delayedInitParams = new DelayedConsentInitializationParameters(context, googleProjectNumber, oneSignalAppId, notificationOpenedHandler, notificationReceivedHandler);
            return;
        }
        mInitBuilder = OneSignal.createInitBuilder(notificationOpenedHandler, notificationReceivedHandler);
        if (!OneSignal.isGoogleProjectNumberRemote()) {
            mGoogleProjectNumber = googleProjectNumber;
        }
        subscribableStatus = osUtils.initializationChecker(context, oneSignalAppId);
        if (OneSignal.isSubscriptionStatusUninitializable()) {
            return;
        }
        if (appId != null && !appId.equals(oneSignalAppId)) {
            initDone = false;
        }
        if (initDone) {
            if (OneSignal.mInitBuilder.mNotificationOpenedHandler != null) {
                OneSignal.fireCallbackForOpenedNotifications();
            }
            return;
        }
        appId = oneSignalAppId;
        OneSignal.saveFilterOtherGCMReceivers(OneSignal.mInitBuilder.mFilterOtherGCMReceivers);
        OneSignal.handleActivityLifecycleHandler(context);
        OneSignalStateSynchronizer.initUserState();
        OneSignal.handleAmazonPurchase();
        OneSignal.handleAppIdChange();
        OSPermissionChangedInternalObserver.handleInternalChanges(OneSignal.getCurrentPermissionState(appContext));
        OneSignal.doSessionInit();
        if (OneSignal.mInitBuilder.mNotificationOpenedHandler != null) {
            OneSignal.fireCallbackForOpenedNotifications();
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        if (TrackFirebaseAnalytics.CanTrack()) {
            trackFirebaseAnalytics = new TrackFirebaseAnalytics(appContext);
        }
        PushRegistratorFCM.disableFirebaseInstanceIdService(appContext);
        initDone = true;
        outcomeEventsController.sendSavedOutcomes();
        OneSignal.startPendingTasks();
    }

    private static void setupPrivacyConsent(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String requireSetting = bundle.getString("com.onesignal.PrivacyConsent");
            OneSignal.setRequiresUserPrivacyConsent("ENABLE".equalsIgnoreCase(requireSetting));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static Builder createInitBuilder(NotificationOpenedHandler notificationOpenedHandler, NotificationReceivedHandler notificationReceivedHandler) {
        OneSignal.mInitBuilder.mDisplayOptionCarryOver = false;
        OneSignal.mInitBuilder.mNotificationOpenedHandler = notificationOpenedHandler;
        OneSignal.mInitBuilder.mNotificationReceivedHandler = notificationReceivedHandler;
        return mInitBuilder;
    }

    private static void handleAppIdChange() {
        String oldAppId = OneSignal.getSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "APP ID changed, clearing user id as it is no longer valid.");
                OneSignal.saveAppId(appId);
                OneSignalStateSynchronizer.resetCurrentState();
                remoteParams = null;
            }
        } else {
            BadgeCountUpdater.updateCount(0, appContext);
            OneSignal.saveAppId(appId);
        }
    }

    public static boolean userProvidedPrivacyConsent() {
        return OneSignal.getSavedUserConsentStatus();
    }

    private static boolean isGoogleProjectNumberRemote() {
        return remoteParams != null && OneSignal.remoteParams.googleProjectNumber != null;
    }

    private static boolean isSubscriptionStatusUninitializable() {
        return subscribableStatus == -999;
    }

    private static void handleActivityLifecycleHandler(Context context) {
        foreground = OneSignal.isContextActivity(context);
        if (foreground) {
            ActivityLifecycleHandler.curActivity = (Activity)context;
            NotificationRestorer.asyncRestore(appContext);
            FocusTimeController.getInstance().appForegrounded();
        } else {
            ActivityLifecycleHandler.nextResumeIsFirstActivity = true;
        }
    }

    private static void handleAmazonPurchase() {
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase(appContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void doSessionInit() {
        if (OneSignal.isPastOnSessionTime()) {
            OneSignalStateSynchronizer.setNewSession();
            if (foreground) {
                outcomeEventsController.cleanOutcomes();
                sessionManager.restartSessionIfNeeded();
            }
        } else if (foreground) {
            OSInAppMessageController.getController().initWithCachedInAppMessages();
            sessionManager.attemptSessionUpgrade();
        }
        if (!foreground && OneSignal.hasUserId()) {
            return;
        }
        OneSignal.setLastSessionTime(System.currentTimeMillis());
        OneSignal.startRegistrationOrOnSession();
    }

    private static boolean isContextActivity(Context context) {
        return context instanceof Activity;
    }

    private static void onTaskRan(long taskId) {
        if (lastTaskId.get() == taskId) {
            OneSignal.Log(LOG_LEVEL.INFO, "Last Pending Task has ran, shutting down");
            pendingTaskExecutor.shutdown();
        }
    }

    private static void startPendingTasks() {
        if (!taskQueueWaitingForInit.isEmpty()) {
            pendingTaskExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(@NonNull Runnable runnable) {
                    Thread newThread = new Thread(runnable);
                    newThread.setName("OS_PENDING_EXECUTOR_" + newThread.getId());
                    return newThread;
                }
            });
            while (!taskQueueWaitingForInit.isEmpty()) {
                pendingTaskExecutor.submit(taskQueueWaitingForInit.poll());
            }
        }
    }

    private static void addTaskToQueue(PendingTaskRunnable task) {
        task.taskId = OneSignal.lastTaskId.incrementAndGet();
        if (pendingTaskExecutor == null) {
            OneSignal.Log(LOG_LEVEL.INFO, "Adding a task to the pending queue with ID: " + task.taskId);
            taskQueueWaitingForInit.add(task);
        } else if (!pendingTaskExecutor.isShutdown()) {
            OneSignal.Log(LOG_LEVEL.INFO, "Executor is still running, add to the executor with ID: " + task.taskId);
            try {
                pendingTaskExecutor.submit(task);
            }
            catch (RejectedExecutionException e) {
                OneSignal.Log(LOG_LEVEL.INFO, "Executor is shutdown, running task manually with ID: " + task.taskId);
                task.run();
                e.printStackTrace();
            }
        }
    }

    private static boolean shouldRunTaskThroughQueue() {
        if (initDone && pendingTaskExecutor == null) {
            return false;
        }
        if (!initDone && pendingTaskExecutor == null) {
            return true;
        }
        return pendingTaskExecutor != null && !pendingTaskExecutor.isShutdown();
    }

    private static void startRegistrationOrOnSession() {
        if (waitingToPostStateSync) {
            return;
        }
        waitingToPostStateSync = true;
        if (OneSignalStateSynchronizer.getSyncAsNewSession()) {
            locationFired = false;
        }
        OneSignal.startLocationUpdate();
        registerForPushFired = false;
        OneSignal.makeAndroidParamsRequest();
    }

    private static void startLocationUpdate() {
        LocationGMS.LocationHandler locationHandler = new LocationGMS.LocationHandler(){

            @Override
            public LocationGMS.PermissionType getType() {
                return LocationGMS.PermissionType.STARTUP;
            }

            @Override
            public void complete(LocationGMS.LocationPoint point) {
                lastLocationPoint = point;
                locationFired = true;
                OneSignal.registerUser();
            }
        };
        boolean doPrompt = OneSignal.mInitBuilder.mPromptLocation && !promptedLocation;
        promptedLocation = promptedLocation || OneSignal.mInitBuilder.mPromptLocation;
        LocationGMS.getLocation(appContext, doPrompt, locationHandler);
    }

    private static PushRegistrator getPushRegistrator() {
        if (mPushRegistrator != null) {
            return mPushRegistrator;
        }
        int deviceType = osUtils.getDeviceType();
        mPushRegistrator = deviceType == 2 ? new PushRegistratorADM() : (OSUtils.hasFCMLibrary() ? new PushRegistratorFCM() : new PushRegistratorGCM());
        return mPushRegistrator;
    }

    private static void registerForPushToken() {
        OneSignal.getPushRegistrator().registerForPush(appContext, mGoogleProjectNumber, new PushRegistrator.RegisteredHandler(){

            @Override
            public void complete(String id2, int status) {
                if (status < 1) {
                    if (OneSignalStateSynchronizer.getRegistrationId() == null && (subscribableStatus == 1 || OneSignal.pushStatusRuntimeError(subscribableStatus))) {
                        subscribableStatus = status;
                    }
                } else if (OneSignal.pushStatusRuntimeError(subscribableStatus)) {
                    subscribableStatus = status;
                }
                lastRegistrationId = id2;
                registerForPushFired = true;
                OneSignal.getCurrentSubscriptionState(appContext).setPushToken(id2);
                OneSignal.registerUser();
            }
        });
    }

    private static boolean pushStatusRuntimeError(int subscribableStatus) {
        return subscribableStatus < -6;
    }

    private static void makeAndroidParamsRequest() {
        if (remoteParams != null) {
            OneSignal.registerForPushToken();
            return;
        }
        OneSignalRemoteParams.makeAndroidParamsRequest(new OneSignalRemoteParams.CallBack(){

            @Override
            public void complete(OneSignalRemoteParams.Params params) {
                remoteParams = params;
                if (OneSignal.remoteParams.googleProjectNumber != null) {
                    mGoogleProjectNumber = OneSignal.remoteParams.googleProjectNumber;
                }
                OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_FIREBASE_TRACKING_ENABLED", OneSignal.remoteParams.firebaseAnalytics);
                OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_RESTORE_TTL_FILTER", OneSignal.remoteParams.restoreTTLFilter);
                OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_CLEAR_GROUP_SUMMARY_CLICK", OneSignal.remoteParams.clearGroupOnSummaryClick);
                OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_RECEIVE_RECEIPTS_ENABLED", OneSignal.remoteParams.receiveReceiptEnabled);
                OutcomesUtils.saveOutcomesParams(params.outcomesParams);
                NotificationChannelManager.processChannelList(appContext, params.notificationChannels);
                OneSignal.registerForPushToken();
            }
        });
    }

    private static void fireCallbackForOpenedNotifications() {
        for (JSONArray dataArray : unprocessedOpenedNotifis) {
            OneSignal.runNotificationOpenedCallback(dataArray, true, false);
        }
        unprocessedOpenedNotifis.clear();
    }

    public static void onesignalLog(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message);
    }

    public static void provideUserConsent(boolean consent) {
        boolean previousConsentStatus = OneSignal.userProvidedPrivacyConsent();
        OneSignal.saveUserConsentStatus(consent);
        if (!previousConsentStatus && consent && delayedInitParams != null) {
            OneSignal.init(OneSignal.delayedInitParams.context, OneSignal.delayedInitParams.googleProjectNumber, OneSignal.delayedInitParams.appId, OneSignal.delayedInitParams.openedHandler, OneSignal.delayedInitParams.receivedHandler);
            delayedInitParams = null;
        }
    }

    public static void setRequiresUserPrivacyConsent(boolean required) {
        if (requiresUserPrivacyConsent && !required) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Cannot change requiresUserPrivacyConsent() from TRUE to FALSE");
            return;
        }
        requiresUserPrivacyConsent = required;
    }

    public static boolean requiresUserPrivacyConsent() {
        return requiresUserPrivacyConsent && !OneSignal.userProvidedPrivacyConsent();
    }

    static boolean shouldLogUserPrivacyConsentErrorMessageForMethodName(String methodName) {
        if (OneSignal.requiresUserPrivacyConsent()) {
            if (methodName != null) {
                OneSignal.Log(LOG_LEVEL.WARN, "Method " + methodName + " was called before the user provided privacy consent. Your application is set to require the user's privacy consent before the OneSignal SDK can be initialized. Please ensure the user has provided consent before calling this method. You can check the latest OneSignal consent status by calling OneSignal.userProvidedPrivacyConsent()");
            }
            return true;
        }
        return false;
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualLogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    static boolean atLogLevel(LOG_LEVEL level) {
        return level.compareTo(visualLogLevel) < 1 || level.compareTo(logCatLevel) < 1;
    }

    static void Log(@NonNull LOG_LEVEL level, @NonNull String message) {
        OneSignal.Log(level, message, null);
    }

    static void Log(final @NonNull LOG_LEVEL level, @NonNull String message, @Nullable Throwable throwable) {
        String TAG = "OneSignal";
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)"OneSignal", (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)"OneSignal", (String)message, (Throwable)throwable);
            }
        }
        if (level.compareTo(visualLogLevel) < 1 && ActivityLifecycleHandler.curActivity != null) {
            try {
                String fullMessage = message + "\n";
                if (throwable != null) {
                    fullMessage = fullMessage + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessage = fullMessage + sw.toString();
                }
                final String finalFullMessage = fullMessage;
                OSUtils.runOnMainUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ActivityLifecycleHandler.curActivity != null) {
                            new AlertDialog.Builder((Context)ActivityLifecycleHandler.curActivity).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                        }
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)"OneSignal", (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    static void logHttpError(String errorString, int statusCode, Throwable throwable, String errorResponse) {
        String jsonError = "";
        if (errorResponse != null && OneSignal.atLogLevel(LOG_LEVEL.INFO)) {
            jsonError = "\n" + errorResponse + "\n";
        }
        OneSignal.Log(LOG_LEVEL.WARN, "HTTP code: " + statusCode + " " + errorString + jsonError, throwable);
    }

    @WorkerThread
    static void onAppLostFocus() {
        foreground = false;
        appEntryState = AppEntryAction.APP_CLOSE;
        OneSignal.setLastSessionTime(System.currentTimeMillis());
        LocationGMS.onFocusChange();
        if (!initDone) {
            return;
        }
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Android Context not found, please call OneSignal.init when your app starts.");
            return;
        }
        FocusTimeController.getInstance().appBackgrounded();
        OneSignal.scheduleSyncService();
    }

    private static boolean scheduleSyncService() {
        boolean locationScheduled;
        boolean unsyncedChanges = OneSignalStateSynchronizer.persist();
        if (unsyncedChanges) {
            OneSignalSyncServiceUtils.scheduleSyncTask(appContext);
        }
        return (locationScheduled = LocationGMS.scheduleUpdate(appContext)) || unsyncedChanges;
    }

    static void onAppFocus() {
        foreground = true;
        if (!appEntryState.equals((Object)AppEntryAction.NOTIFICATION_CLICK)) {
            appEntryState = AppEntryAction.APP_OPEN;
        }
        LocationGMS.onFocusChange();
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("onAppFocus")) {
            return;
        }
        if (OSUtils.shouldLogMissingAppIdError(appId)) {
            return;
        }
        FocusTimeController.getInstance().appForegrounded();
        OneSignal.doSessionInit();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
        NotificationRestorer.asyncRestore(appContext);
        OneSignal.getCurrentPermissionState(appContext).refreshAsTo();
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled()) {
            trackFirebaseAnalytics.trackInfluenceOpenEvent();
        }
        OneSignalSyncServiceUtils.cancelSyncTask(appContext);
    }

    static void addNetType(JSONObject jsonObj) {
        try {
            jsonObj.put("net_type", (Object)osUtils.getNetType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "registerUser:registerForPushFired:" + registerForPushFired + ", locationFired: " + locationFired + ", remoteParams: " + remoteParams + ", appId: " + appId);
        if (!registerForPushFired || !locationFired || remoteParams == null || appId == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OneSignal.registerUserTask();
                    OneSignalChromeTabAndroidFrame.setup(appId, userId, AdvertisingIdProviderGPS.getLastValue());
                }
                catch (JSONException t) {
                    OneSignal.Log(LOG_LEVEL.FATAL, "FATAL Error registering device!", t);
                }
            }
        }, "OS_REG_USER").start();
    }

    private static void registerUserTask() throws JSONException {
        String packageName = appContext.getPackageName();
        PackageManager packageManager = appContext.getPackageManager();
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("app_id", (Object)OneSignal.getSavedAppId());
        String adId = mainAdIdProvider.getIdentifier(appContext);
        if (adId != null) {
            deviceInfo.put("ad_id", (Object)adId);
        }
        deviceInfo.put("device_os", (Object)Build.VERSION.RELEASE);
        deviceInfo.put("timezone", OneSignal.getTimeZoneOffset());
        deviceInfo.put("language", (Object)OSUtils.getCorrectedLanguage());
        deviceInfo.put("sdk", (Object)VERSION);
        deviceInfo.put("sdk_type", (Object)sdkType);
        deviceInfo.put("android_package", (Object)packageName);
        deviceInfo.put("device_model", (Object)Build.MODEL);
        try {
            deviceInfo.put("game_version", packageManager.getPackageInfo((String)packageName, (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        deviceInfo.put("net_type", (Object)osUtils.getNetType());
        deviceInfo.put("carrier", (Object)osUtils.getCarrierName());
        deviceInfo.put("rooted", RootToolsInternalMethods.isRooted());
        OneSignalStateSynchronizer.updateDeviceInfo(deviceInfo);
        JSONObject pushState = new JSONObject();
        pushState.put("identifier", (Object)lastRegistrationId);
        pushState.put("subscribableStatus", subscribableStatus);
        pushState.put("androidPermission", OneSignal.areNotificationsEnabledForSubscribedState());
        pushState.put("device_type", osUtils.getDeviceType());
        OneSignalStateSynchronizer.updatePushState(pushState);
        if (shareLocation && lastLocationPoint != null) {
            OneSignalStateSynchronizer.updateLocation(lastLocationPoint);
        }
        OneSignalStateSynchronizer.readyToUpdate(true);
        waitingToPostStateSync = false;
    }

    @Deprecated
    public static void syncHashedEmail(final String email) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("SyncHashedEmail()")) {
            return;
        }
        if (!OSUtils.isValidEmail(email)) {
            return;
        }
        Runnable runSyncHashedEmail = new Runnable(){

            @Override
            public void run() {
                String trimmedEmail = email.trim();
                OneSignalStateSynchronizer.syncHashedEmail(trimmedEmail.toLowerCase());
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You should initialize OneSignal before calling syncHashedEmail! Moving this operation to a pending task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSyncHashedEmail));
            return;
        }
        runSyncHashedEmail.run();
    }

    public static void setEmail(@NonNull String email, EmailUpdateHandler callback) {
        OneSignal.setEmail(email, null, callback);
    }

    public static void setEmail(@NonNull String email) {
        OneSignal.setEmail(email, null, null);
    }

    public static void setEmail(@NonNull String email, @Nullable String emailAuthHash) {
        OneSignal.setEmail(email, emailAuthHash, null);
    }

    public static void setEmail(final @NonNull String email, final @Nullable String emailAuthHash, @Nullable EmailUpdateHandler callback) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setEmail()")) {
            return;
        }
        if (!OSUtils.isValidEmail(email)) {
            String errorMessage = "Email is invalid";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.VALIDATION, errorMessage));
            }
            OneSignal.Log(LOG_LEVEL.ERROR, errorMessage);
            return;
        }
        if (remoteParams != null && OneSignal.remoteParams.useEmailAuth && emailAuthHash == null) {
            String errorMessage = "Email authentication (auth token) is set to REQUIRED for this application. Please provide an auth token from your backend server or change the setting in the OneSignal dashboard.";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.REQUIRES_EMAIL_AUTH, errorMessage));
            }
            OneSignal.Log(LOG_LEVEL.ERROR, errorMessage);
            return;
        }
        emailUpdateHandler = callback;
        Runnable runSetEmail = new Runnable(){

            @Override
            public void run() {
                String trimmedEmail = email.trim();
                String internalEmailAuthHash = emailAuthHash;
                if (internalEmailAuthHash != null) {
                    internalEmailAuthHash.toLowerCase();
                }
                OneSignal.getCurrentEmailSubscriptionState(appContext).setEmailAddress(trimmedEmail);
                OneSignalStateSynchronizer.setEmail(trimmedEmail.toLowerCase(), internalEmailAuthHash);
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You should initialize OneSignal before calling setEmail! Moving this operation to a pending task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSetEmail));
            return;
        }
        runSetEmail.run();
    }

    public static void logoutEmail() {
        OneSignal.logoutEmail(null);
    }

    public static void logoutEmail(@Nullable EmailUpdateHandler callback) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("logoutEmail()")) {
            return;
        }
        if (OneSignal.getEmailId() == null) {
            String message = "logoutEmail not valid as email was not set or already logged out!";
            if (callback != null) {
                callback.onFailure(new EmailUpdateError(EmailErrorType.INVALID_OPERATION, "logoutEmail not valid as email was not set or already logged out!"));
            }
            OneSignal.Log(LOG_LEVEL.ERROR, "logoutEmail not valid as email was not set or already logged out!");
            return;
        }
        emailLogoutHandler = callback;
        Runnable emailLogout = new Runnable(){

            @Override
            public void run() {
                OneSignalStateSynchronizer.logoutEmail();
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You should initialize OneSignal before calling logoutEmail! Moving this operation to a pending task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(emailLogout));
            return;
        }
        emailLogout.run();
    }

    public static void setExternalUserId(@NonNull String externalId) {
        OneSignal.setExternalUserId(externalId, null);
    }

    public static void setExternalUserId(final @NonNull String externalId, final @Nullable OSExternalUserIdUpdateCompletionHandler completionCallback) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setExternalUserId()")) {
            return;
        }
        Runnable runSetExternalUserId = new Runnable(){

            @Override
            public void run() {
                if (externalId == null) {
                    OneSignal.Log(LOG_LEVEL.WARN, "External id can't be null, set an empty string to remove an external id");
                    return;
                }
                try {
                    OneSignalStateSynchronizer.setExternalUserId(externalId, completionCallback);
                }
                catch (JSONException exception) {
                    String operation = externalId.equals("") ? "remove" : "set";
                    OneSignal.onesignalLog(LOG_LEVEL.ERROR, "Attempted to " + operation + " external ID but encountered a JSON exception");
                    exception.printStackTrace();
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSetExternalUserId));
            return;
        }
        runSetExternalUserId.run();
    }

    public static void removeExternalUserId() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("removeExternalUserId()")) {
            return;
        }
        OneSignal.removeExternalUserId(null);
    }

    public static void removeExternalUserId(OSExternalUserIdUpdateCompletionHandler completionHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("removeExternalUserId()")) {
            return;
        }
        OneSignal.setExternalUserId("", completionHandler);
    }

    public static void sendTag(String key, String value) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendTag()")) {
            return;
        }
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        OneSignal.sendTags(keyValues, null);
    }

    public static void sendTags(final JSONObject keyValues, final ChangeTagsUpdateHandler changeTagsUpdateHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendTags()")) {
            return;
        }
        Runnable sendTagsRunnable = new Runnable(){

            @Override
            public void run() {
                if (keyValues == null) {
                    if (changeTagsUpdateHandler != null) {
                        changeTagsUpdateHandler.onFailure(new SendTagsError(-1, "Attempted to send null tags"));
                    }
                    return;
                }
                JSONObject existingKeys = OneSignalStateSynchronizer.getTags((boolean)false).result;
                JSONObject toSend = new JSONObject();
                Iterator keys = keyValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    try {
                        Object value = keyValues.opt(key);
                        if (value instanceof JSONArray || value instanceof JSONObject) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Omitting key '" + key + "'! sendTags DO NOT supported nested values!");
                            continue;
                        }
                        if (keyValues.isNull(key) || "".equals(value)) {
                            if (existingKeys == null || !existingKeys.has(key)) continue;
                            toSend.put(key, (Object)"");
                            continue;
                        }
                        toSend.put(key, (Object)value.toString());
                    }
                    catch (Throwable throwable) {}
                }
                if (!toSend.toString().equals("{}")) {
                    OneSignalStateSynchronizer.sendTags(toSend, changeTagsUpdateHandler);
                } else if (changeTagsUpdateHandler != null) {
                    changeTagsUpdateHandler.onSuccess(existingKeys);
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before modifying tags!Moving this operation to a pending task queue.");
            if (changeTagsUpdateHandler != null) {
                changeTagsUpdateHandler.onFailure(new SendTagsError(-1, "You must initialize OneSignal before modifying tags!Moving this operation to a pending task queue."));
            }
            OneSignal.addTaskToQueue(new PendingTaskRunnable(sendTagsRunnable));
            return;
        }
        sendTagsRunnable.run();
    }

    public static void postNotification(String json, PostNotificationResponseHandler handler) {
        try {
            OneSignal.postNotification(new JSONObject(json), handler);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Invalid postNotification JSON format: " + json);
        }
    }

    public static void postNotification(JSONObject json, final PostNotificationResponseHandler handler) {
        block8: {
            if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("postNotification()")) {
                return;
            }
            try {
                if (!json.has("app_id")) {
                    json.put("app_id", (Object)OneSignal.getSavedAppId());
                }
                if (!json.has("app_id")) {
                    if (handler != null) {
                        handler.onFailure(new JSONObject().put("error", (Object)"Missing app_id"));
                    }
                    return;
                }
                OneSignalRestClient.post("notifications/", json, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    public void onSuccess(String response) {
                        OneSignal.Log(LOG_LEVEL.DEBUG, "HTTP create notification success: " + (response != null ? response : "null"));
                        if (handler != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                if (jsonObject.has("errors")) {
                                    handler.onFailure(jsonObject);
                                } else {
                                    handler.onSuccess(new JSONObject(response));
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("create notification failed", statusCode, throwable, response);
                        if (handler != null) {
                            try {
                                if (statusCode == 0) {
                                    response = "{\"error\": \"HTTP no response error\"}";
                                }
                                handler.onFailure(new JSONObject(response));
                            }
                            catch (Throwable t) {
                                try {
                                    handler.onFailure(new JSONObject("{\"error\": \"Unknown response!\"}"));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
            catch (JSONException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "HTTP create notification json exception!", e);
                if (handler == null) break block8;
                try {
                    handler.onFailure(new JSONObject("{'error': 'HTTP create notification json exception!'}"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void getTags(final GetTagsHandler getTagsHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("getTags()")) {
            return;
        }
        if (getTagsHandler == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "getTagsHandler is null!");
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = pendingGetTagsHandlers;
                synchronized (arrayList) {
                    pendingGetTagsHandlers.add(getTagsHandler);
                    if (pendingGetTagsHandlers.size() > 1) {
                        return;
                    }
                }
                if (appContext == null) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before getting tags! Moving this tag operation to a pending queue.");
                    taskQueueWaitingForInit.add(new Runnable(){

                        @Override
                        public void run() {
                            OneSignal.runGetTags();
                        }
                    });
                    return;
                }
                OneSignal.runGetTags();
            }
        }, "OS_GETTAGS").start();
    }

    private static void runGetTags() {
        if (OneSignal.getUserId() == null) {
            return;
        }
        OneSignal.internalFireGetTagsCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalFireGetTagsCallbacks() {
        ArrayList<GetTagsHandler> arrayList = pendingGetTagsHandlers;
        synchronized (arrayList) {
            if (pendingGetTagsHandlers.size() == 0) {
                return;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UserStateSynchronizer.GetTagsResult tags = OneSignalStateSynchronizer.getTags(!getTagsCall);
                if (tags.serverSuccess) {
                    getTagsCall = true;
                }
                ArrayList arrayList = pendingGetTagsHandlers;
                synchronized (arrayList) {
                    for (GetTagsHandler handler : pendingGetTagsHandlers) {
                        handler.tagsAvailable(tags.result == null || tags.toString().equals("{}") ? null : tags.result);
                    }
                    pendingGetTagsHandlers.clear();
                }
            }
        }, "OS_GETTAGS_CALLBACK").start();
    }

    public static void deleteTag(String key) {
        OneSignal.deleteTag(key, null);
    }

    public static void deleteTag(String key, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTag()")) {
            return;
        }
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList, handler);
    }

    public static void deleteTags(Collection<String> keys) {
        OneSignal.deleteTags(keys, null);
    }

    public static void deleteTags(Collection<String> keys, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTags()")) {
            return;
        }
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags, handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        OneSignal.deleteTags(jsonArrayString, null);
    }

    public static void deleteTags(String jsonArrayString, ChangeTagsUpdateHandler handler) {
        try {
            OneSignal.deleteTags(new JSONArray(jsonArrayString), handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(JSONArray jsonArray, ChangeTagsUpdateHandler handler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("deleteTags()")) {
            return;
        }
        try {
            JSONObject jsonTags = new JSONObject();
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags, handler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void idsAvailable(IdsAvailableHandler inIdsAvailableHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("idsAvailable()")) {
            return;
        }
        idsAvailableHandler = inIdsAvailableHandler;
        Runnable runIdsAvailable = new Runnable(){

            @Override
            public void run() {
                if (OneSignal.getUserId() != null) {
                    OSUtils.runOnMainUIThread(new Runnable(){

                        @Override
                        public void run() {
                            OneSignal.internalFireIdsAvailableCallback();
                        }
                    });
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before getting tags! Moving this tag operation to a pending queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runIdsAvailable));
            return;
        }
        runIdsAvailable.run();
    }

    static void fireIdsAvailableCallback() {
        if (idsAvailableHandler != null) {
            OSUtils.runOnMainUIThread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.internalFireIdsAvailableCallback();
                }
            });
        }
    }

    private static synchronized void internalFireIdsAvailableCallback() {
        String userId;
        if (idsAvailableHandler == null) {
            return;
        }
        String regId = OneSignalStateSynchronizer.getRegistrationId();
        if (!OneSignalStateSynchronizer.getSubscribed()) {
            regId = null;
        }
        if ((userId = OneSignal.getUserId()) == null) {
            return;
        }
        idsAvailableHandler.idsAvailable(userId, regId);
        if (regId != null) {
            idsAvailableHandler = null;
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, OneSignalRestClient.ResponseHandler responseHandler) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("sendPurchases()")) {
            return;
        }
        if (OneSignal.getUserId() == null) {
            iapUpdateJob = new IAPUpdateJob(purchases);
            OneSignal.iapUpdateJob.newAsExisting = newAsExisting;
            OneSignal.iapUpdateJob.restResponseHandler = responseHandler;
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)OneSignal.getSavedAppId());
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            OneSignalRestClient.post("players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, responseHandler);
            if (OneSignal.getEmailId() != null) {
                OneSignalRestClient.post("players/" + OneSignal.getEmailId() + "/on_purchase", jsonBody, null);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static boolean openURLFromNotification(Context context, JSONArray dataArray) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return false;
        }
        int jsonArraySize = dataArray.length();
        boolean urlOpened = false;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                String url;
                JSONObject customJSON;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJSON = new JSONObject(data.optString("custom"))).has("u") || (url = customJSON.optString("u", null)) == null) continue;
                OSUtils.openURLInBrowser(url);
                urlOpened = true;
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for launching a web URL.", t);
            }
        }
        return urlOpened;
    }

    private static void runNotificationOpenedCallback(JSONArray dataArray, boolean shown, boolean fromAlert) {
        if (mInitBuilder == null || OneSignal.mInitBuilder.mNotificationOpenedHandler == null) {
            unprocessedOpenedNotifis.add(dataArray);
            return;
        }
        OneSignal.fireNotificationOpenedHandler(OneSignal.generateOsNotificationOpenResult(dataArray, shown, fromAlert));
    }

    @NonNull
    private static OSNotificationOpenResult generateOsNotificationOpenResult(JSONArray dataArray, boolean shown, boolean fromAlert) {
        int jsonArraySize = dataArray.length();
        boolean firstMessage = true;
        OSNotificationOpenResult openResult = new OSNotificationOpenResult();
        OSNotification notification = new OSNotification();
        notification.isAppInFocus = OneSignal.isAppActive();
        notification.shown = shown;
        notification.androidNotificationId = dataArray.optJSONObject(0).optInt("notificationId");
        String actionSelected = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                notification.payload = NotificationBundleProcessor.OSNotificationPayloadFrom(data);
                if (actionSelected == null && data.has("actionSelected")) {
                    actionSelected = data.optString("actionSelected", null);
                }
                if (firstMessage) {
                    firstMessage = false;
                    continue;
                }
                if (notification.groupedNotifications == null) {
                    notification.groupedNotifications = new ArrayList<OSNotificationPayload>();
                }
                notification.groupedNotifications.add(notification.payload);
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for callback.", t);
            }
        }
        openResult.notification = notification;
        openResult.action = new OSNotificationAction();
        openResult.action.actionID = actionSelected;
        openResult.action.type = actionSelected != null ? OSNotificationAction.ActionType.ActionTaken : OSNotificationAction.ActionType.Opened;
        openResult.notification.displayType = fromAlert ? OSNotification.DisplayType.InAppAlert : OSNotification.DisplayType.Notification;
        return openResult;
    }

    private static void fireNotificationOpenedHandler(final OSNotificationOpenResult openedResult) {
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                OneSignal.mInitBuilder.mNotificationOpenedHandler.notificationOpened(openedResult);
            }
        });
    }

    static void handleNotificationReceived(JSONArray data, boolean displayed, boolean fromAlert) {
        OSNotificationOpenResult openResult = OneSignal.generateOsNotificationOpenResult(data, displayed, fromAlert);
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled()) {
            trackFirebaseAnalytics.trackReceivedEvent(openResult);
        }
        if (mInitBuilder == null || OneSignal.mInitBuilder.mNotificationReceivedHandler == null) {
            return;
        }
        OneSignal.mInitBuilder.mNotificationReceivedHandler.notificationReceived(openResult.notification);
    }

    public static void handleNotificationOpen(Context inContext, JSONArray data, boolean fromAlert, String notificationId) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName(null)) {
            return;
        }
        OneSignal.notificationOpenedRESTCall(inContext, data);
        if (trackFirebaseAnalytics != null && OneSignal.getFirebaseAnalyticsEnabled()) {
            trackFirebaseAnalytics.trackOpenedEvent(OneSignal.generateOsNotificationOpenResult(data, true, fromAlert));
        }
        boolean urlOpened = false;
        boolean defaultOpenActionDisabled = "DISABLE".equals(OSUtils.getManifestMeta(inContext, "com.onesignal.NotificationOpened.DEFAULT"));
        if (!defaultOpenActionDisabled) {
            urlOpened = OneSignal.openURLFromNotification(inContext, data);
        }
        if (OneSignal.shouldInitDirectSessionFromNotificationOpen(inContext, fromAlert, urlOpened, defaultOpenActionDisabled)) {
            appEntryState = AppEntryAction.NOTIFICATION_CLICK;
            sessionManager.onDirectSessionFromNotificationOpen(notificationId);
        }
        OneSignal.runNotificationOpenedCallback(data, true, fromAlert);
    }

    static boolean startOrResumeApp(Context inContext) {
        Intent launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName());
        if (launchIntent != null) {
            launchIntent.setFlags(0x10020000);
            inContext.startActivity(launchIntent);
            return true;
        }
        return false;
    }

    private static boolean shouldInitDirectSessionFromNotificationOpen(Context context, boolean fromAlert, boolean urlOpened, boolean defaultOpenActionDisabled) {
        return !fromAlert && !urlOpened && !defaultOpenActionDisabled && !foreground && OneSignal.startOrResumeApp(context);
    }

    private static void notificationOpenedRESTCall(Context inContext, JSONArray dataArray) {
        for (int i = 0; i < dataArray.length(); ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                JSONObject customJson = new JSONObject(data.optString("custom", null));
                String notificationId = customJson.optString("i", null);
                if (postedOpenedNotifIds.contains(notificationId)) continue;
                postedOpenedNotifIds.add(notificationId);
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
                jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
                jsonBody.put("opened", true);
                jsonBody.put("device_type", osUtils.getDeviceType());
                OneSignalRestClient.put("notifications/" + notificationId, jsonBody, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("sending Notification Opened Failed", statusCode, throwable, response);
                    }
                });
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
            }
        }
    }

    private static void saveAppId(String appId) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_APP_ID", appId);
    }

    static String getSavedAppId() {
        return OneSignal.getSavedAppId(appContext);
    }

    private static String getSavedAppId(Context inContext) {
        if (inContext == null) {
            return null;
        }
        return OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_APP_ID", null);
    }

    static boolean getSavedUserConsentStatus() {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USER_PROVIDED_CONSENT", false);
    }

    static void saveUserConsentStatus(boolean consent) {
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USER_PROVIDED_CONSENT", consent);
    }

    private static String getSavedUserId(Context inContext) {
        if (inContext == null) {
            return null;
        }
        return OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", null);
    }

    static boolean hasUserId() {
        return OneSignal.getUserId() != null;
    }

    static String getUserId() {
        if (userId == null && appContext != null) {
            userId = OneSignal.getSavedUserId(appContext);
        }
        return userId;
    }

    static void saveUserId(String id2) {
        userId = id2;
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_PLAYER_ID", userId);
    }

    static boolean hasEmailId() {
        return !TextUtils.isEmpty((CharSequence)emailId);
    }

    static String getEmailId() {
        if (TextUtils.isEmpty((CharSequence)emailId) && appContext != null) {
            emailId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "OS_EMAIL_ID", null);
        }
        return emailId;
    }

    static void saveEmailId(String id2) {
        emailId = id2;
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "OS_EMAIL_ID", "".equals(emailId) ? null : emailId);
    }

    static boolean getFilterOtherGCMReceivers(Context context) {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_FILTER_OTHER_GCM_RECEIVERS", false);
    }

    static void saveFilterOtherGCMReceivers(boolean set) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_FILTER_OTHER_GCM_RECEIVERS", set);
    }

    static void updateUserIdDependents(String userId) {
        OneSignal.saveUserId(userId);
        OneSignal.fireIdsAvailableCallback();
        OneSignal.internalFireGetTagsCallbacks();
        OneSignal.getCurrentSubscriptionState(appContext).setUserId(userId);
        if (iapUpdateJob != null) {
            OneSignal.sendPurchases(OneSignal.iapUpdateJob.toReport, OneSignal.iapUpdateJob.newAsExisting, OneSignal.iapUpdateJob.restResponseHandler);
            iapUpdateJob = null;
        }
        OneSignalStateSynchronizer.refreshEmailState();
        OneSignalChromeTabAndroidFrame.setup(appId, userId, AdvertisingIdProviderGPS.getLastValue());
    }

    static void updateEmailIdDependents(String emailId) {
        OneSignal.saveEmailId(emailId);
        OneSignal.getCurrentEmailSubscriptionState(appContext).setEmailUserId(emailId);
        try {
            JSONObject updateJson = new JSONObject().put("parent_player_id", (Object)emailId);
            OneSignalStateSynchronizer.updatePushState(updateJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static boolean getFirebaseAnalyticsEnabled() {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_FIREBASE_TRACKING_ENABLED", false);
    }

    static boolean getClearGroupSummaryClick() {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "OS_CLEAR_GROUP_SUMMARY_CLICK", true);
    }

    public static void enableVibrate(boolean enable) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_VIBRATE_ENABLED", enable);
    }

    static boolean getVibrate() {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_VIBRATE_ENABLED", true);
    }

    public static void enableSound(boolean enable) {
        if (appContext == null) {
            return;
        }
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_SOUND_ENABLED", enable);
    }

    static boolean getSoundEnabled() {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "GT_SOUND_ENABLED", true);
    }

    static void setLastSessionTime(long time) {
        OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_SESSION_TIME", time);
    }

    private static long getLastSessionTime() {
        return OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_SESSION_TIME", -31000L);
    }

    public static void setInFocusDisplaying(OSInFocusDisplayOption displayOption) {
        OneSignal.mInitBuilder.mDisplayOptionCarryOver = true;
        OneSignal.mInitBuilder.mDisplayOption = displayOption;
    }

    public static void setInFocusDisplaying(int displayOption) {
        OneSignal.setInFocusDisplaying(OneSignal.getInFocusDisplaying(displayOption));
    }

    public static OSInFocusDisplayOption currentInFocusDisplayOption() {
        return OneSignal.mInitBuilder.mDisplayOption;
    }

    private static OSInFocusDisplayOption getInFocusDisplaying(int displayOption) {
        switch (displayOption) {
            case 0: {
                return OSInFocusDisplayOption.None;
            }
            case 1: {
                return OSInFocusDisplayOption.InAppAlert;
            }
            case 2: {
                return OSInFocusDisplayOption.Notification;
            }
        }
        if (displayOption < 0) {
            return OSInFocusDisplayOption.None;
        }
        return OSInFocusDisplayOption.Notification;
    }

    static boolean getNotificationsWhenActiveEnabled() {
        if (mInitBuilder == null) {
            return true;
        }
        return OneSignal.mInitBuilder.mDisplayOption == OSInFocusDisplayOption.Notification;
    }

    static boolean getInAppAlertNotificationEnabled() {
        if (mInitBuilder == null) {
            return false;
        }
        return OneSignal.mInitBuilder.mDisplayOption == OSInFocusDisplayOption.InAppAlert;
    }

    public static void setSubscription(final boolean enable) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setSubscription()")) {
            return;
        }
        Runnable runSetSubscription = new Runnable(){

            @Override
            public void run() {
                OneSignal.getCurrentSubscriptionState(appContext).setUserSubscriptionSetting(enable);
                OneSignalStateSynchronizer.setSubscription(enable);
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Moving subscription action to a waiting task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runSetSubscription));
            return;
        }
        runSetSubscription.run();
    }

    public static void setLocationShared(boolean enable) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("setLocationShared()")) {
            return;
        }
        shareLocation = enable;
        if (!enable) {
            OneSignalStateSynchronizer.clearLocation();
        }
        OneSignal.Log(LOG_LEVEL.DEBUG, "shareLocation:" + shareLocation);
    }

    public static void promptLocation() {
        OneSignal.promptLocation(null);
    }

    static void promptLocation(final @Nullable OSPromptActionCompletionCallback callback) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("promptLocation()")) {
            return;
        }
        Runnable runPromptLocation = new Runnable(){

            @Override
            public void run() {
                LocationGMS.LocationPromptCompletionHandler locationHandler = new LocationGMS.LocationPromptCompletionHandler(){

                    @Override
                    public LocationGMS.PermissionType getType() {
                        return LocationGMS.PermissionType.PROMPT_LOCATION;
                    }

                    @Override
                    public void complete(LocationGMS.LocationPoint point) {
                        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("promptLocation()")) {
                            return;
                        }
                        if (point != null) {
                            OneSignalStateSynchronizer.updateLocation(point);
                        }
                    }

                    @Override
                    void onAnswered(boolean accepted) {
                        super.onAnswered(accepted);
                        if (callback != null) {
                            callback.completed(accepted);
                        }
                    }
                };
                LocationGMS.getLocation(appContext, true, locationHandler);
                promptedLocation = true;
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not prompt for location at this time - moving this operation to awaiting queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runPromptLocation));
            return;
        }
        runPromptLocation.run();
    }

    public static void clearOneSignalNotifications() {
        Runnable runClearOneSignalNotifications = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
                try (Cursor cursor = null;){
                    SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
                    String[] retColumn = new String[]{"android_notification_id"};
                    cursor = readableDb.query("notification", retColumn, "dismissed = 0 AND opened = 0", null, null, null, null);
                    if (cursor.moveToFirst()) {
                        do {
                            int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                            notificationManager.cancel(existingId);
                        } while (cursor.moveToNext());
                    }
                    SQLiteDatabase writableDb = null;
                    try {
                        writableDb = dbHelper.getWritableDbWithRetries();
                        writableDb.beginTransaction();
                        String whereStr = "opened = 0";
                        ContentValues values = new ContentValues();
                        values.put("dismissed", Integer.valueOf(1));
                        writableDb.update("notification", values, whereStr, null);
                        writableDb.setTransactionSuccessful();
                    }
                    catch (Throwable t) {
                        OneSignal.Log(LOG_LEVEL.ERROR, "Error marking all notifications as dismissed! ", t);
                    }
                    finally {
                        if (writableDb != null) {
                            try {
                                writableDb.endTransaction();
                            }
                            catch (Throwable t) {
                                OneSignal.Log(LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                            }
                        }
                    }
                    BadgeCountUpdater.updateCount(0, appContext);
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notifications at this time - moving this operation toa waiting task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runClearOneSignalNotifications));
            return;
        }
        runClearOneSignalNotifications.run();
    }

    public static void cancelNotification(final int id2) {
        Runnable runCancelNotification = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
                SQLiteDatabase writableDb = null;
                try {
                    writableDb = dbHelper.getWritableDbWithRetries();
                    writableDb.beginTransaction();
                    String whereStr = "android_notification_id = " + id2 + " AND " + "opened" + " = 0 AND " + "dismissed" + " = 0";
                    ContentValues values = new ContentValues();
                    values.put("dismissed", Integer.valueOf(1));
                    int records = writableDb.update("notification", values, whereStr, null);
                    if (records > 0) {
                        NotificationSummaryManager.updatePossibleDependentSummaryOnDismiss(appContext, writableDb, id2);
                    }
                    BadgeCountUpdater.update(writableDb, appContext);
                    writableDb.setTransactionSuccessful();
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Error marking a notification id " + id2 + " as dismissed! ", t);
                }
                finally {
                    if (writableDb != null) {
                        try {
                            writableDb.endTransaction();
                        }
                        catch (Throwable t) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                        }
                    }
                }
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                notificationManager.cancel(id2);
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notification id: " + id2 + " at this time - movingthis operation to a waiting task queue. The notification will still be canceledfrom NotificationManager at this time.");
            taskQueueWaitingForInit.add(runCancelNotification);
            return;
        }
        runCancelNotification.run();
    }

    public static void cancelGroupedNotifications(final String group) {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("cancelGroupedNotifications()")) {
            return;
        }
        Runnable runCancelGroupedNotifications = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
                Cursor cursor = null;
                try {
                    SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
                    String[] retColumn = new String[]{"android_notification_id"};
                    String whereStr = "group_id = ? AND dismissed = 0 AND opened = 0";
                    String[] whereArgs = new String[]{group};
                    cursor = readableDb.query("notification", retColumn, whereStr, whereArgs, null, null, null);
                    while (cursor.moveToNext()) {
                        int notifId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                        if (notifId == -1) continue;
                        notificationManager.cancel(notifId);
                    }
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Error getting android notifications part of group: " + group, t);
                }
                finally {
                    if (cursor != null && !cursor.isClosed()) {
                        cursor.close();
                    }
                }
                SQLiteDatabase writableDb = null;
                try {
                    writableDb = dbHelper.getWritableDbWithRetries();
                    writableDb.beginTransaction();
                    String whereStr = "group_id = ? AND opened = 0 AND dismissed = 0";
                    String[] whereArgs = new String[]{group};
                    ContentValues values = new ContentValues();
                    values.put("dismissed", Integer.valueOf(1));
                    writableDb.update("notification", values, whereStr, whereArgs);
                    BadgeCountUpdater.update(writableDb, appContext);
                    writableDb.setTransactionSuccessful();
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Error marking a notifications with group " + group + " as dismissed! ", t);
                }
                finally {
                    if (writableDb != null) {
                        try {
                            writableDb.endTransaction();
                        }
                        catch (Throwable t) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                        }
                    }
                }
            }
        };
        if (appContext == null || OneSignal.shouldRunTaskThroughQueue()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notifications part of group " + group + " - movingthis operation to a waiting task queue.");
            OneSignal.addTaskToQueue(new PendingTaskRunnable(runCancelGroupedNotifications));
            return;
        }
        runCancelGroupedNotifications.run();
    }

    public static void removeNotificationOpenedHandler() {
        OneSignal.mInitBuilder.mNotificationOpenedHandler = null;
    }

    public static void removeInAppMessageClickHandler() {
        OneSignal.mInitBuilder.mInAppMessageClickHandler = null;
    }

    public static void removeNotificationReceivedHandler() {
        OneSignal.mInitBuilder.mNotificationReceivedHandler = null;
    }

    public static void addPermissionObserver(OSPermissionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not add permission observer");
            return;
        }
        OneSignal.getPermissionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentPermissionState(appContext).compare(OneSignal.getLastPermissionState(appContext))) {
            OSPermissionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentPermissionState(appContext));
        }
    }

    public static void removePermissionObserver(OSPermissionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not modify permission observer");
            return;
        }
        OneSignal.getPermissionStateChangesObserver().removeObserver(observer);
    }

    public static void addSubscriptionObserver(OSSubscriptionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not add subscription observer");
            return;
        }
        OneSignal.getSubscriptionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentSubscriptionState(appContext).compare(OneSignal.getLastSubscriptionState(appContext))) {
            OSSubscriptionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentSubscriptionState(appContext));
        }
    }

    public static void removeSubscriptionObserver(OSSubscriptionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not modify subscription observer");
            return;
        }
        OneSignal.getSubscriptionStateChangesObserver().removeObserver(observer);
    }

    public static void addEmailSubscriptionObserver(@NonNull OSEmailSubscriptionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not add email subscription observer");
            return;
        }
        OneSignal.getEmailSubscriptionStateChangesObserver().addObserver(observer);
        if (OneSignal.getCurrentEmailSubscriptionState(appContext).compare(OneSignal.getLastEmailSubscriptionState(appContext))) {
            OSEmailSubscriptionChangedInternalObserver.fireChangesToPublicObserver(OneSignal.getCurrentEmailSubscriptionState(appContext));
        }
    }

    public static void removeEmailSubscriptionObserver(@NonNull OSEmailSubscriptionObserver observer) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not modify email subscription observer");
            return;
        }
        OneSignal.getEmailSubscriptionStateChangesObserver().removeObserver(observer);
    }

    public static OSPermissionSubscriptionState getPermissionSubscriptionState() {
        if (OneSignal.shouldLogUserPrivacyConsentErrorMessageForMethodName("getPermissionSubscriptionState()")) {
            return null;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not get OSPermissionSubscriptionState");
            return null;
        }
        OSPermissionSubscriptionState status = new OSPermissionSubscriptionState();
        status.subscriptionStatus = OneSignal.getCurrentSubscriptionState(appContext);
        status.permissionStatus = OneSignal.getCurrentPermissionState(appContext);
        status.emailSubscriptionStatus = OneSignal.getCurrentEmailSubscriptionState(appContext);
        return status;
    }

    public static void addTriggers(Map<String, Object> triggers) {
        OSInAppMessageController.getController().addTriggers(triggers);
    }

    public static void addTriggersFromJsonString(String triggersJsonString) {
        try {
            JSONObject jsonObject = new JSONObject(triggersJsonString);
            OneSignal.addTriggers(JSONUtils.jsonObjectToMap(jsonObject));
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "addTriggersFromJsonString, invalid json", e);
        }
    }

    public static void addTrigger(String key, Object object) {
        HashMap<String, Object> triggerMap = new HashMap<String, Object>();
        triggerMap.put(key, object);
        OSInAppMessageController.getController().addTriggers(triggerMap);
    }

    public static void removeTriggersForKeys(Collection<String> keys) {
        OSInAppMessageController.getController().removeTriggersForKeys(keys);
    }

    public static void removeTriggersForKeysFromJsonArrayString(@NonNull String keys) {
        try {
            JSONArray jsonArray = new JSONArray(keys);
            Collection<String> keysCollection = OSUtils.extractStringsFromCollection(JSONUtils.jsonArrayToList(jsonArray));
            if (jsonArray.length() != keysCollection.size()) {
                OneSignal.Log(LOG_LEVEL.WARN, "removeTriggersForKeysFromJsonArrayString: Skipped removing non-String type keys ");
            }
            OSInAppMessageController.getController().removeTriggersForKeys(keysCollection);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "removeTriggersForKeysFromJsonArrayString, invalid json", e);
        }
    }

    public static void removeTriggerForKey(String key) {
        ArrayList<String> triggerKeys = new ArrayList<String>();
        triggerKeys.add(key);
        OSInAppMessageController.getController().removeTriggersForKeys(triggerKeys);
    }

    @Nullable
    public static Object getTriggerValueForKey(String key) {
        return OSInAppMessageController.getController().getTriggerValue(key);
    }

    public static void pauseInAppMessages(boolean pause) {
        OSInAppMessageController.getController().setInAppMessagingEnabled(!pause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(String id2, Context context) {
        if (id2 == null || "".equals(id2)) {
            return false;
        }
        boolean exists = false;
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        try (Cursor cursor = null;){
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            String[] retColumn = new String[]{"notification_id"};
            String[] whereArgs = new String[]{id2};
            cursor = readableDb.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
            exists = cursor.moveToFirst();
        }
        if (exists) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Duplicate GCM message received, skip processing of " + id2);
            return true;
        }
        return false;
    }

    static boolean notValidOrDuplicated(Context context, JSONObject jsonPayload) {
        String id2 = OneSignal.getNotificationIdFromGCMJsonPayload(jsonPayload);
        return id2 == null || OneSignal.isDuplicateNotification(id2, context);
    }

    static String getNotificationIdFromGCMJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            JSONObject customJSON = new JSONObject(jsonObject.getString("custom"));
            if (customJSON.has("i")) {
                return customJSON.optString("i", null);
            }
            OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'i' field in custom.");
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'custom' field in the JSONObject.");
        }
        return null;
    }

    static String getNotificationIdFromGCMBundle(@Nullable Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        try {
            if (bundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(bundle.getString("custom"));
                if (customJSON.has("i")) {
                    return customJSON.optString("i", null);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Could not parse bundle, probably not a OneSignal notification.", t);
        }
        return null;
    }

    private static String getNotificationIdFromGCMJsonPayload(JSONObject jsonPayload) {
        try {
            JSONObject customJSON = new JSONObject(jsonPayload.optString("custom"));
            return customJSON.optString("i", null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static boolean isAppActive() {
        return initDone && OneSignal.isForeground();
    }

    private static boolean isPastOnSessionTime() {
        return System.currentTimeMillis() - OneSignal.getLastSessionTime() >= 30000L;
    }

    static boolean areNotificationsEnabledForSubscribedState() {
        if (OneSignal.mInitBuilder.mUnsubscribeWhenNotificationsAreDisabled) {
            return OSUtils.areNotificationsEnabled(appContext);
        }
        return true;
    }

    static void handleSuccessfulEmailLogout() {
        if (emailLogoutHandler != null) {
            emailLogoutHandler.onSuccess();
            emailLogoutHandler = null;
        }
    }

    static void handleFailedEmailLogout() {
        if (emailLogoutHandler != null) {
            emailLogoutHandler.onFailure(new EmailUpdateError(EmailErrorType.NETWORK, "Failed due to network failure. Will retry on next sync."));
            emailLogoutHandler = null;
        }
    }

    static void fireEmailUpdateSuccess() {
        if (emailUpdateHandler != null) {
            emailUpdateHandler.onSuccess();
            emailUpdateHandler = null;
        }
    }

    static void fireEmailUpdateFailure() {
        if (emailUpdateHandler != null) {
            emailUpdateHandler.onFailure(new EmailUpdateError(EmailErrorType.NETWORK, "Failed due to network failure. Will retry on next sync."));
            emailUpdateHandler = null;
        }
    }

    static OSSessionManager getSessionManager() {
        return sessionManager;
    }

    static void sendClickActionOutcome(@NonNull String name) {
        OneSignal.sendClickActionOutcomeWithValue(name, 0.0f);
    }

    static void sendClickActionOutcomeWithValue(@NonNull String name, float value) {
        if (outcomeEventsController == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendClickOutcomeEventWithValue(name, value);
    }

    public static void sendOutcome(@NonNull String name) {
        OneSignal.sendOutcome(name, null);
    }

    public static void sendOutcome(@NonNull String name, OutcomeCallback callback) {
        if (!OneSignal.isValidOutcomeEntry(name)) {
            return;
        }
        if (outcomeEventsController == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendOutcomeEvent(name, callback);
    }

    static void sendClickActionUniqueOutcome(@NonNull String name) {
        if (outcomeEventsController == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendUniqueClickOutcomeEvent(name);
    }

    public static void sendUniqueOutcome(@NonNull String name) {
        OneSignal.sendUniqueOutcome(name, null);
    }

    public static void sendUniqueOutcome(@NonNull String name, OutcomeCallback callback) {
        if (!OneSignal.isValidOutcomeEntry(name)) {
            return;
        }
        if (outcomeEventsController == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendUniqueOutcomeEvent(name, callback);
    }

    public static void sendOutcomeWithValue(@NonNull String name, float value) {
        OneSignal.sendOutcomeWithValue(name, value, null);
    }

    public static void sendOutcomeWithValue(@NonNull String name, float value, OutcomeCallback callback) {
        if (!OneSignal.isValidOutcomeEntry(name) || !OneSignal.isValidOutcomeValue(value)) {
            return;
        }
        if (outcomeEventsController == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Make sure OneSignal.init is called first");
            return;
        }
        outcomeEventsController.sendOutcomeEventWithValue(name, value, callback);
    }

    private static boolean isValidOutcomeValue(float value) {
        if (value <= 0.0f) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Outcome value must be greater than 0");
            return false;
        }
        return true;
    }

    private static boolean isValidOutcomeEntry(String name) {
        if (name == null || name.isEmpty()) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Outcome name must not be empty");
            return false;
        }
        return true;
    }

    static {
        visualLogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.WARN;
        userId = null;
        emailId = null;
        appEntryState = AppEntryAction.APP_CLOSE;
        taskQueueWaitingForInit = new ConcurrentLinkedQueue();
        lastTaskId = new AtomicLong();
        mainAdIdProvider = new AdvertisingIdProviderGPS();
        sdkType = "native";
        osUtils = new OSUtils();
        shareLocation = true;
        mInitBuilder = new Builder();
        unprocessedOpenedNotifis = new ArrayList<JSONArray>();
        postedOpenedNotifIds = new HashSet();
        pendingGetTagsHandlers = new ArrayList();
        requiresUserPrivacyConsent = false;
    }

    static interface OSPromptActionCompletionCallback {
        public void completed(boolean var1);
    }

    public static interface OutcomeCallback {
        public void onSuccess(@Nullable OutcomeEvent var1);
    }

    private static class PendingTaskRunnable
    implements Runnable {
        private Runnable innerTask;
        private long taskId;

        PendingTaskRunnable(Runnable innerTask) {
            this.innerTask = innerTask;
        }

        @Override
        public void run() {
            this.innerTask.run();
            OneSignal.onTaskRan(this.taskId);
        }
    }

    private static class IAPUpdateJob {
        JSONArray toReport;
        boolean newAsExisting;
        OneSignalRestClient.ResponseHandler restResponseHandler;

        IAPUpdateJob(JSONArray toReport) {
            this.toReport = toReport;
        }
    }

    public static class Builder {
        Context mContext;
        NotificationOpenedHandler mNotificationOpenedHandler;
        NotificationReceivedHandler mNotificationReceivedHandler;
        InAppMessageClickHandler mInAppMessageClickHandler;
        boolean mPromptLocation;
        boolean mDisableGmsMissingPrompt;
        boolean mUnsubscribeWhenNotificationsAreDisabled;
        boolean mFilterOtherGCMReceivers;
        boolean mDisplayOptionCarryOver;
        OSInFocusDisplayOption mDisplayOption = OSInFocusDisplayOption.InAppAlert;

        private Builder() {
        }

        private Builder(Context context) {
            this.mContext = context;
        }

        private void setDisplayOptionCarryOver(boolean carryOver) {
            this.mDisplayOptionCarryOver = carryOver;
        }

        public Builder setNotificationOpenedHandler(NotificationOpenedHandler handler) {
            this.mNotificationOpenedHandler = handler;
            return this;
        }

        public Builder setNotificationReceivedHandler(NotificationReceivedHandler handler) {
            this.mNotificationReceivedHandler = handler;
            return this;
        }

        public Builder setInAppMessageClickHandler(InAppMessageClickHandler handler) {
            this.mInAppMessageClickHandler = handler;
            return this;
        }

        public Builder autoPromptLocation(boolean enable) {
            this.mPromptLocation = enable;
            return this;
        }

        public Builder disableGmsMissingPrompt(boolean disable) {
            this.mDisableGmsMissingPrompt = disable;
            return this;
        }

        public Builder inFocusDisplaying(OSInFocusDisplayOption displayOption) {
            this.mDisplayOptionCarryOver = false;
            this.mDisplayOption = displayOption;
            return this;
        }

        public Builder unsubscribeWhenNotificationsAreDisabled(boolean set) {
            this.mUnsubscribeWhenNotificationsAreDisabled = set;
            return this;
        }

        public Builder filterOtherGCMReceivers(boolean set) {
            this.mFilterOtherGCMReceivers = set;
            return this;
        }

        public void init() {
            OneSignal.init(this);
        }
    }

    public static interface PostNotificationResponseHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(JSONObject var1);
    }

    public static interface EmailUpdateHandler {
        public void onSuccess();

        public void onFailure(EmailUpdateError var1);
    }

    public static class EmailUpdateError {
        private EmailErrorType type;
        private String message;

        EmailUpdateError(EmailErrorType type, String message) {
            this.type = type;
            this.message = message;
        }

        public EmailErrorType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum EmailErrorType {
        VALIDATION,
        REQUIRES_EMAIL_AUTH,
        INVALID_OPERATION,
        NETWORK;

    }

    static interface OSInternalExternalUserIdUpdateCompletionHandler {
        public void onComplete(String var1, boolean var2);
    }

    public static interface OSExternalUserIdUpdateCompletionHandler {
        public void onComplete(JSONObject var1);
    }

    public static class SendTagsError {
        private String message;
        private int code;

        SendTagsError(int errorCode, String errorMessage) {
            this.message = errorMessage;
            this.code = errorCode;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static interface ChangeTagsUpdateHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(SendTagsError var1);
    }

    public static interface GetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface IdsAvailableHandler {
        public void idsAvailable(String var1, String var2);
    }

    public static interface NotificationReceivedHandler {
        public void notificationReceived(OSNotification var1);
    }

    public static interface InAppMessageClickHandler {
        public void inAppMessageClicked(OSInAppMessageAction var1);
    }

    public static interface NotificationOpenedHandler {
        public void notificationOpened(OSNotificationOpenResult var1);
    }

    static enum AppEntryAction {
        NOTIFICATION_CLICK,
        APP_OPEN,
        APP_CLOSE;


        boolean isNotificationClick() {
            return this.equals((Object)NOTIFICATION_CLICK);
        }

        boolean isAppOpen() {
            return this.equals((Object)APP_OPEN);
        }

        boolean isAppClose() {
            return this.equals((Object)APP_CLOSE);
        }
    }

    public static enum OSInFocusDisplayOption {
        None,
        InAppAlert,
        Notification;

    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

